import {
    AlertDialog,
    AlertDialogAction,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogHeader,
    AlertDialogTitle,
} from '@/components/shadcn/alert-dialog';
import React from 'react';
import { useTranslation } from 'react-i18next';

export const ErrorDialog = ({ children }: { children: React.ReactNode }) => {
    const { t } = useTranslation();

    return (
        <AlertDialog open={true}>
            <AlertDialogContent>
                <AlertDialogHeader>
                    <AlertDialogTitle>{t('An Unknown Error Has Occured.')}</AlertDialogTitle>
                    <AlertDialogDescription>{children}</AlertDialogDescription>
                    <a href="/nagioslogserver" target="_parent">
                        <AlertDialogAction>{t('Go Home')}</AlertDialogAction>
                    </a>
                </AlertDialogHeader>
            </AlertDialogContent>
        </AlertDialog>
    );
};
