import {
    AlertDialog,
    AlertDialogAction,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogHeader,
    AlertDialogTitle,
} from '@/components/shadcn/alert-dialog';
import { useTranslation } from 'react-i18next';

export const SessionExpiredDialog = () => {
    const { t } = useTranslation();

    return (
        <AlertDialog open={true}>
            <AlertDialogContent>
                <AlertDialogHeader>
                    <AlertDialogTitle>{t('Your session has timed out.')}</AlertDialogTitle>
                    <AlertDialogDescription>{t('You have been automatically logged out due to inactivity.')}</AlertDialogDescription>
                    <a href="/nagioslogserver/login?redirect=">
                        <AlertDialogAction>{t('Log in')}</AlertDialogAction>
                    </a>
                </AlertDialogHeader>
            </AlertDialogContent>
        </AlertDialog>
    );
};
