import { useEffect, useRef, useState } from 'react';
import { Input } from '@/components/shadcn/input';
import { Label } from '@/components/shadcn/label';
import { Button } from '@/components/shadcn/button';
import EditOutlinedIcon from '@mui/icons-material/EditOutlined';

import { cn } from "@/lib/utils";

export interface EditableLabelProps  {
    onSave: (value: string) => void,
    placeholder?: string,
    value?: string,
    className?: string,
    inputClassName?: string,
    labelClassName?: string,
}

export const EditableLabel = ({
    onSave,
    placeholder,
    value,
    className,
    inputClassName,
    labelClassName
}: EditableLabelProps) => {
    const [isEditing, setIsEditing] = useState(false);
    const [current, setCurrent] = useState(value);
    const [previous, setPrevious] = useState(value);
    const inputField = useRef(null);
    
    const onEdit = () => {
        setIsEditing(true);
    }

    const onKeyUp = (e: any) => {
        if (e.key === 'Escape') {
            setCurrent(previous);
            setIsEditing(false);
        } else if (e.key === 'Enter') {
            setCurrent(e.target.value);
            setPrevious(e.target.value);
            setIsEditing(false);
            onSave(e.target.value);
        }
    }

    useEffect(() => {
        if (isEditing) {
            if (inputField.current) {
                //@ts-ignore
                inputField.current.focus();
            }
        }
    }, [isEditing, inputField] )

    return (
        <div className={cn(className)}>
            <Label className={cn(labelClassName)} style={{display:(isEditing) ? "none" : "block"}}>{value}</Label>
            <Input 
                className={cn(inputClassName, 'flex-grow')} 
                style={{display:(isEditing) ? "block" : "none"}}
                type="text"
                placeholder={placeholder}
                value={current}
                ref={inputField}
                onChange={(e) => setCurrent(e.target.value)}
                onKeyUp={onKeyUp}
            />
            <Button variant='ghost' size="icon" onClick={onEdit} style={{display:(isEditing) ? "none" : "block"}}>
                <EditOutlinedIcon fontSize="small"/>
            </Button>
        </div>
    )
}