"use client"

import { Legend, Tooltip, XAxis, YAxis, BarChart, Bar } from 'recharts';
import { useState, useEffect } from "react"

import { Card, CardContent } from "@/components/shadcn/card";
import {
  ChartConfig,
  ChartContainer,
} from "@/components/shadcn/chart"

import { PanelConfigData, QueryPanelDisplayData } from '@/lib/types';
import axios from 'axios';

interface TermData {
  key: string,
  doc_count: number,
  fill: string
}

const chartConfig = {
  count: {
    label: "Log Entries",
  },
  syslog: {
    label: "Syslog",
    color: "hsl(var(--chart-1))",
  },
  ssh: {
    label: "SSH",
    color: "hsl(var(--chart-2))",
  },
  apache: {
    label: "Apache",
    color: "hsl(var(--chart-3))",
  },
  mysql: {
    label: "MySQL",
    color: "hsl(var(--chart-4))",
  },
  eventlog: {
    label: "Event Log",
    color: "hsl(var(--chart-5))",
  },
  other: {
    label: "Other",
    color: "hsl(var(--chart-1))",
  },
} satisfies ChartConfig

export interface HitsPanelData extends PanelConfigData {};

export interface HitsPanelDisplayData extends QueryPanelDisplayData {
  panelConfig: HitsPanelData,
};
   
export function Hits(data: HitsPanelDisplayData) {
  const [chartData, setChartData] = useState<TermData[]>([]);

  const reqBody = {
    "@timestamp": {
      "from": data.range.startTime.toDate().getTime(),
      "to": data.range.endTime.toDate().getTime(),
    },
    "queries": data.queries,
    "filters": data.filters,
  };
   
  useEffect(() => {
    updateData();
  }, [data]);
  
  const updateData = async() => {
    axios.post('/nagioslogserver/api/dashboards/hits', reqBody)
      .then((hitsData: any) => {
      setChartData([
        {
          key: 'Log Entries',
          doc_count: hitsData.data.hits.total.value,
          fill:'hsl(var(--chart-1))',
        }
      ]);
    })
    .catch(err => console.error('Error fetching data:', err));
  };
   
  return (
    <Card className="flex flex-col">
      <CardContent className="flex-1 pb-0">
        <ChartContainer
          config={chartConfig}
          className="mx-auto aspect-square max-h-[500px]"
        >
          <BarChart data={chartData}>
            <Bar dataKey="doc_count" />
            <XAxis dataKey="key" style={{ fill: 'hsl(var(--foreground))'}} />
            <Legend />
            <YAxis style={{ fill: 'hsl(var(--foreground))'}} />
            <Tooltip />
          </BarChart>
        </ChartContainer>
      </CardContent>
    </Card>
  )
}
       