import { subQuery } from '@/dashboard/queries/types';

export const CustomizedLegend = ({ queries, counts } : { queries: subQuery[], counts?: { [k: string]: number } }) => {
    return (
      <div className="mt-2 flex items-center justify-center pt-3 -translate-y-2 flex-wrap gap-2 [&>*]:basis-1/4 [&>*]:justify-center max-h-[75px] overflow-y-auto">
        {
          queries.map((query, index) => (
            <div className="flex items-center gap-1.5 [&>svg]:h-3 [&>svg]:w-3 [&>svg]:text-muted-foreground" key={`query-${index}`}>
              <div
                className="h-2 w-2 shrink-0 rounded-[2px]"
                style={{
                  backgroundColor: query.color,
                }}
              />
              <div className="max-w-72 truncate">{query.query}</div>
              {(counts && (counts.hasOwnProperty(query.query) || counts.hasOwnProperty(index))) &&
                <div className="max-w-72 truncate">{'(' + String(counts.hasOwnProperty(query.query)? counts[query.query] : counts[index]) + ')'}</div>
              }
            </div>
          ))
        }
      </div>
    )
  }