import { TooltipProps } from 'recharts';
import { ValueType, NameType } from 'recharts/types/component/DefaultTooltipContent';
import { subQuery } from '@/dashboard/queries/types';

export const CustomizedTooltip = ({ active, payload, label, queries }: TooltipProps<ValueType, NameType> & { queries: subQuery[] }) => {
  return (
    <div className="grid min-w-[8rem] items-start gap-1.5 rounded-lg border border-border/50 bg-background px-2.5 py-1.5 text-xs shadow-xl w-[200px]">
      <div className="font-medium">{label}</div>
      <div className="grid gap-1.5">
        {
          queries.map((query, index) => {
            if (active && payload) {
              return (
                <div className="flex w-full flex-wrap gap-2 [&>svg]:h-2.5 [&>svg]:w-2.5 [&>svg]:text-muted-foreground items-center">
                  <div
                    className="h-2 w-2 shrink-0 rounded-[2px]"
                    style={{
                      backgroundColor: query.color,
                    }}
                  />
                  <div className="flex flex-1 justify-between leading-none items-center">
                    <div className="grid gap-1.5">
                      <div className="text-muted-foreground max-w-24 truncate">{query.query}</div>
                    </div>
                    <span className="font-mono font-medium tabular-nums text-foreground">{payload[index] && payload[index].payload[`doc_count${index}`]}</span>
                  </div>
                </div>
              )
            }
          })
        }
      </div>
    </div>
  )
}