import {
    Alert,
    AlertDescription,
    AlertTitle,
} from "@/components/shadcn/alert";
import ErrorOutlineOutlinedIcon from '@mui/icons-material/ErrorOutlineOutlined';
import { panelError } from '@/components/charts/types';
import { useTranslation } from 'react-i18next';

export const PanelError = ({ error }: { error: panelError }) => {

    const { t } = useTranslation();

    return (
        <div className="flex justify-center">
            <Alert variant="destructive" className="w-5/6">
                <ErrorOutlineOutlinedIcon fontSize="small" style={{top: "0.85rem"}}/>
                <AlertTitle>{t('Yikes!')}</AlertTitle>
                <AlertDescription>
                    <div className="flex flex-col gap-4 py-4 whitespace-nowrap overflow-auto">
                        {error.type} - {error.reason}
                        {error.root_cause.map((cause) => {
                            return (
                                <div className="flex">
                                    {cause.index} - {cause.type} - {cause.reason}
                                </div>
                            )
                        })}
                    </div>
                </AlertDescription>
            </Alert>
        </div>
    )
}