import { useState, useEffect } from 'react';
import { ResponsiveLine } from '@nivo/line';

interface LogData {
    key_as_string: string;
    key: number;
    doc_count: number;
}

function LogCount15Minutes() {
    const [data, setData] = useState<any[]>([]);
  
    useEffect(() => {
      fetch('/nagioslogserver/api/chart/log_count_15_minutes', { method: 'POST' })
        .then(res => res.json())
        .then((data: LogData[]) => {
          const formattedData = data.map(d => ({
            x: new Date(d.key_as_string).toISOString(), // Use full ISO string for datetime
            y: d.doc_count
          }));
          setData([{ id: 'log_count', data: formattedData }]);
        })
        .catch(err => console.error('Error fetching data:', err));
    }, []);

  return (
    <div id="chart" style={{ height: '400px' }}>
      {data.length > 0 && (
        <ResponsiveLine
          data={data}
          margin={{ top: 50, right: 110, bottom: 50, left: 60 }}
          xScale={{ type: 'time', format: '%Y-%m-%dT%H:%M:%S.%LZ', precision: 'minute' }}
          xFormat="time:%Y-%m-%dT%H:%M:%S.%LZ"
          yScale={{
            type: 'linear',
            min: 'auto',
            max: 'auto',
            stacked: true,
            reverse: false
          }}
          axisTop={null}
          axisRight={null}
          axisBottom={{
            format: '%H:%M:%S',
            tickValues: 'every 1 minute',
            tickSize: 5,
            tickPadding: 5,
            tickRotation: 0,
            legend: 'Time',
            legendOffset: 36,
            legendPosition: 'middle'
          }}
          axisLeft={{
            tickSize: 5,
            tickPadding: 5,
            tickRotation: 0,
            legend: 'Doc Count',
            legendOffset: -40,
            legendPosition: 'middle',
            format: value => `${value.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ',')}`
          }}
          colors={{ scheme: 'set2' }}
          lineWidth={3}
          pointSize={10}
          pointColor={{ theme: 'background' }}
          pointBorderWidth={2}
          pointBorderColor={{ from: 'serieColor' }}
          pointLabelYOffset={-12}
          useMesh={true}
          legends={[
            {
              anchor: 'bottom-right',
              direction: 'column',
              justify: false,
              translateX: 100,
              translateY: 0,
              itemsSpacing: 0,
              itemDirection: 'left-to-right',
              itemWidth: 80,
              itemHeight: 20,
              itemOpacity: 0.75,
              symbolSize: 12,
              symbolShape: 'circle',
              symbolBorderColor: 'rgba(0, 0, 0, .5)',
              effects: [
                {
                  on: 'hover',
                  style: {
                    itemBackground: 'rgba(0, 0, 0, .03)',
                    itemOpacity: 1
                  }
                }
              ]
            }
          ]}
        />
      )}
    </div>
  );
}

export default LogCount15Minutes;