import {
  Card,
  CardContent,
  CardDescription,
  CardFooter,
  CardHeader,
  CardTitle,
} from "@/components/shadcn/card";


export function NumericChart({ data, title, description, link }: { data: number; title: string; description?: string; link?: string }) {
  const handleClick = () => {
    if (link) {
      window.location.href = link;
    }
  };

  const cardProps = link
    ? { className: "flex flex-col w-full h-full cursor-pointer", onClick: handleClick }
    : { className: "flex flex-col w-full h-full" };

  return (
    <Card {...cardProps}>
      <CardHeader className="items-center pb-0">
        <CardTitle>{title}</CardTitle>
        {description && <CardDescription>{description}</CardDescription>}
      </CardHeader>
      <CardContent className="flex-1 pb-0 flex items-center justify-center">
        <div className="text-6xl font-bold">{data}</div>
      </CardContent>
      <CardFooter className="flex-col gap-2 text-sm">
      </CardFooter>
    </Card>
  );
}
