import { Toast, ToastClose, ToastDescription, ToastProvider, ToastTitle, ToastViewport } from '@/components/shadcn/toast';
import { useToast } from '@/components/shadcn/use-toast';
import CheckCircleIcon from '@mui/icons-material/CheckCircle';
import ErrorIcon from '@mui/icons-material/Error';

export function Toaster() {
    const { toasts } = useToast();

    return (
        <ToastProvider>
            {toasts.map(function ({ id, title, description, action, variant, ...props }) {
                return (
                    <Toast key={id} {...props}>
                        <div className="grid gap-1">
                            <div className="flex">
                                {variant == 'success' && <CheckCircleIcon fontSize="small" className="mr-2 text-success" />}
                                {variant == 'error' && <ErrorIcon fontSize="small" className="mr-2 text-destructive" />}
                                {title && <ToastTitle>{title}</ToastTitle>}
                            </div>
                            {description && <ToastDescription>{description}</ToastDescription>}
                        </div>
                        {action}
                        <ToastClose />
                    </Toast>
                );
            })}
            <ToastViewport />
        </ToastProvider>
    );
}
