import { Panel } from '@/dashboard/panels/Panel';
import { PanelConfig } from '@/lib/types';
import { dashboardStore } from '@/dashboard/Dashboard';
import GridLayout, { WidthProvider, Responsive, Layout } from "react-grid-layout";
import '/node_modules/react-grid-layout/css/styles.css';
import '/node_modules/react-resizable/css/styles.css';
import { useDashboardContext } from '@/dashboard/contexts/DashboardContext';

const ResponsiveReactGridLayout = WidthProvider(Responsive);

type DashboardRowProps = {
  rowId: string,
  uneditable?: boolean
  panels: PanelConfig[],
};

export const DashboardRow = (props: DashboardRowProps) => {
  const { definition, setDefinition } = dashboardStore();
  const { isExporting } = useDashboardContext().dashboardMetaInfo;

  const handleLayoutChange = (currentLayout: Layout[]) => {
    const newRows = definition.rows.map((row) => {
      if (row.id == props.rowId) {
        row.panels = row.panels.map((panel) => {
          currentLayout.forEach((layoutItem: {i: string, x: number, y: number, w: number, h: number}) => {
            const panelid = layoutItem.i;
            if (panel.id == panelid) {
              panel.x = layoutItem.x;
              panel.y = layoutItem.y;
              panel.width = layoutItem.w;
              panel.height = layoutItem.h;
            }
          })
          return panel;
        })
      }
      return row;
    })

    setDefinition({...definition, rows: newRows});
  }

  if (isExporting) { 
    return (
      <GridLayout
        className="layout"
        cols={24}
        width={1450}
        rowHeight={50}
      >
        {props.panels.map((panel) => {
          return (
            <div key={panel.id} data-grid={{ x: panel.x, y: panel.y, w: panel.width, h: panel.height }}>
              <Panel
                panel={panel}
                rowId={props.rowId}
              />
            </div>
          )
        })}
      </GridLayout>
    );
  } else {
    return (
      <ResponsiveReactGridLayout
        className="layout"
        breakpoints={{ lg: 1200 }}
        cols={{ lg: 24 }}
        onLayoutChange={handleLayoutChange}
        draggableHandle=".draggable"
        isResizable={!(props.uneditable)}
        isDraggable={!(props.uneditable)}
        resizeHandles={['sw', 'se']}
        rowHeight={50}
      >
        {props.panels.map((panel) => {
          return (
            <div key={panel.id} data-grid={{ x: panel.x, y: panel.y, w: panel.width, h: panel.height }}>
              <Panel
                panel={panel}
                rowId={props.rowId}
              />
            </div>
          )
        })}
      </ResponsiveReactGridLayout>
    );
  }
 
};