import axios from 'axios';
import { alert } from '@/dashboard/alerts/types';

export const addAlert = ({ data }: { data: alert }) => {
    return axios.post('/nagioslogserver/api/alerts/post',
        {
            ...data,
        }
    );
}

export const getNrdp = () => {
    return axios.get('/nagioslogserver/api/nrdp/get');
}

export const getSnmp = () => {
    return axios.get('/nagioslogserver/api/snmp/get');
}

export const getUsers = () => {
    return axios.get('/nagioslogserver/api/users_v2/get');
}

export const getTemplates = () => {
    return axios.get('/nagioslogserver/api/templates/get');
}