import { deleteUserEasyButton } from '@/dashboard/easybuttons/queries';
import { Button } from '@/components/shadcn/button';
import { toast } from '@/components/shadcn/use-toast';
// import { useAuth } from '@/contexts/AuthContext';
import { useTranslation } from 'react-i18next';
import { useMutation, useQueryClient } from '@tanstack/react-query';
import { AxiosError } from 'axios';

export const DeleteUserEasyButtonDialog = ({ id, setOpen } : { id: string; setOpen: (open: boolean) => void}) => {
    const { t } = useTranslation();
    const queryClient = useQueryClient();

    const deleteUserEasyButtonMutation = useMutation({
        mutationFn: deleteUserEasyButton,
        onSuccess: () => {
            queryClient.invalidateQueries({ queryKey: ['easybutton'] });
            toast({
                title: t('Query template deleted.'),
                variant: 'success',
            });
            setOpen(false);
        },
        onError: (error: AxiosError<{ message: string }>) => {
            toast({
                title: t('Failed to delete query template.'),
                variant: 'error',
                description: error.response?.data.message,
            });
            setOpen(false);
        },
    });

    return (
        <Button onClick={() => deleteUserEasyButtonMutation.mutate(id)} variant="destructive">
            {t('Delete')}
        </Button>
    );
};
