import axios from 'axios';
import { easybutton } from '@/dashboard/easybuttons/types';

export const getUserEasyButtons = () => {
    return axios.get('/nagioslogserver/api/easybuttons/get');
}

export const addUserEasyButton = (data: { name: string; query: string; global: boolean; }) => {
    return axios.post(
        '/nagioslogserver/api/easybuttons/post',
        {
            ...data,
        }
    );
};

export const editUserEasyButton = (data: {id: string; name: string; query: string; global: boolean; }) => {
    return axios.put(
        '/nagioslogserver/api/easybuttons/put',
        {
            ...data,
        }
    );
};

export const deleteUserEasyButton = (id: string) => {
    return axios.delete('/nagioslogserver/api/easybuttons/delete', {
        data: {
            id: id,
        },
    });
};

export const defaultEasyButtons: easybutton[] = [
        {id: 'default15', icon: "warning", name: "300", query: '(http.response.status_code:[300 TO 310])', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Display logs that report url redirects."},
        {id: 'default16', icon: "warning", name: "401", query: '(http.response.status_code:401)', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Display logs that report 401 errors."},
        {id: 'default01', icon: "warning", name: "404", query: '(http.response.status_code:404)', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Display logs that report 404 errors."},
        {id: 'default02', icon: "error", name: "500", query: '(http.response.status_code:[500 TO 505])', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Display logs that report 500, 501, 502, 503, 504 and 505 errors from both Apache and IIS sources."},
        {id: 'default03', icon: "terminal", name: "SSH", query: '(process.name:sshd)', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Filter logs that indicate SSH connection attempts, errors, timeouts, and other related activities."},
        {id: 'default04', icon: "folder", name: "AD Errors", query: '((message:(AD OR Topology OR Replication OR replicated OR DNS)) AND (event.severity:(>2)))', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Show logs that indicate specific error events from Active Directory, such as replication and DNS issues."},
        {id: 'default05', icon: "lock", name: "Account Lockout", query: '(event.id:4740)', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Retrieve logs about accounts being locked out due to multiple failed login attempts or other security reasons."},
        {id: 'default06', icon: "key", name: "Password Change", query: '(event.id:(4723 OR 4724 OR 4738))', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Show logs where account passwords have been changed or reset."},
        {id: 'default07', icon: "person_off", name: "Failed Login", query: '(event.id:4625)', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Retrieve logs related to failed login attempts on the system."},
        {id: 'default08', icon: "mail", name: "Sendmail", query: '((message:sendmail) OR (process.name:sendmail))', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Display logs associated with the sendmail service, including failed deliveries and authentication warnings."},
        {id: 'default09', icon: "storage", name: "MySQL Errors", query: '(process.name:mysqld_log)', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Filter logs related to MySQL database errors, such as access denials, syntax errors, and connection issues."},
        {id: 'default10', icon: "wifi_off", name: "Network Outages", query: '((message:(network OR DHCP OR TCP OR DNS OR logon OR VPN OR link)) AND ((log.syslog.severity.code:(<5)) OR (event.severity:(>2))))', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Filter logs indicating network outages, failures, and disconnections."},
        {id: 'default11', icon: "security", name: "Windows Firewall", query: '((message:firewall) OR (event.id:(2004 OR 2005 OR 2006 OR 2009 OR 2033 OR 4946 OR 4947 OR 4950 OR 4954 OR 5025 OR 5031 OR 5032)))', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Display logs pertaining to the Windows Firewall, capturing both allowed and blocked events."},
        {id: 'default12', icon: "desktop_windows", name: "Windows Updates", query: '((message:update) AND (event.id:(17 OR 19 OR 20 OR 24 OR 25 OR 35)))', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Retrieve logs related to Windows Update events, both successful and unsuccessful."},
        {id: 'default13', icon: "desktop_windows", name: "Windows Debug", query: '(event.severity:1)', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Retrieve logs related to debugging."},
        {id: 'default14', icon: "terminal", name: "Linux Debug", query: '(log.syslog.severity.code:7)', default: true, global:false, user_id: '1', active: false, query_id: '', title: "Retrieve logs related to debugging."},
    ]
