import { query } from '@/dashboard/queries/types';
import { easybutton, easybuttondisplay } from '@/dashboard/easybuttons/types';
import { create } from 'zustand';
// import WarningIcon from '@mui/icons-material/Warning';
// import ErrorIcon from '@mui/icons-material/Error';
// import TerminalIcon from '@mui/icons-material/Terminal';
// import FolderIcon from '@mui/icons-material/Folder';
// import LockIcon from '@mui/icons-material/Lock';
// import KeyIcon from '@mui/icons-material/Key';
// import PersonOffIcon from '@mui/icons-material/PersonOff';
// import MailIcon from '@mui/icons-material/Mail';
// import StorageIcon from '@mui/icons-material/Storage';
// import WifiOffIcon from '@mui/icons-material/WifiOff';
// import SecurityIcon from '@mui/icons-material/Security';
// import DesktopWindowsIcon from '@mui/icons-material/DesktopWindows';

type easybuttonstore = {
    display: easybuttondisplay,
    setDisplay: (newDisplay: easybuttondisplay) => void,
    queries: query[],
    setQueries: (newQueries: query[]) => void,
    userEasyButtons: easybutton[],
    setUserEasyButtons: (newButtons: easybutton[]) => void,
    editingButtonId: string,
    setEditingButtonId: (newButtonId: string) => void,
}

export const easyButtonStore = create<easybuttonstore>((set) => ({
    display: {show_default_buttons: true, show_global_buttons: true},
    setDisplay: (newDisplay: easybuttondisplay) => set(() => ({display: newDisplay})),
    queries: [],
    setQueries: (newQueries: query[]) => set(() => ({queries: newQueries})),
    userEasyButtons: [],
    setUserEasyButtons: (newButtons: easybutton[]) => set(() => ({userEasyButtons: newButtons})),
    editingButtonId: '',
    setEditingButtonId: (newButtonId: string) => set(() => ({editingButtonId: newButtonId})),
}))