// // @ts-nocheck
// import React, { useState } from 'react';
// import { DragDropContext, Droppable, Draggable } from 'react-beautiful-dnd';
// import { LineChart, Line, XAxis, YAxis, CartesianGrid, Tooltip, Legend, ResponsiveContainer } from 'recharts';
// import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
// import { Button } from "@/components/ui/button";

// // Mock data
// const mockData = [
//   {
//     id: 'row1',
//     title: 'System Overview',
//     panels: [
//       { id: 'panel1', title: 'CPU Usage', type: 'line' },
//       { id: 'panel2', title: 'Memory Usage', type: 'line' },
//     ],
//   },
//   {
//     id: 'row2',
//     title: 'Network Statistics',
//     panels: [
//       { id: 'panel3', title: 'Network In', type: 'line' },
//       { id: 'panel4', title: 'Network Out', type: 'line' },
//     ],
//   },
// ];

// const mockChartData = [
//   { name: 'Page A', uv: 4000, pv: 2400, amt: 2400 },
//   { name: 'Page B', uv: 3000, pv: 1398, amt: 2210 },
//   { name: 'Page C', uv: 2000, pv: 9800, amt: 2290 },
//   { name: 'Page D', uv: 2780, pv: 3908, amt: 2000 },
//   { name: 'Page E', uv: 1890, pv: 4800, amt: 2181 },
// ];

// const Dashboard = () => {
//   const [rows, setRows] = useState(mockData);

//   const onDragEnd = (result) => {
//     if (!result.destination) return;

//     const newRows = Array.from(rows);
//     const [reorderedItem] = newRows.splice(result.source.index, 1);
//     newRows.splice(result.destination.index, 0, reorderedItem);

//     setRows(newRows);
//   };

//   const deleteRow = (rowId) => {
//     setRows(rows.filter(row => row.id !== rowId));
//   };

//   const deletePanel = (rowId, panelId) => {
//     setRows(rows.map(row => {
//       if (row.id === rowId) {
//         return {
//           ...row,
//           panels: row.panels.filter(panel => panel.id !== panelId)
//         };
//       }
//       return row;
//     }));
//   };

//   return (
//     <DragDropContext onDragEnd={onDragEnd}>
//       <Droppable droppableId="dashboard">
//         {(provided) => (
//           <div {...provided.droppableProps} ref={provided.innerRef} className="space-y-4">
//             {rows.map((row, index) => (
//               <Draggable key={row.id} draggableId={row.id} index={index}>
//                 {(provided) => (
//                   <Row
//                     ref={provided.innerRef}
//                     {...provided.draggableProps}
//                     {...provided.dragHandleProps}
//                     row={row}
//                     onDeleteRow={() => deleteRow(row.id)}
//                     onDeletePanel={(panelId) => deletePanel(row.id, panelId)}
//                   />
//                 )}
//               </Draggable>
//             ))}
//             {provided.placeholder}
//           </div>
//         )}
//       </Droppable>
//     </DragDropContext>
//   );
// };

// const Row = React.forwardRef(({ row, onDeleteRow, onDeletePanel, ...props }, ref) => {
//   return (
//     <Card ref={ref} {...props}>
//       <CardHeader className="flex flex-row items-center justify-between">
//         <CardTitle>{row.title}</CardTitle>
//         <Button variant="destructive" onClick={onDeleteRow}>Delete Row</Button>
//       </CardHeader>
//       <CardContent>
//         <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
//           {row.panels.map(panel => (
//             <Panel
//               key={panel.id}
//               panel={panel}
//               onDelete={() => onDeletePanel(panel.id)}
//             />
//           ))}
//         </div>
//       </CardContent>
//     </Card>
//   );
// });

// const Panel = ({ panel, onDelete }) => {
//   return (
//     <Card>
//       <CardHeader className="flex flex-row items-center justify-between">
//         <CardTitle>{panel.title}</CardTitle>
//         <Button variant="destructive" onClick={onDelete}>Delete Panel</Button>
//       </CardHeader>
//       <CardContent>
//         <ResponsiveContainer width="100%" height={200}>
//           <LineChart data={mockChartData}>
//             <CartesianGrid strokeDasharray="3 3" />
//             <XAxis dataKey="name" />
//             <YAxis />
//             <Tooltip />
//             <Legend />
//             <Line type="monotone" dataKey="pv" stroke="#8884d8" />
//             <Line type="monotone" dataKey="uv" stroke="#82ca9d" />
//           </LineChart>
//         </ResponsiveContainer>
//       </CardContent>
//     </Card>
//   );
// };

// export default Dashboard;