import axios from 'axios';

export const getDashboards = () => {
    return axios.get('/nagioslogserver/api/dashboards');
};

export const getDashboardById = (id: string) => {
    return axios.get('/nagioslogserver/api/dashboards/' + id);
};

export const addDashboard = ({ title, data, global }: { title: string, data: string, global: boolean }) => {
    return axios.post('/nagioslogserver/api/dashboards',
        {
            title: title,
            data: data,
            global: global
        }
    );
}

export const editDashboard = ({ id, title, user, data }: { id: string, title: string, user: string, data: string }) => {
    return axios.put('/nagioslogserver/api/dashboards/' + id,
        {
            title: title,
            user: user,
            data: data
        }
    );
}

export const deleteDashboard = (id: string) => {
    return axios.delete('/nagioslogserver/api/dashboards/' + id);
}

export const getDefaultDashboard = () => {
    return axios.get('/nagioslogserver/api/user/get_user_default_dashboard');
}

export const setDefaultDashboard = (dashboard: string) => {
    return axios.post('/nagioslogserver/api/user/set_user_default_dashboard',
        {
            dashboard: dashboard
        }
    );
}