import { deleteQuery } from '@/dashboard/queries/queries';
import {
    AlertDialog,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogFooter,
    AlertDialogHeader,
    AlertDialogTrigger,
} from '@/components/shadcn/alert-dialog';
import { Button } from '@/components/shadcn/button';
import { toast } from '@/components/shadcn/use-toast';
// import { useAuth } from '@/contexts/AuthContext';
import { AlertDialogAction, AlertDialogCancel, AlertDialogTitle } from '@radix-ui/react-alert-dialog';
import { ReactNode } from 'react';
import { useTranslation } from 'react-i18next';
import { useMutation, useQueryClient } from '@tanstack/react-query';
import { AxiosError } from 'axios';

export const DeleteQueryDialog = ({ id, children }: { id: string; children: ReactNode }) => {
    const { t } = useTranslation();
    const queryClient = useQueryClient();
    // const auth = useAuth();

    const deleteQueryMutation = useMutation({
        mutationFn: deleteQuery,
        onSuccess: () => {
            queryClient.invalidateQueries({ queryKey: ['query'] });
            toast({
                title: t('Query deleted.'),
                variant: 'success',
            });
        },
        onError: (error: AxiosError<{ message: string }>) => {
            toast({
                title: t('Failed to delete query.'),
                variant: 'error',
                description: error.response?.data.message,
            });
        },
    });

    return (
        <AlertDialog>
            <AlertDialogTrigger className="w-full">{children}</AlertDialogTrigger>
            <AlertDialogContent>
                <AlertDialogHeader>
                    <AlertDialogTitle>{t('Confirm Query Deletion')}</AlertDialogTitle>
                    <AlertDialogDescription>{t('Are you sure you want to delete this query?')}</AlertDialogDescription>
                </AlertDialogHeader>
                <AlertDialogFooter>
                    <AlertDialogCancel>
                        <Button variant="outline">{t('Cancel')}</Button>
                    </AlertDialogCancel>
                    <AlertDialogAction>
                        <Button onClick={() => deleteQueryMutation.mutate(id)} variant="destructive">
                            {t('Delete')}
                        </Button>
                    </AlertDialogAction>
                </AlertDialogFooter>
            </AlertDialogContent>
        </AlertDialog>
    );
};
