"use client"

import { ColumnDef } from "@tanstack/react-table"
import {
    DropdownMenu,
    DropdownMenuContent,
    DropdownMenuItem,
    DropdownMenuTrigger,
} from '@/components/shadcn/dropdown-menu';
import { Button } from '@/components/shadcn/button';
import MoreHorizIcon from '@mui/icons-material/MoreHoriz';
import { query } from '@/dashboard/queries/types';
import { DeleteQueryDialog } from '@/dashboard/queries/DeleteQueryDialog';
import { OverwriteQueryDialog } from "@/dashboard/queries/OverwriteQueryDialog";

// This type is used to define the shape of our data.
// You can use a Zod schema here if you want.

export const columns: ColumnDef<query>[] = [
  
  {
    accessorKey: "name",
    header: "Name",
    cell: ({row}) => {
      return (
        <div className="flex items-center gap-2">
          {row.original.name}
          {row.original.show_everyone ? <i className="material-symbols-outlined">public</i> : ''}
        </div>
      )
    },
  },
  {
    accessorKey: "created_by",
    header: "Created By",
  },
  {
    id: "actions",
    enableHiding: false,
    cell: ({row, table}) => {
      return (
        <DropdownMenu key={row.original.id}>
          <DropdownMenuTrigger asChild>
            <Button variant="ghost" className="h-8 w-8 p-0">
              <span className="sr-only">Open menu</span>
              <MoreHorizIcon />
            </Button>
          </DropdownMenuTrigger>
          <DropdownMenuContent align="start">
            { /* @ts-ignore */}
            <DropdownMenuItem onClick={() => table.options.meta?.runQuery(row.original.subQueries, row.original.filters)} className="cursor-pointer">
              Run
            </DropdownMenuItem>
            <a href={`/nagioslogserver/api/queries/export?id=${row.original.id}`}>
              <DropdownMenuItem className="cursor-pointer">
                Export
             </DropdownMenuItem>
            </a>
            <DropdownMenuItem asChild>
            { /* @ts-ignore */}
              <OverwriteQueryDialog id={row.original.id} name={row.original.name}>
                <Button variant="ghost" className="justify-start w-full h-8 px-2 font-normal rounded">Overwrite</Button>
              </OverwriteQueryDialog>
            </DropdownMenuItem>
            <DropdownMenuItem asChild>
              <DeleteQueryDialog id={row.original.id}>
                <Button variant="ghost" className="justify-start w-full h-8 px-2 font-normal rounded">Delete</Button>
              </DeleteQueryDialog>
            </DropdownMenuItem>
          </DropdownMenuContent>
        </DropdownMenu>
      )
    },
  },
]