import axios from 'axios';
import { subQuery } from '@/dashboard/queries/types';
import { filter } from '@/dashboard/filters/types';

export const getQueries = () => {
    return axios.get('/nagioslogserver/api/queries/get');
}

export const getQueryById = (id: string) => {
    return axios.get('/nagioslogserver/api/queries/get/' + id);
}

export const addQuery = (data: {name: string; raw: string, subQueries: subQuery[]; filters: filter[]; global: boolean; }) => {
    return axios.post('/nagioslogserver/api/queries/post',
        {
            ...data,
        }
    );
}

export const overwriteQuery = (data: { id: string; subQueries: subQuery[]; filters: filter[]; }) => {
    return axios.put('/nagioslogserver/api/queries/put',
        {
            ...data,
        }
    );
}

export const deleteQuery = (id: string) => {
    return axios.delete('/nagioslogserver/api/queries/delete', {
        data: {
            id: id,
        },
    });
}

export const importQuery = (data: { import: string; global: boolean}) => {
    return axios.post('/nagioslogserver/api/queries/import',
        {
            ...data
        },
        
    );
};

export const getNaturalLanguageQuery = (input: string, current_fields: string) => {
    return axios.get('/nagioslogserver/dashboard/natural_language_to_query', {
        params: {
            input: input,
            current_fields: current_fields
        }
    })
}

export const getNaturalLanguageQueryStatus = () => {
    return axios.get('/nagioslogserver/dashboard/get_natural_language_query_status');
}
