import axios from 'axios';
import { email } from '@/dashboard/reports/types';

export const getReportById = (id: string) => {
    return axios.get('/nagioslogserver/api/report/get/' + id);
};

export const addReport = ({ title, data, global }: { title: string, data: string, global: boolean }) => {
    return axios.post('/nagioslogserver/api/report/post/',
        {
            title: title,
            data: data,
            global: global
        }
    );
}

export const scheduleReport = ({ email, filename } : { email: email, filename?: string}) => {
    return axios.post(`/nagioslogserver/api/report/schedule_v2/${filename}`,
        email
    )
}