import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
  DialogTrigger,
} from "@/components/shadcn/dialog";
import { Input } from "@/components/shadcn/input";
import { Label } from "@/components/shadcn/label";
import { useTranslation } from 'react-i18next';
import { ReactNode } from "react";

export const ShareDashboardDialog = ({ dashboardId, children }: { dashboardId: string, children: ReactNode }) => {
    const { t } = useTranslation();

    return (
        <Dialog>
            <DialogTrigger asChild>
                {children}
            </DialogTrigger>
            <DialogContent className="sm:max-w-md">
                <DialogHeader>
                <DialogTitle>{t("Share Link")}</DialogTitle>
                <DialogDescription>
                    {t("Share this dashboard with this URL")}
                </DialogDescription>
                </DialogHeader>
                <div className="grid flex-1 gap-2">
                    <Label htmlFor="link" className="sr-only">
                    Link
                    </Label>
                    <Input
                    id="link"
                    defaultValue={`${window.location.origin}${window.location.pathname}?dashboardId=${dashboardId}`}
                    readOnly
                    className="border-border cursor-default"
                    />
                </div>
            </DialogContent>
        </Dialog>
    )
}
