import { HistogramPanelData } from "@/components/charts/BaseHistogram";
import { HitsPanelData } from "@/components/charts/Hits";
import { TermPanelData } from "@/components/charts/Term";
import { TextPanelData } from "@/components/charts/Text";
import { TwoWeekPanelData } from "@/components/charts/other-charts/log_entries_2_weeks";
import { LogTablePanelData } from "@/components/log-table/log-table";
import { subQuery } from '@/dashboard/queries/types';
import { filter } from '@/dashboard/filters/types';
import { StatsPanelData } from "@/components/charts/Stats";
import moment from "moment";

export type PanelConfigData = {
    title: string,
    subQueryChoice: 'all' | 'selected',
    subQueries: string[],
    description: string,
    displayName?: string,
    value?: any,
    link?: any,
}

export type PanelConfig = {
    id: string,
    type: string,
    width: number,
    height: number,
    x: number,
    y: number,
    uneditable?: boolean,
    data: HistogramPanelData | PanelConfigData | TermPanelData | TextPanelData | HitsPanelData | StatsPanelData | LogTablePanelData | MapPanelData | TwoWeekPanelData,
}


export type PanelDisplayData = {
    panelId: string,
}
export interface QueryPanelDisplayData extends PanelDisplayData {
    range: Range,
    queries: subQuery[],
    filters: filter[]
}

export type ColumnEntry = {
    accessorKey: string,
    header: (({ column }: { column: any; }) => JSX.Element) | string;
    cell: ({ row }: {
        row: any;
    }) => JSX.Element;
}

export type LogEntry = {
    _index: string;
    _type: string;
    _id: string;
    _score: number | null;
    message: string;
    "@version": string;
    "@timestamp": string;
    type: string;
    host: string;
    priority: number;
    timestamp: string;
    logsource: string;
    program: string;
    pid?: string;
    severity: number;
    facility: number;
    facility_label: string;
    severity_label: string;
    sort: [number, number];
}

export type row = {
    id: string,
    title: string,
    uneditable?: boolean,
    panels: PanelConfig[]
}

export type DashboardDefinition = {
    name: string,
    user: string,
    rows: row[],
    subQueries?: subQuery[],
    filters?: filter[]
    range?: Range,
    uneditable?: boolean,
    simple?: boolean
}
  
export type DashboardRecord = {
    dashboard: string,
    title: string,
    user: string,
    userselectable: boolean,
    can_user_delete: boolean,
}
  
export type DashboardResult = {
    _id: string,
    _source: DashboardRecord
};
  
export type DashboardState = {
    definition: DashboardDefinition,
    setDefinition: (newRows: DashboardDefinition) => void;
}

export type Range = {
    startTime: moment.Moment,
    endTime: moment.Moment,
    value: string,
    label: string,
    reset?: boolean
}