import React, { useMemo, useState } from 'react';
import ReactDOM from 'react-dom/client'
import App from '@/App.tsx'
import Home from '@/Home.tsx'
import '@/globals.css'
import { ThemeProvider } from '@/contexts/ThemeContext';
import { QueryClient, QueryClientProvider } from '@tanstack/react-query';
import { createBrowserRouter, createRoutesFromElements, Route, RouterProvider } from 'react-router-dom';
import { SessionExpiredDialog } from '@/SessionExpiredDialog';
import axios, { AxiosError, AxiosResponse } from 'axios';
import { LanguageProvider } from '@/contexts/LanguageContext';
import { TooltipProvider } from '@/components/shadcn/tooltip';

const router = createBrowserRouter(
  createRoutesFromElements(
      [<Route path="/nagioslogserver/media/ui">
          <Route index element={<Home />} />
          <Route path="index.html" element={<App />} />
         { /* <Route path="home" element={<Home />} /> /*getting this working isn't necessary but would be nice*/}
      </Route>
      ]
  )
);

const queryClient = new QueryClient({
  defaultOptions: {
      queries: {
          throwOnError: true,
      },
  },
});

const Main = () => {

  const [sessionExpired, setSessionExpired] = useState(false);

  // Add axios interceptors
  useMemo(() => {
      axios.interceptors.response.use(
          (response: AxiosResponse) => {
              return response;
          },
          (error: AxiosError) => {
              if (error.response?.status == 401) {
                  setSessionExpired(true);
              }
              return Promise.reject(error);
          }
      );
  }, [setSessionExpired]);

  if (sessionExpired) {
      return (
          <React.StrictMode>
            <SessionExpiredDialog />
          </React.StrictMode>
      );
  }

  return (
    <React.StrictMode>
      <QueryClientProvider client={queryClient}>
        <ThemeProvider defaultTheme="dark" storageKey="vite-ui-theme">
          <TooltipProvider delayDuration={100} disableHoverableContent>
            <LanguageProvider>
              <RouterProvider router={router} />
            </LanguageProvider>
          </TooltipProvider>
        </ThemeProvider>
      </QueryClientProvider>
    </React.StrictMode>
  );
}

ReactDOM.createRoot(document.getElementById('root')!).render(<Main />);
