/** @type {import('tailwindcss').Config} */
import tailwindAnimate from 'tailwindcss-animate';
import tailwindTypography from '@tailwindcss/typography';
export default {
  darkMode: ['class'],
  content: [
    './pages/**/*.{ts,tsx}',
    './components/**/*.{ts,tsx}',
    './app/**/*.{ts,tsx}',
    './src/**/*.{ts,tsx}',
  ],
  safelist: [
    'rounded-xl'
  ],
  prefix: "",
  theme: {
    container: {
      center: true,
      padding: "2rem",
      screens: {
        "2xl": "1400px",
      },
    },
    extend: {
      backgroundPosition: {
        'pos-0': '0% 0%',
        'pos-100': '100% 100%',
      },
      colors: {
        border: "hsl(var(--border))",
        input: "hsl(var(--input))",
        ring: "hsl(var(--ring))",
        background: "hsl(var(--background))",
        foreground: "hsl(var(--foreground))",
        primary: {
          DEFAULT: "hsl(var(--primary))",
          foreground: "hsl(var(--primary-foreground))",
        },
        secondary: {
          DEFAULT: "hsl(var(--secondary))",
          foreground: "hsl(var(--secondary-foreground))",
        },
        destructive: {
          DEFAULT: "hsl(var(--destructive))",
          foreground: "hsl(var(--destructive-foreground))",
        },
        muted: {
          DEFAULT: "hsl(var(--muted))",
          foreground: "hsl(var(--muted-foreground))",
        },
        accent: {
          DEFAULT: "hsl(var(--accent))",
          foreground: "hsl(var(--accent-foreground))",
        },
        popover: {
          DEFAULT: "hsl(var(--popover))",
          foreground: "hsl(var(--popover-foreground))",
        },
        card: {
          DEFAULT: "hsl(var(--card))",
          foreground: "hsl(var(--card-foreground))",
        },
        nagiosBlue: 'hsl(var(--nagios-blue))',
        info: {
          DEFAULT: 'hsl(var(--info-msg-text))',
          msg: 'hsl(var(--info-msg-text))',
          border: 'hsl(var(--info-msg-border))',
          background: 'hsl(var(--info-msg-bg))',
          "bg-hover": 'hsl(var(--info-msg-bg-hover))',
        },
        success: {
          DEFAULT: 'hsl(var(--success))',
          msg: 'hsl(var(--success-msg-text))',
          border: 'hsl(var(--success-msg-border))',
          background: 'hsl(var(--success-msg-bg))',
          "bg-hover": 'hsl(var(--success-msg-bg-hover))',
        },
        warning: {
          DEFAULT: 'hsl(var(--warning))',
          msg: 'hsl(var(--warning-msg-text))',
          "msg-hover": 'hsl(var(--warning-msg-text-hover))',
          border: 'hsl(var(--warning-msg-border))',
          background: 'hsl(var(--warning-msg-bg))',
          "bg-hover": 'hsl(var(--warning-msg-bg-hover))',
        },
        error: {
          DEFAULT: 'hsl(var(--error))',
          msg: 'hsl(var(--error-msg-text))',
          "msg-hover": 'hsl(var(--error-msg-text-hover))',
          border: 'hsl(var(--error-msg-border))',
          background: 'hsl(var(--error-msg-bg))',
          "bg-hover": 'hsl(var(--error-msg-bg-hover))',
        },
        unknown: {
          DEFAULT: 'hsl(var(--unknown))',
          msg: 'hsl(var(--unknown-msg-text))',
          "msg-hover": 'hsl(var(--unknown-msg-text-hover))',
          border: 'hsl(var(--unknown-msg-border))',
          background: 'hsl(var(--unknown-msg-bg))',
          "bg-hover": 'hsl(var(--unknown-msg-bg-hover))',
        },
      },
      borderRadius: {
        xl: 'calc(var(--radius) + 2px)',
        lg: 'var(--radius)',
        md: 'calc(var(--radius) - 2px)',
        sm: 'calc(var(--radius) - 4px)',
      },
      minWidth: {
        '80': '20rem',
        '96': '24rem',
        '112': '28rem',
        '128': '32rem',
      },
      borderColor: {
        DEFAULT: 'hsl(var(--border))',
      },
      keyframes: {
        "accordion-down": {
          from: { height: "0" },
          to: { height: "var(--radix-accordion-content-height)" },
        },
        "accordion-up": {
          from: { height: "var(--radix-accordion-content-height)" },
          to: { height: "0" },
        },
        "pulse": {
          "0%, 100%": { opacity: 1 },
          "50%": { opacity: 0 }
        }
      },
      animation: {
        "accordion-down": "accordion-down 0.2s ease-out",
        "accordion-up": "accordion-up 0.2s ease-out",
      },
      sidebar: {
        DEFAULT: 'hsl(var(--sidebar-background))',
        foreground: 'hsl(var(--sidebar-foreground))',
        primary: 'hsl(var(--sidebar-primary))',
        'primary-foreground': 'hsl(var(--sidebar-primary-foreground))',
        accent: 'hsl(var(--sidebar-accent))',
        'accent-foreground': 'hsl(var(--sidebar-accent-foreground))',
        border: 'hsl(var(--sidebar-border))',
        ring: 'hsl(var(--sidebar-ring))',
      },
    },
  },
  plugins: [tailwindAnimate, tailwindTypography],
}