import path from "path"
import react from "@vitejs/plugin-react"
import { defineConfig } from "vite"

export default defineConfig({
  plugins: [react()],
  resolve: {
    alias: {
      "@": path.resolve(__dirname, "./src"),
    },
  },
  build: {
    outDir: '../../../www/media/ui',
    minify:false,
    emptyOutDir: true,
  },
  base: '',
  server: {
    proxy: {
      '/nagioslogserver': {
        target: `http://${process.env.SERVER_IP || 'localhost'}`,
        changeOrigin: true,
        secure: false,
      }
    }
  }
})