<?php

// This class will add text to the default logstash config. Use this on upgrade to add new inputs/filters as needed.
class CLI_AddToConfig extends CI_Controller
{

    private $valid_types;

    function __construct() {
        parent::__construct();
        $this->load->model('ls_configure');

        if (!$this->input->is_cli_request()) {
            echo _("This class can only be accessed via the command line.");
            exit();
        }

        $this->valid_types = array('config_inputs', 'config_filters', 'config_livealert_filters', 'config_outputs', 'config_livealert_outputs');
    }

    public function add($type, $name, $filename) {

        if (!in_array($type, $this->valid_types)) {
            echo sprintf(_("%s is not a valid type."), $type);
            return;
        }

        $filename = urldecode($filename);
        $text_to_add = file_get_contents($filename);

        $global_node = $this->elasticsearch->get('node', 'global');

        $new_config = array(
            'name' => $name,
            'active' => 1,
            'raw' => $text_to_add
        );

        // Elasticsearch adds some extra keys when you retrieve records.
        // This block prevents them from proliferating
        $global_node = $global_node['_source'];
        foreach ($global_node as $k => $value) {
            if (!in_array($k, $this->valid_types)) {
                unset($global_node[$k]);
            }
        }

        $global_node[$type][] = $new_config;

        $this->ls_configure->save($global_node, 'global');
    }
}
