<?php 
class CLI_RealTimeAlert extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();

		if (!$this->input->is_cli_request()) {
			echo _("This class can only be accessed via the command line.");
			exit();
		}

		$this->load->helper('alert');
		$this->load->model('alert');
	}

	public function run($alert_names, $host=false, $alert_message=false) {
		$alert_names = explode('%2C', $alert_names);

		if ($alert_message) {
			$alert_message = urldecode($alert_message);
		}

		$count = count($alert_names);

		// Decode the alert names
		for ($i = 0; $i < $count; $i++) {
			$alert_names[$i] = urldecode($alert_names[$i]);
		}

		// Initialize lockfile directory
	    $ci =& get_instance();
	    $backend_dir = $ci->config->item('backend_dir');
	    $lock_dir = $backend_dir . '/tmp/';

		for ($i = 0; $i < $count; $i++) {

			$alert_name = $alert_names[$i];

			$fp = $this->get_lock_file($lock_dir, $alert_name);
			if (!$fp) {

				continue;
			}

			// PHP_INT_MAX is 19 characters long. Read 20 just in case.
			$old_timestamp = intval(fread($fp, 20));
			$current_timestamp = time();

			// File is set up, now get alert data
			$full_alert = $this->alert->get_alert_from_name($alert_name);

			$alert_id = $full_alert['_id'];
			$alert_gap = intval(isset($full_alert['min_gap']) ? $full_alert['min_gap'] : 1);

			if (empty($alert_id)) {
				// Fake alert name (or alert was removed and not applied yet)
				$this->cleanup($fp);
				continue;
			}

			if ($current_timestamp < $old_timestamp + $alert_gap) {
				// This alert is getting rate-limited.
				$this->cleanup($fp);
				continue;
			}

			$this->write_to_lock_file($fp, $current_timestamp);

			// The Alert "model" is basically controller code, responsible for the actual alerting.
			$this->alert->do_live_alert($alert_id, $host, $alert_message);
		}
	}

	private function get_lock_file($lock_dir, $alert_name) {

		// Check whether we're able to write our timestamp into the file.
		$fname = $lock_dir . $alert_name . '.lock';
		if (!file_exists($fname)) {
			touch($fname);
		}

		$fp = fopen($fname, 'r+');
		if ($fp === false) {
			return false;
		}

		if (!flock($fp, LOCK_EX | LOCK_NB)) {
			// Some other instance of this process is already trying to alert
			fclose($fp);
			return false;
		}
		return $fp;
	}

	private function write_to_lock_file($fp, $current_timestamp) {
		// Actually overwrite the lockfile in a safe way.
		ftruncate($fp, 0);
		rewind($fp);
		fwrite($fp, $current_timestamp);
		fflush($fp);
		$this->cleanup($fp);
	}

	private function cleanup($fp) {
		flock($fp, LOCK_UN);
		fclose($fp);
	}
}