<?php

function mail_get_config() {

    // Set email settings before we actually do the email
    $config = array();
    $config['useragent'] = "Nagios Log Server";
    $config['mailtype'] = "html";
    $config['crlf'] = "\r\n";
    $config['newline'] = "\r\n";

    // Set mail type
    $config['mailtype'] = "html";
    if (get_option('email_text_only', 0)) {
        $config['mailtype'] = "text";
    }

    $config['protocol'] = get_option('email_method');
    if ($config['protocol'] == "smtp") {
        $config['smtp_host'] = get_option('smtp_host', true);
        $crypto = get_option('smtp_crypto', true);
        if (!empty($crypto)) {
            $config['smtp_crypto'] = $crypto;
        }
        $config['smtp_user'] = get_option('smtp_user', true);
        $config['smtp_pass'] = get_option('smtp_pass', true);
        $config['smtp_port'] = get_option('smtp_port', true);
    }

    return $config;
}