<?php

function humanize_time($secs, $precision=6)
{
    $secs = (int) $secs;
    $bit = array(
    ' year'        => $secs / 31556926 % 12,
    ' week'        => $secs / 604800 % 52,
    ' day'        => $secs / 86400 % 7,
    ' hour'        => $secs / 3600 % 24,
    ' minute'    => $secs / 60 % 60,
    ' second'    => $secs % 60
    );

    $i=0;
    $ret = array();
    foreach($bit as $k => $v) {
        if(++$i > $precision) { continue; }
        if($v > 1)$ret[] = $v . $k . 's';
        if($v == 1)$ret[] = $v . $k;
    }
    if(count($ret)) {
        return join(' ', $ret);
    }
    return 'n/a';
}

function humanize_date($date, $ts=false)
{
    if (!$ts) {
        $date = strtotime($date);
    }
    if (date("Y-m-d") == date("Y-m-d", $date)) {
        return date("\T\o\d\a\y h:ia", $date);
    } else {
        return date('F jS, Y', $date);
    }
}

function humanize_filesize($bytes)
{
    $bytes = (int) $bytes;
    if ($bytes >= 1073741824)
    {
        $str = number_format($bytes / 1073741824, 2) . ' GB';
    }
    elseif ($bytes >= 1048576)
    {
        $str = number_format($bytes / 1048576, 2) . ' MB';
    }
    elseif ($bytes >= 1024)
    {
        $str = number_format($bytes / 1024, 2) . ' KB';
    }
    elseif ($bytes > 1)
    {
        $str = $bytes . ' bytes';
    }
    elseif ($bytes == 1)
    {
        $str = $bytes . ' byte';
    }
    else
    {
        $str = '0 bytes';
    }

    return $str;
}

function pluralize($items, $suffix='s')
{
    if(is_array($items)) {
        $num = count($items);
    } else {
        $num = $items;
    }
    if($num != 1) {
        return $suffix;
    } 
}

/**
    return an array with ip and port broken out of address such as
    inet[/192.168.2.34:9300]
*/
function split_inet_string($inet_string) {

    // Try matching ipv4 with port
    $result = preg_match('/(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}):(\d{4,5})/', $inet_string, $matches);
    if ($result != 1) {

        // Try matching ipv6 with port
        $result = preg_match('/([a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4})\]?:(\d{4,5})/', $inet_string, $matches);
    }
    if ($result != 1) {
        // Try matching ipv4 with port ("shouldn't" happen)
        $result = preg_match('/(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/', $inet_string, $matches);
    }
    if ($result != 1) {
        // Try matching ipv6 without port (also shouldn't happen)
        $result = preg_match('/([a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4}:[a-f0-9]{0,4})/', $inet_string, $matches);
    }

    if (count($matches) == 3) {
        // Expected result
        return array('ip' => $matches[1], 'port' => $matches[2]);
    }
    else if (count($matches) == 2) {
        return array('ip' => $matches[1], 'port' => '');
    }
    return array('ip' => '', $port => '');
}

function is_are($items)
{
    if(is_array($items)) {
        $num = count($items);
    } else {
        $num = $items;
    }
    if($num == 1) {
        return 'is';
    } else {
        return 'are';
    }
}
