<?php echo $header; ?>

<?php 
if (isset($_GET['validate_ai_api_key'])) {
    if (isset($_GET['key'])) {
        $key = $_GET['key'];
        $script = "/usr/local/nagioslogserver/scripts/check_ai_key.sh";
        $command = escapeshellcmd($script . " -k " . escapeshellarg($key));
        $output = null;
        $return_var = null;
        exec($command, $output, $return_var);

        switch ($return_var) {
            case 10:
                echo "<!--VALID_OPENAI_KEY-->";
                break;
            case 20:
                echo "<!--VALID_MISTRAL_KEY-->";
                break;
            case 30:
                echo "<!--VALID_ANTHROPIC_KEY-->";
                break;
            default:
                echo "<!--INVALID_KEY-->";
                break;
        }
    }
    exit;  
}

if (isset($_GET['validate_self_hosted'])) {
    if (isset($_GET['address']) && isset($_GET['port'])) {
        $address = $_GET['address'];
        $port = $_GET['port'];
        $script = "/usr/local/nagioslogserver/scripts/check_ai_key.sh";
        $command = escapeshellcmd($script . " --local --address " . escapeshellarg($address) . " --port " . escapeshellarg($port));
        $output = null;
        $return_var = null;
        exec($command, $output, $return_var);

        if ($return_var == 0) {
            echo "<!--VALID_SELF_HOSTED-->";
        } else {
            echo "<!--INVALID_SELF_HOSTED-->";
        }
    }
    exit;
}
?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const nlpYesButton = document.getElementById('nlp_query_yes');
        const nlpNoButton = document.getElementById('nlp_query_no');
        const disclaimerCheckbox = document.getElementById('nlp_disclaimer');
        const aiProviderRadios = document.querySelectorAll('input[name="ai_provider"]');
        const openaiRadio = document.querySelector('input[value="openai"]');
        const apiInput = document.getElementById('ai_api_key');
        const ipInput = document.getElementById('self_host_ip_address');
        const aiPortInput = document.getElementById('ai_port');
        const saveButton = document.querySelector('button[type="submit"]');
        const keyValidationStatus = document.getElementById('key_validation_status');
        const loadingMessage = document.getElementById('loading_message');
        const successMessage = document.getElementById('success_message');
        const errorMessage = document.getElementById('error_message');
        let keyIsValid = false;

        function updateValidationUI(isValid) {
            apiInput.style.borderColor = isValid ? 'green' : 'red';
            keyIsValid = isValid;
        }

        function updateSelfHostedValidationUI(isValid) {
            ipInput.style.borderColor = isValid ? 'green' : 'red';
            aiPortInput.style.borderColor = isValid ? 'green' : 'red';
            keyIsValid = isValid;
        }

        function validateAPIKey() {
            if (!apiInput) return;

            let key = apiInput.value.trim();
            if (!key) {
                updateValidationUI(false);
                return;
            }

            keyValidationStatus.style.display = 'block';
            loadingMessage.style.display = 'block';
            successMessage.style.display = 'none';
            errorMessage.style.display = 'none';

            let xhr = new XMLHttpRequest();
            xhr.open('GET', window.location.href + '?key=' + encodeURIComponent(key) + '&validate_ai_api_key=1', true);
            xhr.timeout = 3000; // 3 seconds timeout
            xhr.onload = function() {
                loadingMessage.style.display = 'none';
                const selectedProvider = document.querySelector('input[name="ai_provider"]:checked')?.value;
                
                if (selectedProvider === 'openai' && this.responseText.includes("<!--VALID_OPENAI_KEY-->")) {
                    successMessage.textContent = 'Valid OpenAI API key';
                    successMessage.style.display = 'block';
                    updateValidationUI(true);
                } else if (selectedProvider === 'mistral' && this.responseText.includes("<!--VALID_MISTRAL_KEY-->")) {
                    successMessage.textContent = 'Valid Mistral API key';
                    successMessage.style.display = 'block';
                    updateValidationUI(true);
                } else if (selectedProvider === 'anthropic' && this.responseText.includes("<!--VALID_ANTHROPIC_KEY-->")) {
                    successMessage.textContent = 'Valid Anthropic API key';
                    successMessage.style.display = 'block';
                    updateValidationUI(true);
                } else {
                    errorMessage.textContent = `Invalid ${selectedProvider.charAt(0).toUpperCase() + selectedProvider.slice(1)} API key`;
                    errorMessage.style.display = 'block';
                    updateValidationUI(false);
                }
            };
            xhr.ontimeout = function() {
                loadingMessage.style.display = 'none';
                errorMessage.textContent = 'Timeout, the API provider may be having issues.';
                errorMessage.style.display = 'block';
                updateValidationUI(false);
            };
            xhr.send();
        }

        function validateSelfHosted() {
            if (!ipInput || !aiPortInput) return;

            let ip = ipInput.value.trim();
            let port = aiPortInput.value.trim();
            if (!ip || !port) {
                updateSelfHostedValidationUI(false);
                return;
            }

            keyValidationStatus.style.display = 'block';
            loadingMessage.style.display = 'block';
            successMessage.style.display = 'none';
            errorMessage.style.display = 'none';

            let xhr = new XMLHttpRequest();
            xhr.open('GET', window.location.href + '?address=' + encodeURIComponent(ip) + '&port=' + encodeURIComponent(port) + '&validate_self_hosted=1', true);
            xhr.timeout = 3000; // 3 seconds timeout
            xhr.onload = function() {
                loadingMessage.style.display = 'none';
                if (this.responseText.includes("<!--VALID_SELF_HOSTED-->")) {
                    successMessage.textContent = 'Valid IP address and port';
                    successMessage.style.display = 'block';
                    updateSelfHostedValidationUI(true);
                } else {
                    errorMessage.textContent = 'Invalid IP address or port';
                    errorMessage.style.display = 'block';
                    updateSelfHostedValidationUI(false);
                }
            };
            xhr.ontimeout = function() {
                loadingMessage.style.display = 'none';
                errorMessage.textContent = 'Timeout, unable to validate IP address and port.';
                errorMessage.style.display = 'block';
                updateSelfHostedValidationUI(false);
            };
            xhr.send();
        }

        apiInput?.addEventListener('input', function() {
            clearTimeout(apiInput.validationTimeout);
            apiInput.validationTimeout = setTimeout(validateAPIKey, 500); // Debounce the API key validation
        });

        ipInput?.addEventListener('input', function() {
            clearTimeout(ipInput.validationTimeout);
            ipInput.validationTimeout = setTimeout(validateSelfHosted, 500); // Debounce the IP and port validation
        });

        aiPortInput?.addEventListener('input', function() {
            clearTimeout(aiPortInput.validationTimeout);
            aiPortInput.validationTimeout = setTimeout(validateSelfHosted, 500); // Debounce the IP and port validation
        });

        function resetDefaults() {
            if (openaiRadio) openaiRadio.checked = true; // Set OpenAI as the default selected provider
            if (apiInput) apiInput.value = ''; 
            if (ipInput) ipInput.value = '';
            if (aiPortInput) aiPortInput.value = '8000'; 
            updateApiKeyLabel('OpenAI API Key'); 
            if (document.getElementById('self_hosted_fields')) document.getElementById('self_hosted_fields').style.display = 'none';
            if (document.getElementById('ai_api_key_input')) document.getElementById('ai_api_key_input').style.display = nlpYesButton?.checked ? 'block' : 'none';
            loadingMessage.style.display = 'none';
            successMessage.style.display = 'none';
            errorMessage.style.display = 'none';
        }

        function toggleNLPFeatures(enabled) {
            const isChecked = disclaimerCheckbox?.checked;
            const displayStyle = enabled ? 'block' : 'none';
            if (document.getElementById('nlp_disclaimer_div')) document.getElementById('nlp_disclaimer_div').style.display = displayStyle;
            if (document.getElementById('ai_provider_div')) document.getElementById('ai_provider_div').style.display = displayStyle;
            if (document.getElementById('ai_api_key_input')) document.getElementById('ai_api_key_input').style.display = displayStyle;

            if (!enabled) {
                resetDefaults();
            }
            toggleDisclaimer(); 
        }

        function toggleDisclaimer() {
            const isChecked = disclaimerCheckbox?.checked;
            aiProviderRadios.forEach(radio => {
                radio.disabled = !isChecked;
            });
            if (apiInput) apiInput.disabled = !isChecked;
            if (ipInput) ipInput.disabled = !isChecked;
            if (aiPortInput) aiPortInput.disabled = !isChecked;
            if (saveButton) saveButton.disabled = nlpYesButton?.checked && !isChecked; 

            if (!isChecked) {
                resetDefaults(); 
            }
        }

        nlpYesButton?.addEventListener('click', function() {
            toggleNLPFeatures(true);
        });
        nlpNoButton?.addEventListener('click', function() {
            toggleNLPFeatures(false);
        });

        disclaimerCheckbox?.addEventListener('click', toggleDisclaimer);

        function updateApiKeyLabel(providerLabel) {
            const apiKeyLabel = document.getElementById('ai_api_key_label');
            if (apiKeyLabel) apiKeyLabel.textContent = providerLabel;
            if (apiInput) apiInput.value = '';
            if (document.getElementById('ai_api_key_input')) document.getElementById('ai_api_key_input').style.display = 'block';
            if (document.getElementById('self_hosted_fields')) document.getElementById('self_hosted_fields').style.display = 'none';
        }

        function showSelfHostedFields() {
            if (document.getElementById('ai_api_key_input')) document.getElementById('ai_api_key_input').style.display = 'none';
            if (document.getElementById('self_hosted_fields')) document.getElementById('self_hosted_fields').style.display = 'block';
        }

        aiProviderRadios.forEach(radio => {
            radio.addEventListener('click', function() {
                if (this.value === 'self_hosted') {
                    showSelfHostedFields();
                } else {
                    updateApiKeyLabel(this.value.charAt(0).toUpperCase() + this.value.slice(1) + ' API Key');
                }
                if (document.getElementById('key_validation_status')) document.getElementById('key_validation_status').style.display = 'none';
                if (apiInput) apiInput.style.border = '';
                if (ipInput) ipInput.style.border = '';
                if (aiPortInput) aiPortInput.style.border = '';
            });
        });

        if (nlpYesButton) toggleNLPFeatures(nlpYesButton.checked);
        toggleDisclaimer();

        const selfHostedRadio = document.querySelector('input[value="self_hosted"]');
        if (selfHostedRadio && selfHostedRadio.checked) {
            showSelfHostedFields();
        }
    });
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">
        <h1 class="form-title"><?php echo _('Global Settings'); ?></h1>
        <p class="form-subtitle"><?php echo _('Edit default global settings for your Nagios Log Server install.'); ?></p>
        <div class="form-spacer"></div>


        <?php if (!empty($success)) { ?><div class="alert alert-info" style="margin: 10px 0 20px 0;"><?php echo $success; ?></div><?php } ?>
        <?php if (!empty($error)) { ?><div class="alert alert-danger" style="margin: 10px 0 20px 0;"><?php echo $error; ?></div><?php } ?>

        <?php echo form_open('admin/globals', array("class" => "form-horizontal")); ?>
        <div class="tw-flex tw-flex-col tw-gap-2 tw-w-1/2">
            <?php
            $form_fields = array(
                'language' => array(
                    'label' => _("Default Language"),
                    'type' => 'select',
                    'options' => $languages,
                    'selected' => $global_language,
                    'option_formatter' => function($l) { return get_language_name($l); },
                    'subtext' => ''
                ),
                'global_theme' => array(
                    'label' => _("Default Theme"),
                    'type' => 'select',
                    'options' => $themes,
                    'selected' => $global_theme,
                    'subtext' => ''
                ),
                'cluster_hostname' => array(
                    'label' => _("Cluster Hostname"),
                    'type' => 'text',
                    'value' => $cluster_hostname,
                    'subtext' => _('The cluster hostname can be utilized if you have a load balancer or round robin DNS setup for your cluster. This will modify all of the setup instructions to point to this host name.')
                ),
                'interface_url' => array(
                    'label' => _("Interface URL"),
                    'type' => 'text',
                    'value' => $interface_url,
                    'subtext' => _('The interface URL is what is displayed in alerts for the view in dashboard URL.')
                ),
                'log_user_queries' => array(
                    'label' => _("Log User Queries"),
                    'type' => 'radio',
                    'options' => array(1 => _('Yes'), 0 => _('No')),
                    'checked' => $log_user_queries,
                    'subtext' => _('Allows you to log all user queries to show in the Audit Log.')
                ),
                'backup_rotation' => array(
                    'label' => _("Backup Retention"),
                    'type' => 'text',
                    'value' => empty($backup_rotation) ? '0' : $backup_rotation,
                    'subtext' => _('The amount of days to keep backup system data. This is ONLY for system data, NOT log data. Setting this to 0 will stop backups from being created.')
                ),
                'disable_update_check' => array(
                    'label' => _("Disable Update Check"),
                    'type' => 'radio',
                    'options' => array(1 => _('Yes'), 0 => _('No')),
                    'checked' => $disable_update_check,
                    'subtext' => _('Log Server update checks are performed every 24 hours, you can disable the check.')
                ),
                'disable_reverse_dns' => array(
                    'label' => _("Disable Reverse DNS"),
                    'type' => 'radio',
                    'options' => array(1 => _('Yes'), 0 => _('No')),
                    'checked' => $disable_reverse_dns,
                    'subtext' => _('Log Server occasionally tries to retrieve hostnames from IP addresses using DNS. This setting allows you to disable that behavior.')
                ),
                'timezone' => array(
                    'label' => _("Cluster Timezone"),
                    'type' => 'select',
                    'options' => get_timezones(),
                    'selected' => !empty($set_timezone) ? $set_timezone : get_current_timezone(),
                    'subtext' => _('Will set the timezone of all systems in the cluster. May take up to a minute to complete.')
                ),
                'csv_use_local_timezone' => array(
                    'label' => _("Exported CSV Timezone"),
                    'type' => 'radio',
                    'options' => array(1 => _('Cluster Timezone'), 0 => _('UTC (Default)')),
                    'checked' => $csv_use_local_timezone,
                    'subtext' => _('When exporting data from Log Server, timestamps can use either UTC or the Cluster Timezone.')
                )
            );

            foreach ($form_fields as $field_name => $field_data) {
                echo '<div class="tw-mb-4">';
                echo '<label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="' . $field_name . '">' . $field_data['label'] . '</label>';
                
                if ($field_data['type'] === 'radio' && !empty($field_data['subtext'])) {
                    echo '<p class="tw-text-[12.8px] tw-mt-1 tw-mb-2 tw-text-secondary-foreground/80 tw-mb-4">' . $field_data['subtext'] . '</p>';
                }
                
                switch ($field_data['type']) {
                    case 'select':
                        echo '<select id="' . $field_name . '" name="' . $field_name . '" class="ui-select tw-w-full">';
                        foreach ($field_data['options'] as $key => $value) {
                            if ($field_name == 'timezone') { $temp = $key; $key = $value; $value = $temp; }
                            else if ($field_name == 'language') { $key = $value; }
                            $option_text = isset($field_data['option_formatter']) ? $field_data['option_formatter']($value) : $value;
                            echo '<option value="' . $key . '"' . ($field_data['selected'] == $key ? ' selected' : '') . '>' . $option_text . '</option>';
                        }
                        echo '</select>';
                        break;
                    case 'text':
                        echo '<input id="' . $field_name . '" name="' . $field_name . '" type="text" class="ui-input tw-w-full" value="' . html_escape($field_data['value']) . '" />';
                        break;
                    case 'radio':
                        echo '<div class="ui-radio-group tw-flex tw-flex-col tw-gap-2">';
                        foreach ($field_data['options'] as $value => $label) {
                            echo '<div class="tw-flex tw-items-center tw-space-x-2">';
                            echo '<input type="radio" id="' . $field_name . '_' . $value . '" name="' . $field_name . '" value="' . $value . '"' . ($field_data['checked'] == $value ? ' checked' : '') . ' class="ui-radio-group-item">';
                            echo '<label for="' . $field_name . '_' . $value . '" class="ui-label">' . $label . '</label>';
                            echo '</div>';
                        }
                        echo '</div>';
                        break;
                }
                
                if (!empty($field_data['subtext']) && $field_data['type'] !== 'radio') {
                    echo '<p class="tw-text-[12.8px] tw-mt-1 tw-text-secondary-foreground/80">' . $field_data['subtext'] . '</p>';
                }
                
                echo '</div>';
            }
            ?>

            <!-- ================ Multi-Factor Auth Feature Section ================ -->

            <div class="two_factor-divider">
                <div style="margin: 20px 0; margin-top:40px;">
                    <div style="padding:5px; text-align: start; font-weight: bold; font-size: 1.1em;"><?php echo _('Two Factor Authentication'); ?></div>
                    <hr style="border-color: #a5a5a5; margin: 5px 0;">
                </div>
            </div>
            <div class="tw-mb-4">

                <label class="tw-flex tw-items-center tw-gap-2 tw-text-normal tw-font-semibold tw-mb-2" for="enable_email_two_factor">
                    <?php echo _("Enable Two Factor"); ?>
                    <?php echo question_tooltip(_('Send an email to users after logging in to authenticate')); ?>
                </label>
                <div class="ui-radio-group tw-flex tw-flex-col tw-gap-4">
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="2fa_email_yes" name="enable_email_two_factor" value="1" <?php echo ($enable_email_two_factor == 1) ? "checked" : ""; ?> class="ui-radio-group-item">
                        <label for="2fa_email_yes" class="ui-label"><?php echo _('Yes'); ?></label>
                    </div>
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="2fa_email_no" name="enable_email_two_factor" value="0" <?php echo (!$enable_email_two_factor) ? "checked" : ""; ?> class="ui-radio-group-item">
                        <label for="2fa_email_no" class="ui-label"><?php echo _('No'); ?></label>
                    </div>
                </div>
            </div>

            <div class="tw-mb-4">
                <label class="tw-flex tw-items-center tw-gap-2 tw-text-sm tw-font-medium tw-mb-1" for="token_timeout_two_factor">
                    <?php echo _("Token Timeout"); ?>
                    <?php echo question_tooltip(_('Number of minutes before a two factor auth token expires')); ?>
                </label>
                <input type="text" id="token_timeout_two_factor" name="token_timeout_two_factor" class="ui-input tw-w-full tw-mb-2" 
                       placeholder="15" 
                       value="<?php if (empty($token_timeout_two_factor)) { echo '15'; } else { echo html_escape($token_timeout_two_factor); } ?>" />
            </div>

            <div class="tw-mb-4">
                <label class="tw-flex tw-items-center tw-gap-2 tw-text-normal tw-font-semibold tw-mb-2" for="enable_cookie_two_factor">
                    <?php echo _("Two Factor Cookie"); ?>
                    <?php echo question_tooltip(_('Allow users to choose to remember their browser with a cookie')); ?>
                </label>
                <div class="ui-radio-group tw-flex tw-flex-col tw-gap-4">
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="2fa_cookie_yes" name="enable_cookie_two_factor" value="1" <?php echo ($enable_cookie_two_factor == 1) ? "checked" : ""; ?> class="ui-radio-group-item">
                        <label for="2fa_cookie_yes" class="ui-label"><?php echo _('Yes'); ?></label>
                    </div>
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="2fa_cookie_no" name="enable_cookie_two_factor" value="0" <?php echo (!$enable_cookie_two_factor) ? "checked" : ""; ?> class="ui-radio-group-item">
                        <label for="2fa_cookie_no" class="ui-label"><?php echo _('No'); ?></label>
                    </div>
                </div>
            </div>

            <div class="tw-mb-4">
                <label class="tw-flex tw-items-center tw-gap-2 tw-text-sm tw-font-medium tw-mb-1" for="cookie_timeout_two_factor"><?php echo _('Cookie Timeout'); ?>
                    <?php echo question_tooltip(_('Number of days a two factor cookie will remain active before requiring a new auth token')); ?>
                </label>
                <input type="text" id="cookie_timeout_two_factor" name="cookie_timeout_two_factor" class="ui-input tw-w-full tw-mb-2" 
                       placeholder="90" 
                       value="<?php if (!is_numeric($cookie_timeout_two_factor)) { echo '90'; } else { echo html_escape($cookie_timeout_two_factor); } ?>" />
            </div>

            <div class="two_factor-divider">
                <div style="margin: 20px 0; margin-top:40px;">
                    <div style="padding:5px; text-align: start; font-weight: bold; font-size: 1.1em;"><?php echo _('OpenSearch and Logstash Log Folder'); ?></div>
                    <hr style="border-color: #a5a5a5; margin: 5px 0;">
                </div>
            </div>
            <div class="tw-mb-4">
                <div class="ui-radio-group tw-flex tw-flex-col tw-gap-4">
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="log_location_default" name="log_location" value="default" <?php echo ($log_location == 'default') ? "checked" : ""; ?> class="ui-radio-group-item">
                        <label for="log_location_default" class="ui-label">
                            <?php echo _('Store logs inside the application directory'); ?>
                            <p class="tw-text-[12.8px] tw-mt-1 tw-mb-2 tw-text-secondary-foreground/80 tw-mb-4">
                                (e.g., /usr/local/nagioslogserver/{opensearch|logstash}/logs)
                            </p>
                        </label>
                    </div>
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="log_location_var" name="log_location" value="var" <?php echo (!($log_location == 'default')) ? "checked" : ""; ?> class="ui-radio-group-item">
                        <label for="log_location_var" class="ui-label">
                            <?php echo _('Store logs in the system log directory'); ?>
                            <p class="tw-text-[12.8px] tw-mt-1 tw-mb-2 tw-text-secondary-foreground/80 tw-mb-4">
                                (e.g., /var/log/{opensearch|logstash})
                            </p>
                        </label>
                    </div>
                </div>
            </div>

            <div class="tw-border-b tw-border-border tw-mt-2 tw-mb-4"></div>

            <!-- Experimental Features Section -->
            <div class="tw-font-medium tw-text-lg tw-flex tw-items-center tw-gap-2 tw-mb-4">
                <span class="material-symbols-outlined tw-text-primary">experiment</span> <?php echo _('Experimental Features'); ?>
            </div>
            <?php
                $form_fields = array(
                    'new_user_dashboard_simple_mode' => array(
                        'label' => _("Default Dashboard Mode For New Users"),
                        'type' => 'radio',
                        'options' => array(1 => _('Simple'), 0 => _('Advanced')),
                        'checked' => $new_user_dashboard_simple_mode,
                        'subtext' => _('Log Server update checks are performed every 24 hours, you can disable the check.')
                    )
                );

                foreach ($form_fields as $field_name => $field_data) {
                    echo '<div class="tw-mb-4">';
                    echo '<label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="' . $field_name . '">' . $field_data['label'] . '</label>';
                    
                    if ($field_data['type'] === 'radio' && !empty($field_data['subtext'])) {
                        echo '<p class="tw-text-[12.8px] tw-mt-1 tw-mb-2 tw-text-secondary-foreground/80 tw-mb-4">' . $field_data['subtext'] . '</p>';
                    }
                    
                    switch ($field_data['type']) {
                        case 'select':
                            echo '<select id="' . $field_name . '" name="' . $field_name . '" class="ui-select tw-w-full">';
                            foreach ($field_data['options'] as $key => $value) {
                                if ($field_name == 'timezone') { $temp = $key; $key = $value; $value = $temp; }
                                else if ($field_name == 'language') { $key = $value; }
                                $option_text = isset($field_data['option_formatter']) ? $field_data['option_formatter']($value) : $value;
                                echo '<option value="' . $key . '"' . ($field_data['selected'] == $key ? ' selected' : '') . '>' . $option_text . '</option>';
                            }
                            echo '</select>';
                            break;
                        case 'text':
                            echo '<input id="' . $field_name . '" name="' . $field_name . '" type="text" class="ui-input tw-w-full" value="' . html_escape($field_data['value']) . '" />';
                            break;
                        case 'radio':
                            echo '<div class="ui-radio-group tw-flex tw-flex-col tw-gap-2">';
                            foreach ($field_data['options'] as $value => $label) {
                                echo '<div class="tw-flex tw-items-center tw-space-x-2">';
                                echo '<input type="radio" id="' . $field_name . '_' . $value . '" name="' . $field_name . '" value="' . $value . '"' . ($field_data['checked'] == $value ? ' checked' : '') . ' class="ui-radio-group-item">';
                                echo '<label for="' . $field_name . '_' . $value . '" class="ui-label">' . $label . '</label>';
                                echo '</div>';
                            }
                            echo '</div>';
                            break;
                    }
                    
                    if (!empty($field_data['subtext']) && $field_data['type'] !== 'radio') {
                        echo '<p class="tw-text-[12.8px] tw-mt-1 tw-text-secondary-foreground/80">' . $field_data['subtext'] . '</p>';
                    }
                    
                    echo '</div>';
                }
            ?>


            <!-- Natural Language Queries Section -->
            <div class="tw-mb-4">
                <label class="tw-block tw-text-normal tw-font-semibold tw-mb-2" for="nlp_query"><?php echo _('Natural Language Queries'); ?></label>
                <div class="ui-radio-group tw-flex tw-flex-col tw-gap-4">
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="nlp_query_yes" name="natural_language_query" value="1" <?php echo ($natural_language_query == 1) ? "checked" : ""; ?> class="ui-radio-group-item">
                        <label for="nlp_query_yes" class="ui-label"><?php echo _('Yes'); ?></label>
                    </div>
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="nlp_query_no" name="natural_language_query" value="0" <?php echo (!$natural_language_query) ? "checked" : ""; ?> class="ui-radio-group-item">
                        <label for="nlp_query_no" class="ui-label"><?php echo _('No'); ?></label>
                    </div>
                </div>
            </div>

            <!-- Disclaimer Section -->
            <div class="tw-mb-4" id="nlp_disclaimer_div" style="display: none;">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="nlp_disclaimer"><?php echo _('Disclaimer'); ?></label>
                <p class="tw-text-sm tw-text-secondary-foreground/80 tw-mb-2"><?php echo _('By using the Natural Language Queries feature, you acknowledge that the outputs from generative AI models might not always be accurate or useful. They can sometimes generate results that are unexpected, inappropriate, or offensive. Use this feature with caution and always review the generated results. No logs are sent to the API Provider.'); ?></p>
                <div class="ui-checkbox-group">
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="checkbox" id="nlp_disclaimer" name="nlp_disclaimer" <?php echo ($nlp_disclaimer) ? 'checked' : ''; ?> class="ui-checkbox-group-item">
                        <label for="nlp_disclaimer" class="ui-label"><?php echo _('I understand and agree to the disclaimer.'); ?></label>
                    </div>
                </div>
            </div>
            
            <!-- AI Provider Selection -->
            <div class="tw-mb-4" id="ai_provider_div" style="display: none;">
                <label class="tw-block tw-text-sm tw-font-semibold tw-mb-2"><?php echo _('AI Provider'); ?></label>
                <div class="ui-radio-group tw-flex tw-flex-col tw-gap-2">
                    <?php
                    $providers = [
                        'openai' => 'OpenAI',
                        'mistral' => 'Mistral',
                        'anthropic' => 'Anthropic'
                    ];
                    foreach ($providers as $value => $label) {
                        echo '<div class="tw-flex tw-items-center tw-space-x-2">';
                        echo '<input type="radio" id="ai_provider_' . $value . '" name="ai_provider" value="' . $value . '"' . 
                             (($ai_provider == $value || (!$ai_provider && $value == 'openai')) ? ' checked' : '') . 
                             ' class="ui-radio-group-item">';
                        echo '<label for="ai_provider_' . $value . '" class="ui-label">' . $label . '</label>';
                        echo '</div>';
                    }
                    echo '<div class="tw-flex tw-items-center tw-space-x-2">';
                    echo '<input type="radio" id="ai_provider_self_hosted" name="ai_provider" value="self_hosted"' . 
                         ($ai_provider == "self_hosted" ? ' checked' : '') . 
                         ' class="ui-radio-group-item">';
                    echo '<label for="ai_provider_self_hosted" class="ui-label">' . _('Self-Hosted') . '</label>';
                    echo '</div>';
                    ?>
                </div>
            </div>

            <!-- API Key Input -->
            <div class="tw-mb-4" id="ai_api_key_input" style="display: none;">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" id="ai_api_key_label"><?php echo _('API Key'); ?></label>
                <input type="password" id="ai_api_key" name="ai_api_key" class="ui-input api_key_box tw-w-full"  
                       placeholder="••••••••••••••••••••••••••••••••••••••••" disabled 
                       value="<?php echo empty($ai_api_key) ? '' : html_escape($ai_api_key); ?>" />
            </div>

            <!-- Self-Hosted Fields -->
            <div class="tw-mb-4" id="self_hosted_fields" style="display: none;">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="self_host_ip_address"><?php echo _('Server Address'); ?></label>
                <input type="text" id="self_host_ip_address" name="self_host_ip_address" class="ui-input tw-w-full tw-mb-2" 
                       placeholder="e.g. http://192.168.1.1" 
                       value="<?php echo empty($self_host_ip_address) ? '' : html_escape($self_host_ip_address); ?>" disabled />
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="ai_port"><?php echo _('Port'); ?></label>
                <input type="number" id="ai_port" name="ai_port" class="ui-input tw-w-full" 
                       value="<?php echo empty($ai_port) ? '8000' : html_escape($ai_port); ?>" disabled />
                <p class="tw-text-sm tw-text-secondary-foreground/80 tw-mb-2"><?php echo _('For self-hosting instructions, please refer to the <a href="') . 'https://assets.nagios.com/downloads/nagios-log-server/docs/Serving-Nagios-Enterprises-Large-Language-Models.pdf' . _('">self hosting documentation</a> here.'); ?></p>
            </div>

            <!-- Key Validation Status -->
            <div id="key_validation_status" class="tw-mb-4" style="display: none;">
                <span id="loading_message" class="tw-text-sm"><?php echo _('Validating...'); ?></span>
                <span id="success_message" class="tw-text-sm tw-text-green-500" style="display: none;"><?php echo _('API Key is valid!'); ?></span>
                <span id="error_message" class="tw-text-sm tw-text-red-500" style="display: none;"><?php echo _('Invalid API Key!'); ?></span>
            </div>
        </div>
        <div class="tw-mt-4">
            <button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" value="1" name="saveglobals" class="ui-btn ui-btn-default"><?php echo _('Save Settings'); ?></button>
        </div>
        <?php echo form_close(); ?>
        <div class="tw-clear tw-pb-[100px]"></div>
    </div>
</div>




<?php echo $footer; ?>