<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <h1 class="form-title tw-inline-flex"><?php echo _("Admin Overview"); ?></h1>

        <div class="tw-my-4">
            <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                <span class="material-symbols-outlined">query_stats</span>
                <span class="form-header"><?php echo _("Cluster Statistics"); ?></span>
            </div>
            <div class="tw-rounded-lg tw-border-border tw-border tw-px-6 tw-pt-5 tw-pb-0">
                <div class="row">
                    <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                        <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo number_format($cluster['stats']['indices']['docs']['count']); ?></span><span><?php echo _("Documents"); ?></span></div>
                    </div>
                    <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                        <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo strtoupper($index['stats']['_all']['primaries']['store']['size']); ?></span><span><?php echo _("Primary Size"); ?></span></div>
                    </div>
                    <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                        <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo strtoupper($index['stats']['_all']['total']['store']['size']); ?></span><span><?php echo _("Total Size"); ?></span></div>
                    </div>
                    <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                        <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo $cluster['health']['number_of_data_nodes']; ?></span><span><?php echo _("Data Instances"); ?></span></div>
                    </div>
                    <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                        <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo $index['stats']['_shards']['total']; ?></span><span><?php echo _("Total Shards"); ?></span></div>
                    </div>
                    <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                        <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo $cluster['stats']['indices']['count']; ?></span><span><?php echo _("Indices"); ?></span></div>
                    </div>
                </div>
            </div>
        </div>

        <?php if (!$maintenance_active) { ?>
        <div class="tw-my-4 tw-p-4 tw-bg-warning-100 tw-border tw-border-warning-200 tw-rounded-lg">
            <div class="tw-flex tw-items-center tw-gap-2">
                <span class="material-symbols-outlined tw-text-warning-500">warning</span>
                <span><?php echo _("It looks like snapshots are currently <strong>turned off</strong>. For increased redundancy we recommend configuring automatic snapshots of your log data."); ?></span>
            </div>
            <div class="tw-mt-2">
                <a href="<?php echo site_url('admin/snapshots'); ?>" class="tw-text-primary-500 hover:tw-text-primary-600">
                    <?php echo _("Configure automatic snapshots"); ?>
                    <span class="material-symbols-outlined tw-align-middle tw-text-sm">chevron_right</span>
                </a>
            </div>
        </div>
        <?php } ?>

        <?php if (!empty($ports)) { ?>
        <div class="tw-my-4 tw-p-4 tw-bg-info-100 tw-border tw-border-info-200 tw-rounded-lg">
            <div class="tw-flex tw-items-center tw-gap-2">
                <span class="material-symbols-outlined tw-text-info-500">info</span>
                <span><?php echo _("<strong>Logstash</strong> is currently collecting locally on"); ?>:</span>
            </div>
            <div class="tw-mt-2">
                <?php foreach ($ports as $type => $p) { echo '<span class="tw-mx-1"><strong>'.$type.": ".implode(', ', $p)."</strong></span>"; } ?>
            </div>
        </div>
        <?php } ?>

        <div class="tw-my-4">
            <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                <span class="material-symbols-outlined">info</span>
                <span class="form-header"><?php echo _("Version Info"); ?></span>
            </div>
            <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                <table class="ui-table">
                    <tbody class="ui-tbody">
                        <tr class="ui-tr">
                            <td class="ui-td tw-font-bold tw-text-right tw-pr-4"><?php echo _('Nagios Log Server'); ?></td>
                            <td class="ui-td"><?php echo get_product_version(); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>

<?php echo $footer; ?>