<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <h1 class="form-title tw-inline-flex">
            <?php if ($nodes['stats']['count'] != 1 ) { echo _("Instance Overview"); } else { echo _("Instance Status"); ?> &middot; <?php echo $nodes['stats']['nodes'][key($nodes['stats']['nodes'])]['host']; ?> 
            <?php
            } ?>
        </h1>

        <?php 
        if ($nodes['stats']['count'] == 1 ): ?>
            <div class="tw-inline-flex tw-float-right tw-items-center">
                <tooltip-provider>
                    <tooltip data-position="top" data-delay="100">
                        <tooltip-trigger>
                            <span class="badge" name="cluster_id"><?php echo ' ' . $nodes['stats']['nodes'][key($nodes['stats']['nodes'])]['name']; ?><span class="material-symbols-outlined base">check_circle</span></span>
                        </tooltip-trigger>
                        <tooltip-content>
                            <div><?php echo _('Instance ID'); ?></div>
                        </tooltip-content>
                    </tooltip>
                </tooltip-provider>
            </div>
        <?php endif; ?>
        <div class="form-spacer"></div>

        <div id="workspace">
            <?php if ($nodes['stats']['count'] != 1 ): ?>
            <div>
                <div>
                    <div class="tw-my-4">
                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                            <span class="material-symbols-outlined">query_stats</span>
                            <span class="form-header"><?php echo _("Global Stats"); ?></span>
                        </div>
                        <div class="tw-rounded-lg tw-border-border tw-border tw-px-6 tw-pt-5 tw-pb-0">
                            <div class="row">
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo $nodes['stats']['global']['nodes']['count']['total'] ; ?></span><span><?php echo _("Total Instances"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo $nodes['stats']['global']['nodes']['count']['cluster_manager']; ?></span><span><?php echo _("Manager"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo $nodes['stats']['global']['nodes']['count']['data']; ?></span><span><?php echo _("Data"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo $nodes['stats']['global']['nodes']['os']['available_processors']; ?></span><span><?php echo _("Processors"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo $nodes['stats']['global']['nodes']['process']['cpu']['percent']; ?>%</span><span><?php echo _("Process CPU"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo humanize_filesize($nodes['stats']['global']['nodes']['os']['mem']['used_in_bytes']); ?></span><span><?php echo _("Memory Used"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo @humanize_filesize($nodes['stats']['global']['nodes']['os']['swap']['used']); ?></span><span><?php echo _("Swap"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo humanize_filesize($nodes['stats']['global']['nodes']['fs']['total']); ?></span><span><?php echo _("Total Storage"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo humanize_filesize($nodes['stats']['global']['nodes']['fs']['free']); ?></span><span><?php echo _("Free Storage"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo humanize_filesize($nodes['stats']['global']['nodes']['fs']['disk_read_size']); ?></span><span><?php echo _("Data Read"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo humanize_filesize($nodes['stats']['global']['nodes']['fs']['disk_write_size']); ?></span><span><?php echo _("Data Written"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-3 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo humanize_filesize($nodes['stats']['global']['nodes']['fs']['disk_io_size']); ?></span><span><?php echo _("I/O Size"); ?></span></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php else: ?>
            <div>
                <div >
                    <div class="tw-my-4">
                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                            <span class="material-symbols-outlined">query_stats</span>
                            <span class="form-header"><?php echo _("Instance Stats"); ?></span>
                        </div>
                        <div class="tw-rounded-lg tw-border-border tw-border tw-px-6 tw-pt-5 tw-pb-0">
                            <div class="row">
                                <div class="col-sm-12 col-md-6 col-lg-4 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['os']['swap']['used_in_bytes']); ?></span><span><?php echo _("Swap"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-4 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo strtoupper($nodes['stats']['nodes'][$nodeid]['fs']['total']['total']); ?></span><span><?php echo _("Total Storage"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-4 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo strtoupper($nodes['stats']['nodes'][$nodeid]['fs']['total']['free']); ?></span><span><?php echo _("Free Storage"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-4 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['fs']['io_stats']['total']['read_kilobytes'] * 1024); ?></span><span><?php echo _("Data Read"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-4 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['fs']['io_stats']['total']['write_kilobytes'] * 1024); ?></span><span><?php echo _("Data Written"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-4 stat-box-wrap">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo humanize_filesize(($nodes['stats']['nodes'][$nodeid]['fs']['io_stats']['total']['read_kilobytes'] + $nodes['stats']['nodes'][$nodeid]['fs']['io_stats']['total']['write_kilobytes']) * 1024); ?></span><span><?php echo _("I/O Size"); ?></span></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <div>
                <div>
                    <div>
                        <?php if (count($all_nodes) != 1): ?>
                        <div class="tw-my-4">
                            <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                                <i class="fa fa-building-o"></i>
                                <span class="form-header"><?php echo _("Instances"); ?></span>
                            </div>
                            <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                                <table id="indicesTable" class="ui-table">
                                    <thead class="ui-thead">
                                        <tr class="ui-tr">
                                            <th class="ui-th"><?php echo _("IP"); ?></th>
                                            <th class="ui-th"><?php echo _("Hostname"); ?></th>
                                            <th class="ui-th"><?php echo _("Port"); ?></th>
                                            <th class="ui-th"><?php echo _("1m, 5m, 15m Load"); ?></th>
                                            <th class="ui-th"><?php echo _("CPU") . " %"; ?></th>
                                            <th class="ui-th"><?php echo _("Memory Used"); ?></th>
                                            <th class="ui-th"><?php echo _("Memory Free"); ?></th>
                                            <th class="ui-th"><?php echo _("Storage Total"); ?></th>
                                            <th class="ui-th"><?php echo _("Storage Available"); ?></th>
                                            <th class="ui-th"><?php echo _("OpenSearch"); ?></th>
                                            <th class="ui-th"><?php echo _("Logstash"); ?></th>
                                            <th class="ui-th"><?php echo _("Actions"); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="ui-tbody">
                                        <?php foreach ($all_nodes as $node_id => $node): ?>
                                        <tr class="ui-tr">
                                            <td class="ui-td">
                                                <a data-title="Index Information" data-placement="bottom" rel="tipRight" href="<?php echo site_url('admin/instance_status/'.$node['name']); ?>" data-original-title="" title=""><?php if (!empty($node['ip'])) { echo $node['ip']; } else { echo $node['address']; } ?></a>
                                            </td>
                                            <td class="ui-td"><?php if (!empty($node['host'])) { echo $node['host']; } else { if ($node['hostname'] != $node['address']) { echo $node['hostname']; } } ?></td>
                                            <td class="ui-td"><?php echo $node['port']; ?></td>
                                            <td class="ui-td"><?php if (!empty($node['os']['cpu']['load_average'])) { echo number_format ($node['os']['cpu']['load_average']['1m'], 2).', '.number_format ($node['os']['cpu']['load_average']['5m'], 2).', '.number_format ($node['os']['cpu']['load_average']['15m'], 2); } ?></td>
                                            <td class="ui-td"><?php if (!empty($node['os']['cpu'])) { echo (int) $node['os']['cpu']['percent']; echo '%'; } ?></td>
                                            <td class="ui-td"><?php if (!empty($node['os']['mem'])) { echo strtoupper($node['os']['mem']['used_percent']); echo '%'; } ?></td>
                                            <td class="ui-td"><?php if (!empty($node['os']['mem'])) { echo strtoupper($node['os']['mem']['free_percent']); echo '%'; } ?></td>
                                            <td class="ui-td"><?php echo humanize_filesize($node['fs']['total']['total_in_bytes']); ?></td>
                                            <td class="ui-td"><?php echo humanize_filesize($node['fs']['total']['available_in_bytes']); ?></td>
                                            <td class="ui-td"><?php if ($node['opensearch']['status'] == 'running' && (!empty($node['name']) || !($node['last_updated'] < time()-300))) { echo '<span class="material-symbols-outlined tw-text-primary icon-in-table" title="'._("OpenSearch is running...").'">check_circle</span>'; } else { echo '<span class="material-symbols-outlined tw-text-primary icon-in-table" title="'._("OpenSearch is not running...").'">close</span>'; } ?></td>
                                            <td class="ui-td"><?php if ($node['logstash']['status'] == 'running' && (!empty($node['name']) || !($node['last_updated'] < time()-300))) { echo '<span class="material-symbols-outlined tw-text-primary icon-in-table" title="'._("Logstash is running...").'">check_circle</span>'; } else { echo '<span class="material-symbols-outlined tw-text-primary icon-in-table" title="'._("Logstash is not running...").'">close</span>'; } ?></td>
                                            <td class="ui-td"><a href="<?php echo site_url('configure/remove_instance/'.$node['id'].'/'.base64_encode('admin/instance_status')); ?>" title="<?php echo _("Remove instance from database"); ?>"><span class="material-symbols-outlined icon-in-table icon-hover">delete</span></a></td>
                                        </tr>
                                        <?php endforeach; // ($nodes['stats']['nodes'] as $node_id => $node) ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <?php else: ?>
                        <div>
                            <div class="tw-flex tw-gap-4">
                                <div class="tw-w-1/3">
                                    <div class="tw-my-4">
                                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                                        <span class="material-symbols-outlined">info</span>
                                            <span class="form-header"><?php echo _("Instance Information"); ?></span>
                                        </div>
                                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                                            <table class="ui-table">
                                                <tbody class="ui-tbody">
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("IP"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['ip']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Hostname"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['host']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("1m, 5m, 15m Load"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format ($nodes['stats']['nodes'][$nodeid]['os']['cpu']['load_average']['1m'], 2).', '.number_format ($nodes['stats']['nodes'][$nodeid]['os']['cpu']['load_average']['5m'], 2).', '.number_format ($nodes['stats']['nodes'][$nodeid]['os']['cpu']['load_average']['15m'], 2); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Memory (Used/Free)"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['os']['mem']['used_in_bytes']); ?> / <?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['os']['mem']['free_in_bytes']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Swap (Used/Free)"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['os']['swap']['used_in_bytes']); ?> / <?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['os']['swap']['free_in_bytes']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Total Memory"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['os']['mem']['available_in_bytes'] + $nodes['stats']['nodes'][$nodeid]['os']['mem']['used_in_bytes']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Total Swap"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['os']['swap']['total_in_bytes']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("CPU Usage"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['os']['cpu']['percent'] . '%'; ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tw-my-4">
                                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                                        <span class="material-symbols-outlined">database</span>
                                            <span class="form-header"><?php echo _("Indices"); ?></span>
                                        </div>
                                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                                            <table class="ui-table">
                                                <tbody class="ui-tbody">
                                                    <tr class="ui-tr">
                                                        <td class="ui-td" style="width: 40%; min-width: 100px;"><?php echo _("Logs Stored On This Instance"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['logstash_live_doc_count']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Documents Deleted"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['indices']['docs']['deleted']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Store Size"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['indices']['store']['size_in_bytes']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Index Total"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['indices']['indexing']['index_total']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Delete Total"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['indices']['indexing']['delete_total']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Get Total"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['indices']['get']['total']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Get(Exists) Total"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['indices']['get']['exists_total']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Get(Missing) Total"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['indices']['get']['missing_total']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Query Total"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['indices']['search']['query_total']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Fetch Total"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['indices']['search']['fetch_total']); ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="tw-w-1/3">
                                    <div class="tw-my-4">
                                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                                            <span class="material-symbols-outlined">settings</span>
                                            <span class="form-header"><?php echo _("Process"); ?></span>
                                        </div>
                                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                                            <table class="ui-table">
                                                <tbody class="ui-tbody">
                                                    <tr class="ui-tr">
                                                        <td class="ui-td" style="width: 40%; min-width: 100px;"><?php echo _("Open File Descriptors"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['process']['open_file_descriptors']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Maximum Open File Descriptors"); ?></td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['process']['max_file_descriptors']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("CPU Usage"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['process']['cpu']['percent']; ?>%</td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("CPU Total"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['process']['cpu']['total']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Total Virtual Memory"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['process']['mem']['total_virtual_in_bytes']); ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                        <div class="tw-my-4">
                                            <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                                            <span class="material-symbols-outlined">coffee</span>
                                            <span class="form-header"><?php echo _("JVM"); ?></span>
                                        </div>
                                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                                            <table class="ui-table">
                                                <tbody class="ui-tbody">
                                                    <tr class="ui-tr">
                                                        <td class="ui-td" style="width: 40%; min-width: 100px;"><?php echo _("Heap Used"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['jvm']['mem']['heap_used_in_bytes']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Heap Committed"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['jvm']['mem']['heap_committed_in_bytes']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Non Heap Used"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['jvm']['mem']['non_heap_used_in_bytes']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Non Heap Committed"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($nodes['stats']['nodes'][$nodeid]['jvm']['mem']['non_heap_committed_in_bytes']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("JVM Uptime"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['jvm']['uptime']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Thread Count/Peak"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['jvm']['threads']['count']; ?> / <?php echo $nodes['stats']['nodes'][$nodeid]['jvm']['threads']['peak_count']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("GC (Old) Count"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['jvm']['gc']['collectors']['old']['collection_count']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("GC (Old)Time"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['jvm']['gc']['collectors']['old']['collection_time']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("GC (Young) Count"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($nodes['stats']['nodes'][$nodeid]['jvm']['gc']['collectors']['young']['collection_count']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("GC (Young)Time"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['jvm']['gc']['collectors']['young']['collection_time']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Java Version"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['info']['nodes'][$nodeid]['jvm']['version']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("JVM Vendor"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['info']['nodes'][$nodeid]['jvm']['vm_vendor']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("JVM"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['info']['nodes'][$nodeid]['jvm']['vm_name']; ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="tw-w-1/3">
                                    <?php foreach($nodes['stats']['nodes'][$nodeid]['fs']['data'] as $data): ?>
                                    <div class="tw-my-4">
                                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                                        <span class="material-symbols-outlined">description</span>
                                            <span class="form-header"><?php echo _("File System"); ?></span>
                                        </div>
                                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                                            <table class="ui-table">
                                                <tbody class="ui-tbody">
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Path"); ?>:</td>
                                                        <td class="ui-td"><?php echo $data['path']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Mount"); ?>:</td>
                                                        <td class="ui-td"><?php echo $data['mount']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Type"); ?>:</td>
                                                        <td class="ui-td"><?php echo $data['type']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Total Space"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($data['total_in_bytes']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Free Space"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($data['available_in_bytes']); ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                    <?php foreach($nodes['stats']['nodes'][$nodeid]['fs']['io_stats']['devices'] as $device): ?>
                                    <div class="tw-my-4">
                                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                                            <span class="material-symbols-outlined">analytics</span>
                                            <span class="form-header"><?php echo _("I/O Stats"); ?></span>
                                        </div>
                                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                                            <table class="ui-table">
                                                <tbody class="ui-tbody">
                                                    <tr class="ui-tr">
                                                        <td class="ui-td" style="width: 20%; min-width: 80px;"><?php echo _("Device Name"); ?>:</td>
                                                        <td class="ui-td"><?php echo $device['device_name']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Device Reads"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($device['read_operations']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Device Writes"); ?>:</td>
                                                        <td class="ui-td"><?php echo number_format($device['write_operations']); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Read Size"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($device['read_kilobytes'] * 1024); ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Write Size"); ?>:</td>
                                                        <td class="ui-td"><?php echo humanize_filesize($device['write_kilobytes'] * 1024); ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                    <div class="tw-my-4">
                                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                                            <span class="material-symbols-outlined">list</span>
                                            <span class="form-header"><?php echo _("Thread Pools"); ?></span>
                                        </div>
                                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                                            <table class="ui-table">
                                                <tbody class="ui-tbody">
                                                    <tr class="ui-tr">
                                                        <td class="ui-td" style="width: 40%; min-width: 100px;"><?php echo _("Generic (Queue/Peak/Active)"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['generic']['queue']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['generic']['largest']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['generic']['active']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Get (Queue/Peak/Active)"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['get']['queue']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['get']['largest']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['get']['active']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Search (Queue/Peak/Active)"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['search']['queue']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['search']['largest']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['search']['active']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Write (Queue/Peak/Active)"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['write']['queue']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['write']['largest']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['write']['active']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Refresh (Queue/Peak/Active)"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['refresh']['queue']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['refresh']['largest']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['refresh']['active']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Flush (Queue/Peak/Active)"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['flush']['queue']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['flush']['largest']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['flush']['active']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Force Merge (Queue/Peak/Active)"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['force_merge']['queue']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['force_merge']['largest']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['force_merge']['active']; ?></td>
                                                    </tr>
                                                    <tr class="ui-tr">
                                                        <td class="ui-td"><?php echo _("Management (Queue/Peak/Active)"); ?>:</td>
                                                        <td class="ui-td"><?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['management']['queue']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['management']['largest']; ?>/<?php echo $nodes['stats']['nodes'][$nodeid]['thread_pool']['management']['active']; ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </div>
</div>

<?php echo $footer; ?>