<?php echo $header; ?>

<script>
var lastChecked;
function add_checkbox_magic() {
    var $chkboxes = $('input[name="sel"]');
    $chkboxes.click(function(e) {
        if (!lastChecked) {
            lastChecked = this;
            return;
        }
        if (e.shiftKey) {
            var start = $chkboxes.index(this);
            var end = $chkboxes.index(lastChecked);
            $chkboxes.slice(Math.min(start,end), Math.max(start,end)+ 1).prop('checked', lastChecked.checked);
        }
        lastChecked = this;
    });
}
$(document).ready(function() {
    add_checkbox_magic();

    $('.cb-toggle').click(function() {
        var repo_name = this.value;
        if ($(this).is(':checked')) {
            $('input.'+repo_name+'[name="sel"]').prop('checked', true);
        } else {
            $('input.'+repo_name+'[name="sel"]').prop('checked', false);
        }
    });
    $('.cb-toggle-delete').click(function() {
        if ($(this).is(':checked')) {
            $('input.rsi.rsi-delete').prop('checked', true);
        } else {
            $('input.rsi.rsi-delete').prop('checked', false);
        }
    })

    if ($('.no-repos-configured').length !== 0) {
        $("a[href='#settings']").click();
    }

    $('#restore-modal').on('hidden.bs.modal', function() {
        $('select.action-restore-indices').val('');
    });

    $('input.date-picker').datetimepicker();
});
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

    <div class="form-title" style="margin-bottom: 0px"><?php echo _('Snapshots &amp; Maintenance'); ?></div>

            <?php if (!empty($msg_html)) { ?>
            <div class="alert alert-<?php echo $msg_type; ?> alert-margin">
                <button type="button" class="close" data-dismiss="alert"><i class="material-symbols-outlined">close</i></button>
                <?php echo $msg_html; ?>
            </div>
            <?php } ?>

            
            <div class="container-fluid" id="workspace">

            <?php 
                $default_value = 'settings';
                if (!empty($was_post)) {
                    $default_value='snapshots';
                }
            ?>
                <ui-tabs default-value="<?php echo $default_value ?>">
                    <tabs-list>
                        <tabs-trigger value="snapshots"><?php echo _("Snapshots"); ?></tabs-trigger>
                        <tabs-trigger value="settings"><?php echo _("Maintenance and Repository Settings"); ?></tabs-trigger>
                    </tabs-list>
                    <tabs-content value="snapshots">
                        <div>
                            <?php if (count($repositories) == 0): ?>
                                <div class="no-repos-configured alert alert-warning"><?php echo _("No repositories configured! Please go to the 'Maintenance and Repository Settings' tab."); ?></div>
                            <?php endif; ?>
                            <?php foreach ($repositories as $name => $repository): ?>
                            <?php $name = htmlentities($name, ENT_QUOTES, 'UTF-8');?>
                            <div class="col-sm-12">
                                <div class="tw-my-4">
                                    <div class="tw-flex tw-justify-between tw-my-2">
                                        <div class="tw-flex tw-gap-2 tw-items-center">
                                            <span class="material-symbols-outlined">archive</span>
                                            <span class="form-header"><?php echo "$name"?></span>
                                        </div>
                                        <div class="tw-flex tw-gap-4">
                                            <ui-sheet>
                                                <ui-sheet-trigger>
                                                    <button class="ui-btn ui-btn-default">
                                                        <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                                                            <i class="material-symbols-outlined">filter_alt</i>
                                                            <?php echo _("Filter"); ?>
                                                        </div>
                                                    </button>
                                                </ui-sheet-trigger>
                                                <ui-sheet-content>
                                                    <div class="tw-flex tw-justify-between tw-items-center tw-mb-4">
                                                        <div class="form-header"><?php echo _("Filter Options"); ?></div>
                                                        <ui-sheet-close></ui-sheet-close>
                                                    </div>
                                                <?php echo form_open('admin/snapshots', array('method' => 'post')); ?>
                                                    <div class="tw-grid tw-gap-4">
                                                        <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                                                            <label class="tw-text-right tw-font-medium tw-mb-0"><?php echo _('Time Frame'); ?></label>
                                                            <select class="time-select ui-select tw-col-span-2" name="time">
                                                                <option value="24h"<?php if ($time == '24h' || $time == '') { echo ' selected'; } ?>><?php echo _('Last 24 Hours'); ?></option>
                                                                <option value="7d"<?php if ($time == '7d') { echo ' selected'; } ?>><?php echo _('Last 7 Days'); ?></option>
                                                                <option value="30d"<?php if ($time == '30d') { echo ' selected'; } ?>><?php echo _('Last 30 Days'); ?></option>
                                                                <option value="c"<?php if ($time == 'c') { echo ' selected'; } ?>><?php echo _('Custom'); ?></option>
                                                            </select>
                                                        </div>
                                                        <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 date-picker">
                                                            <label class="date-picker tw-text-right tw-font-medium tw-mb-0"><?php echo _('From'); ?></label>
                                                            <input type="text" name="from_date" class="date-picker ui-input tw-col-span-2" value="<?php if (!empty($start)) { echo $start; } ?>">
                                                            </div>
                                                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 date-picker">
                                                            <label class="date-picker tw-text-right tw-font-medium tw-mb-0"><?php echo _('to'); ?></label>
                                                            <input type="text" name="to_date" class="date-picker ui-input tw-col-span-2" value="<?php if (!empty($end)) { echo $end; } ?>">
                                                        </div>
                                                    </div>
                                                    <div class="tw-flex tw-justify-end tw-mt-4">
                                                        <tooltip-provider>
                                                                <tooltip data-position="bottom" data-delay="100">
                                                                    <tooltip-trigger class="tw-flex tw-items-center">
                                                                        <button class="ui-btn ui-btn-default" type="submit" data-repo="<?php echo $name;?>" data-snapshots='<?php echo json_encode($repository["snapshots"]);?>'>
                                                                            <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                                                                                <i class="material-symbols-outlined">filter_alt</i>                                
                                                                                <?php echo _('Filter'); ?>
                                                                            </div>
                                                                        </button>
                                                                    </tooltip-trigger>
                                                                    <tooltip-content>
                                                                        <div><?php echo _("Note that Snapshots contain all indices open when they were created, so indexes from slightly outside the Time Frame may appear."); ?></div>
                                                                    </tooltip-content>
                                                                </tooltip>
                                                        </tooltip-provider>
                                                    </div>
                                                </ui-sheet-content>
                                                <?php echo form_close(); ?>
                                            </ui-sheet>
                                        </div>

                                        <?php if (count($repositories) > 1): ?>

                                        <tooltip-provider>
                                            <tooltip data-position="bottom" data-delay="100">
                                                <tooltip-trigger class="tw-flex tw-items-center">
                                                    <span class="hide-grid material-symbols-outlined">visibility_off</span>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                    <div><?php echo _("Hide"); ?></div>
                                                </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>

                                        <?php endif; ?>

                                    </div>
                                    <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto display-table">
                                        <table class="ui-table">
                                            <thead class="ui-thead">
                                                <tr class="ui-tr">
                                                    <th class="ui-th"><input type="checkbox" class="cb-toggle ui-checkbox-group-item" value="<?php echo str_replace(' ', '-', $name);?>"></th>
                                                    <th class="ui-th"><?php echo _("Index");?></th>
                                                    <th class="ui-th"><?php echo _("Most Recent State");?></th>
                                                    <th class="ui-th"><?php echo _("Most Recent Snapshot Time");?></th>
                                                    <th class="ui-th"><?php echo _("OpenSearch Version");?></th>
                                                    <th class="ui-th"><?php echo _("Versions");?><i class="fa fa-question-circle fa-help tt-bind" data-placement="bottom" title="<?php echo _("Number of Snapshots that include this Index"); ?>"></i></th>
                                                    <th class="ui-th"></th>
                                                </tr>
                                            </thead>
                                            <tbody class="snapshots">
                                                <?php if (count($repository['indices']) == 0): ?>

                                                    <td class="ui-td" colspan="7"><?php echo _('No backups yet!'); ?></td>

                                                <?php endif;?>

                                                <?php
                                                foreach ($repository['indices'] as $index => $index_data) {
                                                    $unique = uniqid();
                                                ?>
                                                <tr class="ui-tr">
                                                    <td class="ui-td"><input type="checkbox" name="sel" class="<?php echo str_replace(' ', '-', $name);?> ui-checkbox-group-item" id="<?php echo $unique;?>" value="<?php echo $index;?>"></td>
                                                    <td class="ui-td"><label for="<?php echo $unique;?>"><?php echo $index; ?></label></td>
                                                    <td class="ui-td"><label for="<?php echo $unique;?>"><?php echo $index_data[0]->state;?></label></td>
                                                    <td class="ui-td"><label for="<?php echo $unique;?>"><?php echo date("Y-m-d H:i:s", $index_data[0]->start_time_in_millis/1000); ?></label></td>
                                                    <td class="ui-td"><label for="<?php echo $unique;?>"><?php echo $repository['snapshots'][0]->version;?></label></td>
                                                    <td class="ui-td"><label for="<?php echo $unique;?>"><?php echo count($index_data);?></label></td>
                                                    <td class="ui-td">
                                                        <button class="restore-index" data-repo="<?php echo $name; ?>" data-index="<?php echo $index; ?>" data-other='<?php echo json_encode($index_data); ?>' type="button">
                                                            <input name="repository" type="hidden" value="<?php echo $name; ?>"/>
                                                            <input name="index" type="hidden" value="<?php echo $index; ?>"/>
                                                            <tooltip-provider>
                                                                <tooltip data-position="bottom" data-delay="100">
                                                                    <tooltip-trigger>
                                                                        <span class="material-symbols-outlined ">settings_backup_restore</span>
                                                                    </tooltip-trigger>
                                                                    <tooltip-content>
                                                                        <div><?php echo _("Restore"); ?></div>
                                                                    </tooltip-content>
                                                                </tooltip>
                                                            </tooltip-provider>
                                                        </button>
                                                    </td>
                                                </tr>
                                                <?php
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                        <div class="tw-mt-2">
                                            <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                                                <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("With Selected");?></label>
                                                <div class="tw-flex tw-flex-row tw-mb-2 tw-w-[300px] tw-items-center tw-gap-2">
                                                <select class="action-restore-indices ui-select" data-repo="<?php echo $name;?>">
                                                    <option></option>
                                                    <option value="restore"><?php echo _("Restore"); ?></option>
                                                </select>
                                                <button class="ui-btn ui-btn-default show-delete-snapshots fr" data-repo="<?php echo $name;?>" data-snapshots='<?php echo json_encode($repository["snapshots"]);?>'><?php echo _("Delete Snapshots"); ?></button>
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </tabs-content>
                    <tabs-content value="settings">
                        <div>
                            <div class="col-sm-6">
                                <div class="tw-my-4">
                                    <div class="tw-flex tw-gap-2 tw-items-center tw-my-2 tw-h-9">
                                        <span class="material-symbols-outlined">build_circle</span>
                                        <span class="form-header"><?php echo _("Maintenance Settings"); ?></span>
                                    </div>
                                    <div id="maintenance" class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                                    <?php echo form_open('admin/snapshots'); ?>
                                        <table class="ui-table">
                                            <tbody class="ui-tbody">
                                                <tr class="ui-tr">
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-items-center tw-gap-0.5">
                                                            <?php echo _("Delete audit log entries older than"); ?>
                                                            <?php echo question_tooltip(_('Delete entries from the Nagios Log Server audit log found under Admin > Reports > Audit. Set to 0 to disable. Decimal values down to ".0001" supported for deleting data less than a day old.')); ?>
                                                        </div>
                                                    </td>
                                                    <td class="ui-td tw-w-[200px]">
                                                        <div class="tw-flex tw-gap-2 tw-items-center">
                                                            <input name="maintenance_settings[audit_retention]" type="text" class="ui-input" value="<?php echo htmlentities($maintenance_settings['audit_retention'], ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr class="ui-tr">
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-items-center tw-gap-0.5">
                                                            <?php echo _("Delete alert history older than"); ?>
                                                            <?php echo question_tooltip(_('Delete entries from the Alert History found under Alerting > Alerting > Alert History. Set to 0 to disable. Decimal values down to ".0001" supported for deleting data less than a day old.')); ?>
                                                        </div>
                                                    </td>
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-gap-2 tw-items-center">
                                                            <input name="maintenance_settings[alert_retention]" type="text" class="ui-input" value="<?php echo htmlentities($maintenance_settings['alert_retention'], ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr class="ui-tr">
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-items-center tw-gap-0.5">
                                                            <?php echo _("Optimize Indexes older than"); ?>
                                                            <?php echo question_tooltip(_('Performs a Lucene forceMerge on indexes where no new data will be ingested. Set to 0 to disable.')); ?>
                                                        </div>
                                                    </td>
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-gap-2 tw-items-center">
                                                            <input name="maintenance_settings[optimize_time]" type="text" class="ui-input" value="<?php echo htmlentities($maintenance_settings['optimize_time'], ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr class="ui-tr">
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-items-center tw-gap-0.5">
                                                            <?php echo _("Close indexes older than"); ?>
                                                            <?php echo question_tooltip(_('Marks indexes older that this value as closed. Closed indices do not take any system resources other than disk space, however are not searchable unless re-opened. Set to 0 to disable.')); ?>
                                                        </div>
                                                    </td>
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-gap-2 tw-items-center">
                                                            <input name="maintenance_settings[close_time]" type="text" class="ui-input" value="<?php echo htmlentities($maintenance_settings['close_time'], ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr class="ui-tr">
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-items-center tw-gap-0.5">
                                                            <?php echo _("Delete indexes older than"); ?>
                                                            <?php echo question_tooltip(_('Deletes indexes older than this value, freeing resources. This is permanant, the only way to restore a deleted index is from an archived snapshot. Set to 0 to disable.')); ?>
                                                        </div>
                                                    </td>
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-gap-2 tw-items-center">
                                                            <input name="maintenance_settings[delete_time]" type="text" class="ui-input" value="<?php echo htmlentities($maintenance_settings['delete_time'], ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr class="ui-tr">
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-items-center tw-gap-0.5">
                                                            <?php echo _("Repository to store snapshots in"); ?> <?php echo question_tooltip(_('Repository to store the snapshots of indexes.')); ?>
                                                        </div>
                                                    </td>
                                                    <?php if(!empty($repositories)): ?>
                                                    <td class="ui-td"><select name="maintenance_settings[repository]" class="ui-select">
                                                        <option value=""></option>
                                                        <?php foreach ($repositories as $name => $respsitory) { ?>
                                                        <?php $name = htmlentities($name, ENT_QUOTES, 'UTF-8');?>
                                                        <option value="<?php echo $name; ?>" <?php if (@$maintenance_settings['repository'] == $name) { echo 'selected'; } ?>><?php echo $name; ?></option>
                                                        <?php } ?>
                                                        </select></td>
                                                    <?php else: ?>
                                                    <td class="ui-td"><?php echo _('You must first create a repository on the right.'); ?></td>
                                                    <?php endif; ?>
                                                </tr>
                                                <tr class="ui-tr">
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-items-center tw-gap-0.5">
                                                            <?php echo _("Delete snapshots older than"); ?> <?php echo question_tooltip(_('Number of days before snapshots are deleted.')); ?>
                                                        </div>
                                                    </td>
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-gap-2 tw-items-center">
                                                    <?php if(!empty($repositories)): 
                                                        $delete_snapshot_time = isset($maintenance_settings['delete_snapshot_time']) ? $maintenance_settings['delete_snapshot_time'] : '720';?>
                                                        <input name="maintenance_settings[delete_snapshot_time]" type="text" class="ui-input" value="<?php echo htmlentities($delete_snapshot_time, ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                    <?php else: ?>
                                                        <?php echo _('You must first create a repository on the right.'); ?>
                                                    <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr class="ui-tr">
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-items-center tw-gap-0.5">
                                                            <?php echo _("Enable Maintenance and Snapshots"); ?> <?php echo question_tooltip(_('Enable or disable processing of all scheduled maintenance jobs.')); ?>
                                                        </div>
                                                    </td>
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-gap-2">
                                                            <div class="ui-radio-group">
                                                                <div class="tw-flex tw-items-center tw-space-x-2">
                                                                    <input type="radio" id="radio1" name="maintenance_settings[active]" value="1" <?php if ($maintenance_settings['active']) { echo "checked"; } ?> class="ui-radio-group-item">
                                                                    <label for="radio1" class="ui-label"><?php echo _('Yes'); ?></label>
                                                                </div>
                                                                <div class="tw-flex tw-items-center tw-space-x-2">
                                                                    <input type="radio" id="radio2" name="maintenance_settings[active]" value="0" <?php if (!$maintenance_settings['active']) { echo "checked"; } ?> class="ui-radio-group-item">
                                                                    <label for="radio2" class="ui-label"><?php echo _('No'); ?></label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr class="ui-tr">
                                                    <td class="ui-td">
                                                        <div class="tw-flex tw-items-center tw-gap-0.5">
                                                            <?php echo _("Last modified"); ?> <?php echo question_tooltip(_('The last time these settings were updated. If unknown, save to update last modified time.')); ?>
                                                        </div>
                                                    </td>
                                                    <td class="ui-td">
                                                        <?php if (!empty($maintenance_settings['last_modified'])) { echo date('r', $maintenance_settings['last_modified']); } else { echo _("Unknown"); } ?>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <div class="tw-text-right tw-mt-2"><button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" value="1" name="maintenance" class="ui-btn ui-btn-default"><?php echo _('Save Settings'); ?></button></div>
                                        <?php echo form_close(); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="tw-my-4">
                                    <div class="tw-flex tw-items-center tw-my-2 tw-justify-between">
                                        <div class="tw-gap-2 tw-flex tw-items-center">
                                        <span class="material-symbols-outlined">hard_drive</span>
                                            <span class="form-header"><?php echo _("Repositories"); ?></span>
                                        </div>
                                        <div class="tw-float-right">
                                            <span><button class="ui-btn ui-btn-outlined btn-create-repo" type="button"><?php echo _("Create Repository"); ?></button></span>
                                        </div>
                                    </div>
                                    <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                                        <table class="ui-table">
                                            <thead class="ui-thead">
                                                <tr class="ui-tr">
                                                    <th class="ui-th"><?php echo _("Name"); ?></th>
                                                    <th class="ui-th"><?php echo _("Location"); ?></th>
                                                    <th class="ui-th"><?php echo _("Type"); ?></th>
                                                    <th class="ui-th"><?php echo _("Size"); ?></th>
                                                    <th class="ui-th"></th>
                                                </tr>
                                            </thead>
                                            <tbody class="ui-tbody">
                                                <?php
                                                if (count($repositories) > 0) {
                                                foreach ($repositories as $name => $respsitory): ?>
                                                <?php $name = htmlentities($name, ENT_QUOTES, 'UTF-8');?>
                                                <tr class="ui-tr">
                                                    <td class="ui-td"><?php echo $name; ?></td>
                                                    <td class="ui-td"><?php echo $respsitory['settings']['location']; ?></td>
                                                    <td class="ui-td"><?php if ($respsitory['type'] == 'fs') { echo _("Filesystem"); } else { echo $respsitory['type']; } ?></td>
                                                    <td class="ui-td"><?php echo $respsitory['size']; ?></td>
                                                    <td class="ui-td">
                                                        <button class=" delete-repository" type="button">
                                                            <input type="hidden" value="<?php echo $name; ?>"/>
                                                            <tooltip-provider>
                                                                <tooltip data-position="bottom" data-delay="100">
                                                                    <tooltip-trigger>
                                                                        <span class="material-symbols-outlined ">delete</span>
                                                                    </tooltip-trigger>
                                                                    <tooltip-content>
                                                                        <div><?php echo _("Delete"); ?></div>
                                                                    </tooltip-content>
                                                                </tooltip>
                                                            </tooltip-provider>
                                                        </button>
                                                    </td>
                                                </tr>
                                                <?php endforeach;
                                                } else { ?>
                                                <tr class="ui-tr">
                                                    <td class="ui-td" colspan="9"><?php echo _("No repositories have been created."); ?></td>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                        <div class="clear"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </tabs-content>
                </ui-tabs>
            </div>
    </div>
</div>

<div class="modal hide" id="create-repo-modal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <?php echo form_open('admin/snapshots'); ?>
            <div class="modal-header">
                <h2 class="form-header"><?php echo _('Create Repository'); ?></h2>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <?php if (count($repo_paths) == 0) { ?>
                    <?php if ($clustered) { ?>
                <p class="form-subheader"><?php echo _('No network accessible repository paths configured. See <a href="https://opensearch.org/docs/latest/api-reference/snapshots/create-repository/">Registering or updating a Snapshot Repository</a> for more information on registering Snapshot Repositories. This location <b>MUST</b> be a shared filesystem accessible to all data instances in the cluster. If not, snapshots or restoration can fail. '); ?></p>
                    <?php } else { ?>
                <p class="form-subheader"><?php echo _('No repository paths configured. See <a href="https://opensearch.org/docs/latest/api-reference/snapshots/create-repository/">Registering or updating a Snapshot Repository</a> for more information on registering Snapshot Repositories.'); ?></p>
                    <?php } ?>
                <?php } else { ?>
                <p class="form-subheader"><?php echo _('The following directories have been registered with OpenSearch for use as possible Snapshot Repositories. See <a href="https://opensearch.org/docs/latest/api-reference/snapshots/create-repository/">Registering or updating a Snapshot Repository</a> for more information on registering Snapshot Repositories.'); ?></p>
                <div id="repo_form">
                    <table class="ui-table">
                        <tbody class="ui-tbody">
                            <tr class="ui-tr">
                                <td class="ui-td"><?php echo _('Repository Name'); ?>:</td>
                                <td class="ui-td"><input name="repository_name" type="text" class="ui-input" value="<?php if (!empty($repo['name'])) { echo htmlentities($repo['name'], ENT_COMPAT, 'UTF-8'); } ?>" /></td>
                            </tr>
                            <tr class="ui-tr">
                                <td class="ui-td"><?php echo _('Repository Location'); ?>:</td>
                                <td class="ui-td">
                                    <select class=" ui-select tw-col-span-2" name="repository_location">
                                        <?php foreach ($repo_paths as $repo_path) { ?>
                                            <option value="<?php echo $repo_path; ?>" <?php if (!empty($repo['location']) && $repo['location'] == $repo_path) echo ' selected'; ?> ><?php echo $repo_path; ?></option>
                                        <?php } ?>
                                    </select>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <?php } ?>
            </div>
            <div class="modal-footer tw-flex tw-space-x-4 tw-justify-end">
                <?php if (count($repo_paths) > 0) { ?>
                <button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" value="1" name="addrepo" class="ui-btn ui-btn-default"><?php echo _('Add Repository'); ?></button>
                <?php } ?>
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _('Close'); ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<div class="modal hide" id="indexes-modal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="form-header"><?php echo _('Indexes in Snapshot'); ?>: <span class="snapshot-time"></span></h2>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <table class="ui-table">
                    <thead class="ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th"><?php echo _('Index Name'); ?></th>
                        </tr>
                    </thead>
                    <tbody class="indexes-modal-list">
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _('Close'); ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal hide" id="restore-modal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="form-header"><?php echo _('Select Indexes to Restore'); ?></h2>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div class="form-subheader">
                    <?php echo sprintf(_('Restoring %s from time:'), '<b><span class="restore-index-name"></span></b>'); ?>
                </div>
                <div class="modal-body-container">
                    <table class="ui-table">
                        <thead class="ui-thead">
                            <tr class="ui-tr">
                                <th class="ui-th" colspan="2">
                                    <label><?php echo _('Choose one:') ?></label>
                                </th>
                            </tr>
                        </thead>
                        <tbody class="restore-snapshots ui-tbody">
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer tw-flex tw-space-x-4 tw-justify-end">
                <input type="hidden" class="restore-repo">
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _('Close'); ?></button>
                <button class="ui-btn ui-btn-default" id="do-restore" data-loading-text="<?php echo _('Restoring'); ?>..."><?php echo _('Restore Index'); ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal hide" id="delete-snapshot-modal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="form-header"><?php echo _('Select Snapshots to Delete'); ?></h2>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div class="form-subheader">
                    <?php echo _('Deleting from repository'); ?> <b><span class="repo-name"></span></b>
                </div>
                <div class="modal-body-container">
                    
                </div>
                <div>
                    <table class="ui-table">
                        <thead class="ui-thead">
                            <tr class="ui-tr">
                                <th class="ui-th"><input type="checkbox" class="cb-toggle-delete ui-checkbox-group-item"></th>
                                <th class="ui-th">
                                    <label><?php echo _('Select which snapshots to delete:') ?></label>
                                </th>
                            </tr>
                        </thead>
                        <tbody class="delete-snapshots ui-tbody">
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer tw-flex tw-space-x-4 tw-justify-end">
                <input type="hidden" class="restore-repo">
                <p class="deletion-progress fl form-subheader"></p>
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _('Close'); ?></button>
                <button class="ui-btn ui-btn-default" id="do-delete-snapshots" data-loading-text="<?php echo _('Deleting'); ?>..."><?php echo _('Delete Snapshot'); ?></button>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>
