<?php echo $header; ?>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="form-container">
        <div class="form-title"><?php echo _("Alerts"); ?></div>
        <div class="form-subtitle"><?php echo _("Page refreshes every 30 seconds."); ?></div>
        <div class="form-spacer"></div>
        <?php if (!empty($msg)) { ?>
        <div class="alert alert-<?php echo $msg_type; ?>"><?php echo $msg; ?><button type="button" class="close material-symbols-outlined" data-dismiss="alert">close</button></div>
        <?php } ?>

        <div>
            <!-- criteria_interior lives outside the form so that we don't send him by accident -->
            <div id="criteria_interior" class="hide">
                <div class="tw-flex tw-flex-row tw-gap-2 tw-mb-2">
                    <input type="text" class="criteria_field ui-input" placeholder="<?php echo _('Field');?>" name="criteria_fields[]">
                    <select class="criteria_comparator ui-select" name="criteria_comparators[]">
                        <option value="==">==</option>
                        <option value="!=">!=</option>
                        <option value=">">&gt;</option>
                        <option value=">=">>=</option>
                        <option value="<">&lt;</option>
                        <option value="<=">&lt;=</option>
                        <option value="=~">=~</option>
                        <option value="!~">!~</option>
                        <option value="in">in</option>
                        <option value="not in">not in</option>
                    </select>
                    <input type="text" class="criteria_value ui-input" placeholder="<?php echo _('Value');?>" name="criteria_values[]">
                    <select class="criteria_boolean ui-select" data-iter="1" name="criteria_booleans[]">
                        <option value=""></option>
                        <option value="and">and</option>
                        <option value="or">or</option>
                        <!-- There's actually a bug in the version of logstash we're using - these operators were documented but do not work -->
                        <!--<option value="nand">nand</option>-->
                        <!--<option value="xor">xor</option>-->
                    </select>
                </div>
            </div>
            <div class="tw-flex tw-flex-row tw-justify-between tw-mt-6 tw-mb-4">
                <div class="tw-flex tw-flex-row tw-gap-2">
                    <?php if (user_has_permission('alerts', array('create'))) { ?>
                    <button id="create-alert" class="ui-btn ui-btn-outlined">
                        <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                            <div class="material-symbols-outlined">add</div>
                            <?php echo _("New Alert"); ?>
                        </div>
                    </button>
                    <a href="<?php echo site_url('alerts/history'); ?>" class="ui-btn ui-btn-secondary no-primary"><?php echo _('View alert history'); ?></a>
                    <?php } else { ?>
                    <div><?php echo _('All alerts'); ?> (<?php echo _('read only mode'); ?>) - <a class="ui-btn ui-btn-secondary no-primary" href="<?php echo site_url('alerts/history'); ?>"><?php echo _('View alert history'); ?></a></div>
                    <?php } ?>
                </div>
                <div>
                    <?php
                    $attr = array("class" => "tw-flex tw-gap-2 tw-items-center");
                    echo form_open('alerts', $attr);
                    ?>
                    <input type="text" name="search" class="ui-input" value="<?php if (!empty($search)) { echo htmlentities($search, ENT_QUOTES, 'UTF-8'); } ?>" placeholder="<?php echo _('Search by alert name'); ?>">
                    <button type="submit" class="ui-btn ui-btn-default"><?php echo _("Search"); ?></button>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <ui-tabs default-value="query">
            <tabs-list class="tw-w-full">
                <tabs-trigger value="query"><?php echo _("Query"); ?></tabs-trigger>
                <tabs-trigger value="real"><?php echo _("Real-Time"); ?></tabs-trigger>
                <tabs-trigger value="freshness"><?php echo _("Host Freshness"); ?></tabs-trigger>
            </tabs-list>
            <tabs-content value="query">

                <div class="form-header tw-mb-4"><?php echo _("Query Alerts"); ?></div>

                <table class="ui-table">
                    <thead class="ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th"><?php echo _("Alert Name"); ?></th>
                            <th class="ui-th"><?php echo _("Created By"); ?></th>
                            <th class="ui-th"><?php echo _("Last Run"); ?></th>
                            <th class="ui-th"><?php echo _("Status"); ?></th>
                            <th class="ui-th"><?php echo _("Alert Output"); ?></th>
                            <th class="ui-th"><?php echo _("Notification Method"); ?></th>
                            <th class="ui-th"></th>
                        </tr>
                    </thead>
                    <tbody id="alert-list" class="ui-tbody">
                        <?php 
                        $alerts_query = array_filter($alerts, function($alert) {
                            return !array_key_exists('alert_type', $alert) || $alert['alert_type'] === 'query';
                        });

                        if (count($alerts_query) > 0) {
                            foreach ($alerts_query as $alert) { ?>
                        <tr class="ui-tr">
                            <td class="ui-td">
                                <div class="tw-flex tw-items-center">
                                    <?php
                                    echo $alert['name'];
                                    if (!$alert['active']) { ?>
                                    <tooltip-provider>
                                        <tooltip data-position="top" data-delay="100">
                                            <tooltip-trigger>
                                                <span class="badge tw-ml-2"><?php echo _("Not Active"); ?></span>
                                            </tooltip-trigger>
                                            <tooltip-content>
                                            <div><?php echo _("This alert is not active, so it will not be ran again automatically until activated."); ?></div>
                                        </tooltip-content>
                                        </tooltip>
                                    </tooltip-provider>
                                    <?php } ?>
                                </div>
                            </td>
                            <td class="ui-td"><?php echo $alert['created_by']; ?></td>
                            <td class="ui-td"><?php if (!empty($alert['last_run'])) echo date("r", $alert['last_run']); else echo _("Never") ?></td>
                            <td class="ui-td">
                                <div class="badge badge-<?php echo $alert['last_status']; ?>"><?php echo $alert['last_status']; ?></div>
                            </td>
                            <td class="ui-td">
                                <td-overflow class="tw-max-w-[500px]">
                                    <td-overflow-content class="tw-font-geist-mono geist-mono">
                                        <?php echo $alert['last_output']; ?>
                                    </td-overflow-content>
                                </td-overflow>
                            </td>
                            <td class="ui-td"><?php if (empty($alert['method']['type'])) { echo _("None"); } else { echo $alert['pretty_method']; } ?></td>
                            <td class="ui-td actions">
                                <dropdown-menu data-position="bottom">
                                    <dropdown-trigger>
                                        <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                                    </dropdown-trigger>
                                    <dropdown-content class="ui-dropdown-content">
                                    <?php if (empty($alert['dash_query'])) { ?>
                                        <a href="<?php echo site_url('alerts/show_custom/'.$alert['id']); ?>" target="_new" >
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Show custom query results"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } else { ?>
                                        <a href="<?php echo site_url('alerts/show/'.$alert['id']); ?>" target="_new">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Show alert in dashboard"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } ?>
                                        <a href="<?php echo site_url('alerts/run/'.$alert['id']); ?>">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Run this alert now"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php 
                                    if ((user_has_permission('alerts', array('edit')) && $alert['created_by'] == $username) || user_has_permission('alerts', array('all'))) {
                                        if ($alert['active']) {
                                    ?>
                                        <a href="<?php echo site_url('alerts/deactivate/'.$alert['id']); ?>">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Deactivate this alert"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } else { ?>
                                        <a href="<?php echo site_url('alerts/activate/'.$alert['id']); ?>">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Activate this alert"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } ?>
                                        <a class="edit" data-aid="<?php echo $alert['id']; ?>">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Edit this alert"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } if ((user_has_permission('alerts', array('delete')) && $alert['created_by'] == $username) || user_has_permission('alerts', array('all'))) { ?>
                                        <a href="<?php echo site_url('alerts/delete/'.$alert['id']); ?>">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Remove"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } ?>
                                    </dropdown-content>
                                </dropdown-menu>
                            </td>
                        </tr>
                            <?php } 
                        } else {
                        ?>
                        <tr class="ui-tr">
                            <td class="ui-td" colspan="9"><?php echo _("You have no alerts created."); ?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </tabs-content>
            <tabs-content value="real">

                <div class="form-header tw-mb-4"><?php echo _("Real-Time Alerts"); ?></div>

                <table class="ui-table">
                    <thead class="ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th"><?php echo _("Alert Name"); ?></th>
                            <th class="ui-th"><?php echo _("Created By"); ?></th>
                            <th class="ui-th"><?php echo _("Criteria"); ?></th>
                            <th class="ui-th"><?php echo _("Last Alert"); ?></th>
                            <th class="ui-th"><?php echo _("Notification Method"); ?></th>
                            <th class="ui-th"></th>
                        </tr>
                    </thead>
                    <tbody id="real-time-alert-list" class="ui-tbody">
                        <?php 
                        $alerts_live = array_filter($alerts, function($alert) {
                            return array_key_exists('alert_type', $alert) && $alert['alert_type'] === 'real_time';
                        });

                        if (count($alerts_live) > 0) {
                            foreach ($alerts_live as $alert) { ?>
                        <tr class="ui-tr">
                            <td class="ui-td">
                                <div class="tw-flex tw-items-center">
                                    <?php
                                    echo $alert['name'];
                                    if (!$alert['active']) { ?>
                                    <tooltip-provider>
                                        <tooltip data-position="top" data-delay="100">
                                            <tooltip-trigger>
                                                <span class="badge tw-ml-2"><?php echo _("Not Active"); ?></span>
                                            </tooltip-trigger>
                                            <tooltip-content>
                                            <div><?php echo _("This alert is not active, so it will not be ran again automatically until activated."); ?></div>
                                        </tooltip-content>
                                        </tooltip>
                                    </tooltip-provider>
                                    <?php } ?>
                                </div>
                            </td>
                            <td class="ui-td"><?php echo $alert['created_by']; ?></td>
                            <td class="ui-td"><?php echo $alert['criteria_display']; ?></td>
                            <td class="ui-td"><?php if (!empty($alert['last_run'])) echo str_replace(' ', '&nbsp;', date("r", $alert['last_run'])); else echo _("Never") ?></td>
                            <td class="ui-td"><?php if (empty($alert['method']['type'])) { echo _("None"); } else { echo $alert['pretty_method']; } ?></td>
                            <td class="ui-td actions">
                                <dropdown-menu data-position="bottom">
                                    <dropdown-trigger>
                                        <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                                    </dropdown-trigger>
                                    <dropdown-content class="ui-dropdown-content">
                                    <?php 
                                    if ((user_has_permission('alerts', array('edit')) && $alert['created_by'] == $username) || user_has_permission('alerts', array('all'))) {
                                        if ($alert['active']) {
                                    ?>                                        
                                        <a href="<?php echo site_url('alerts/deactivate/'.$alert['id'].'/true?'); ?>" class="real-time-activate">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Deactivate this alert"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } else { ?>
                                        <a href="<?php echo site_url('alerts/activate/'.$alert['id'].'/true?'); ?>" class="real-time-activate">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Activate this alert"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } ?>
                                        <a class="edit" data-aid="<?php echo $alert['id']; ?>">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Edit this alert"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } if ((user_has_permission('alerts', array('delete')) && $alert['created_by'] == $username) || user_has_permission('alerts', array('all'))) { 
                                        /* If a real-time alert is not active, it has already been removed from the logstash config.
                                         * We check this using the ternary op in several places below to determine what frontend functions are invoked on deletion */ ?>
                                        <a class="<?php echo $alert['active'] ? 'real-time-remove':''; ?>" href="<?php echo site_url('alerts/delete/'.$alert['id']) . "?" . ($alert['active'] ? 'real_time=true' : '') . "&name=".urlencode($alert['name']); ?>">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Remove"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } ?>
                                    </dropdown-content>
                                </dropdown-menu>
                            </td>
                        </tr>
                            <?php } 
                        } else {
                        ?>
                        <tr class="ui-tr">
                            <td class="ui-td" colspan="9"><?php echo _("You have no alerts created."); ?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </tabs-content>
            <tabs-content value="freshness">

                <div class="form-header tw-mb-4"><?php echo _("Host Freshness Alerts"); ?></div>

                <table class="ui-table">
                    <thead class="ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th"><?php echo _("Alert Name"); ?></th>
                            <th class="ui-th"><?php echo _("Created By"); ?></th>
                            <th class="ui-th"><?php echo _("Last Run"); ?></th>
                            <th class="ui-th"><?php echo _("Status"); ?></th>
                            <th class="ui-th"><?php echo _("Alert Output"); ?></th>
                            <th class="ui-th"><?php echo _("Notification Method"); ?></th>
                            <th class="ui-th"></th>
                        </tr>
                    </thead>
                    <tbody id="host-freshness-alert-list" class="ui-tbody">
                        <?php 
                        $alerts_freshness = array_filter($alerts, function($alert) {
                            return array_key_exists('alert_type', $alert) && $alert['alert_type'] === 'host_freshness';
                        });

                        if (count($alerts_freshness) > 0) {
                            foreach ($alerts_freshness as $alert) { ?>
                        <tr class="ui-tr">
                            <td class="ui-td">
                                <div class="tw-flex tw-items-center">
                                    <?php
                                    echo $alert['name'];
                                    if (!$alert['active']) { ?>
                                    <tooltip-provider>
                                        <tooltip data-position="top" data-delay="100">
                                            <tooltip-trigger>
                                                <span class="badge tw-ml-2"><?php echo _("Not Active"); ?></span>
                                            </tooltip-trigger>
                                            <tooltip-content>
                                            <div><?php echo _("This alert is not active, so it will not be ran again automatically until activated."); ?></div>
                                        </tooltip-content>
                                        </tooltip>
                                    </tooltip-provider>
                                    <?php } ?>
                                </div>
                            </td>
                            <td class="ui-td"><?php echo $alert['created_by']; ?></td>
                            <td class="ui-td"><?php if (!empty($alert['last_run'])) echo date("r", $alert['last_run']); else echo _("Never") ?></td>
                            <td class="ui-td">
                                <div class="badge badge-<?php echo $alert['last_status']; ?>"><?php echo $alert['last_status']; ?></div>
                            </td>
                            <td class="ui-td">
                                <td-overflow class="tw-max-w-[500px]">
                                    <td-overflow-content class="tw-font-geist-mono geist-mono">
                                        <?php echo $alert['last_output']; ?>
                                    </td-overflow-content>
                                </td-overflow>
                            </td>
                            <td class="ui-td"><?php if (empty($alert['method']['type'])) { echo _("None"); } else { echo $alert['pretty_method']; } ?></td>
                            <td class="ui-td actions">
                                <dropdown-menu data-position="bottom">
                                    <dropdown-trigger>
                                        <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                                    </dropdown-trigger>
                                    <dropdown-content class="ui-dropdown-content">
                                    <?php 
                                    if ((user_has_permission('alerts', array('edit')) && $alert['created_by'] == $username) || user_has_permission('alerts', array('all'))) {
                                        if ($alert['active']) {
                                    ?>
                                        <a href="<?php echo site_url('alerts/deactivate/'.$alert['id']); ?>">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Deactivate this alert"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } else { ?>
                                        <a href="<?php echo site_url('alerts/activate/'.$alert['id']); ?>">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Activate this alert"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } ?>
                                        <a class="edit" data-aid="<?php echo $alert['id']; ?>">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Edit this alert"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } if ((user_has_permission('alerts', array('delete')) && $alert['created_by'] == $username) || user_has_permission('alerts', array('all'))) { ?>
                                        <a href="<?php echo site_url('alerts/delete/'.$alert['id']); ?>">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _("Remove"); ?>
                                            </dropdown-item>
                                        </a>
                                    <?php } ?>
                                    </dropdown-content>
                                </dropdown-menu>
                            </td>
                        </tr>
                            <?php } 
                        } else {
                        ?>
                        <tr class="ui-tr">
                            <td class="ui-td" colspan="9"><?php echo _("You have no alerts created."); ?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </tabs-content>
        </ui-tabs>
    </div>
</div>

<div id="alert-modal" class="modal hide fade" data-backdrop="static" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header"><?php echo _("Create an Alert"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body delete-modal-on-close">
                <?php if (is_demo_mode()) { ?>
                <div class="alert alert-error">
                    <?php echo _("This function is not available in demo mode."); ?>
                </div>
                <?php } ?>
                <div id="create-alert-message" class="alert hide">
                    <div id="alert-message"></div>
                </div>
                <div class="alert-body">
                    <input type="hidden" value="" id="a_id">
                    <div>
                        <div class="tw-flex tw-gap-4 tw-flex-col">
                            <div>
                                <label class="tw-block tw-text-sm tw-font-medium" for="a_name"><?php echo _("Alert Name"); ?></label>
                                <input class="ui-input" type="text" name="name" id="a_name">
                            </div>
                            <div class="tw-flex tw-flex-row tw-gap-2 tw-items-center">
                                <div class="choose_paradigm tw-w-1/2">
                                    <label class="tw-block tw-text-sm tw-font-medium" for="a_paradigm"><?php echo _("Type"); ?></label>
                                    <div>
                                        <select class="ui-select" name="a_paradigm" id="select-paradigm">
                                            <option id="query_paradigm" value="query"><?php echo _('Query'); ?></option>
                                            <option id="real_time_paradigm" value="real_time"><?php echo _('Real-Time'); ?></option>
                                            <option id="host_freshness_paradigm" value="host_freshness"><?php echo _('Host Freshness'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="alert_option query_option tw-w-1/2" id="queries-box">
                                    <label class="ui-label tw-flex tw-flex-row tw-gap-2 tw-items-center tw-mb-0" for="a_name">
                                        <?php
                                        echo _("Query");
                                        echo question_tooltip("Queries are created in the dashboard using the Query Manager.");
                                        ?>  
                                    </label>
                                    <select id="a_queries" name="queries" class="ui-select"></select>
                                </div>
                                <div class="alert_option host_freshness_option tw-w-1/2 hide">
                                    <label class="ui-label tw-flex tw-flex-row tw-gap-2 tw-items-center tw-mb-0" for="a_hosts">
                                        <?php
                                        echo _("Hosts");
                                        echo question_tooltip("Retaining the default will check for a recent log from any IPv4 address that has ever sent a log to the cluster. <br> To alert per subnet, specify the subnet in CIDR notation. For multiple subnets in one alert, separate subnets with a comma.");
                                        ?>
                                    </label>
                                    <input type="text" class="ui-input" name="hosts" id="a_hosts" value="0.0.0.0/0">
                                </div>
                            </div>
                            <div class="alert_option real_time_option hide">
                                <label class="tw-block tw-text-sm tw-font-medium" for="a_criteria"><?php echo _("Criteria"); ?></label>
                                <div>
                                    <div id="a_criteria">
                                        <!-- Populated in JS - interior gets replaced by #criteria_interior -->
                                    </div>
                                </div>
                            </div>
                            <!-- This div isn't referenced anywhere so it's just always hidden I guess? -->
                            <!-- <div class="hide" id="raw-queries-box">
                                <label for="a_name"><?php //echo _("Raw Query"); ?></label>
                                <div>
                                    <textarea id="a_raw_query"></textarea>
                                </div>
                            </div> -->
                            <div class="tw-flex tw-flex-row tw-gap-2 tw-items-center alert_option query_option">
                                <div class="tw-w-1/2">
                                    <label class="ui-label tw-flex tw-flex-row tw-gap-2 tw-items-center tw-mb-0" for="a_ci">
                                        <?php
                                        echo _("Check Interval");
                                        echo question_tooltip("Check interval is how often the check will be performed, default is s for seconds. <br> The values available are seconds (s), minutes (m), hours (h), and days (d). <br> Example check intervals: 60s, 5m, 10m, 2h, 1d.");
                                        ?>
                                    </label>
                                    <input type="text" class="ui-input" name="check_interval" id="a_ci" value="5m">
                                </div>
                                <div class="tw-w-1/2">
                                    <label class="ui-label tw-flex tw-flex-row tw-gap-2 tw-items-center tw-mb-0" for="a_lp">
                                        <?php
                                        echo _("Lookback Period");
                                        echo question_tooltip("How long to look back when grabbing data to query, default is s for seconds. <br> This will normally be the same as the check interval. Example lookback periods: 60s, 5m, 10m, 2h, 1d.");
                                        ?>
                                    </label>
                                    <input type="text" class="ui-input" name="lookback_period" id="a_lp" value="5m">
                                </div>
                            </div>
                            <div class="alert_option query_option host_freshness_option">
                                <label class="ui-label tw-flex tw-flex-row tw-gap-2 tw-items-center tw-mb-0" for="a_w">
                                    <?php
                                    echo _("Thresholds");
                                    echo question_tooltip("Can use any valid Nagios threshold value. <br> A threshold of 'n' means that you will be alerted when more than 'n' events occur in the lookback period.");
                                    ?>
                                </label>
                                <div class="tw-flex tw-flex-row tw-gap-2 tw-items-center tw-whitespace-nowrap">
                                    <input type="text" class="ui-input" name="warning" id="a_w" placeholder="<?php echo _("Warning"); ?>">
                                    <input type="text" class="ui-input" name="critical" id="a_c" placeholder="<?php echo _("Critical"); ?>"> 
                                    <div class="form-subheader"><?php echo _("# of events"); ?></div>
                                </div>
                            </div>
                            <div class="tw-flex tw-flex-row tw-gap-2 tw-items-center">
                                <div class="alert_option real_time_option hide tw-w-1/2">
                                    <label class="ui-label tw-flex tw-flex-row tw-gap-2 tw-items-center tw-mb-0" for="a_min_gap">
                                        <?php
                                        echo _("Rate Limit");
                                        echo question_tooltip("Alert at most once every n seconds per instance. <br> e.g. for a 3-node cluster with a rate limit of 5, you would get a maximum of 3 alerts per 5 seconds.");
                                        ?>
                                    </label>
                                    <input type="text" class="ui-input" name="min_gap" id="a_min_gap" size="3">
                                </div>
                                <div class="tw-w-1/2">
                                    <label class="ui-label tw-flex tw-flex-row tw-gap-2 tw-items-center tw-mb-0" for="a_type">
                                        <?php
                                        echo _("Notification Method");
                                        echo question_tooltip("Define how you would like to receive the check when it meets the requirements.");
                                        ?>
                                    </label>
                                    <select class="ui-select" name="type" id="a_type" onchange="show_method_options(this);">
                                        <option value=""><?php echo _("None"); ?></option>
                                        <?php if (user_has_permission('alerts', array('all'))) { ?>
                                        <option value="nrdp"><?php echo _("Nagios (send using NRDP)"); ?></option>
                                        <?php if (show_nagios_reactor()) { ?><option value="reactor"><?php echo _("Nagios Reactor Event Chain"); ?></option><?php } ?>
                                        <option value="exec"><?php echo _("Execute Script"); ?></option>
                                        <option value="snmp"><?php echo _("Send SNMP Trap"); ?></option>
                                        <?php } ?>
                                        <option value="email"><?php echo _("Email Users"); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="alert_option real_time_option hide">
                                <div class="tw-flex tw-items-center tw-space-x-2">
                                    <input type="checkbox" id="a_do_save_apply" name="save_apply" class="ui-checkbox-group-item">
                                    <label class="ui-label tw-flex tw-flex-row tw-gap-2 tw-items-center tw-mb-0 for="a_do_save_apply" class="ui-label">
                                        <?php
                                        echo _('Save & Apply Configuration');
                                        echo question_tooltip("Real-time alerts require Logstash to be restarted. <br> When creating multiple alerts, consider unchecking this box until the last alert is being entered. <br> You can also do this afterwards by going to Configure > Apply Configuration.");
                                        ?>
                                    </label>
                                </div>
                            </div>
                            <div class="method_option email_option">
                                <div class="tw-flex tw-flex-row tw-gap-2">
                                    <div class="tw-w-1/2 tw-h-full">
                                        <label class="tw-block tw-text-sm tw-font-medium" for="a_users"><?php echo _("Select Users"); ?></label>
                                        <select id="select_users" class="ui-select-multi" name="users" multiple <?php echo ($contact_edit_allowed ? '' : 'disabled'); ?>></select>
                                    </div>
                                    <div class="tw-w-1/2">
                                        <label class="tw-block tw-text-sm tw-font-medium" for="a_users"><?php echo _("Email Template"); ?></label>
                                        <select class="ui-select" id="templates" name="tpl_id"></select>
                                    </div>
                                </div>
                            </div>
                        <?php if (!$contact_edit_allowed) { ?>
                            <div class="method_option email_option">
                                <div class="tw-flex tw-items-center tw-space-x-2">
                                    <input type="checkbox" id="checkbox_self" name="include_self" class="ui-checkbox-group-item" value="1">
                                    <label class="tw-mb-0 ui-label" for="checkbox_self">
                                        <?php echo _('Include yourself in the contact list.');?>
                                    </label>
                                </div>
                            </div>
                        <?php } ?>
                            <div class="method_option exec_option tw-w-full">
                                <label class="tw-block tw-text-sm tw-font-medium" for="a_script"><?php echo _("Script"); ?></label>
                                <input type="text" class="ui-input" name="exec_location" id="a_script" value="" placeholder="/usr/local/nagioslogserver/scripts/myscript.sh">
                            </div>
                            <div class="method_option exec_option tw-w-full">
                                <label class="tw-block tw-text-sm tw-font-medium" for="a_args"><?php echo _("Arguments"); ?></label>
                                <div>
                                    <input type="text" class="ui-input" name="exec_args" id="a_args" value="" placeholder="-H 192.168.0.1 -U test -p hello">
                                    <div class="form-subheader tw-mt-2">
                                        <div><?php echo _("Alerts will automatically replace these placeholders"); ?>:</div>
                                        <div><strong>%count%</strong> - <?php echo _("The total # of events"); ?></div>
                                        <div><strong>%status%</strong> - <?php echo _("The status (ok, warning, critical)"); ?></div>
                                        <div><strong>%output%</strong> - <?php echo _("The output from the alert"); ?></div>
                                        <div><strong>%lastrun%</strong> - <?php echo _("The timestamp of the last run"); ?></div>
                                    </div>
                                </div>
                            </div>
                            <div class="method_option nrdp_option tw-w-1/2">
                                <label class="tw-block tw-text-sm tw-font-medium" for="a_nrdp_servers"><?php echo _("NRDP Server"); ?></label>
                                <select class="ui-select" id="a_nrdp_servers" name="nrdp_server"></select>
                            </div>
                            <div class="method_option nrdp_option">
                                <div class="tw-flex tw-flex-row tw-gap-2">
                                    <div class="tw-w-1/2">
                                        <label for="a_hostname" class="ui-label tw-flex tw-flex-row tw-gap-2 tw-items-center tw-mb-0">
                                            <?php
                                            echo _("Hostname");
                                            echo question_tooltip("The hostname you want the alert to show up as in Nagios.");
                                            ?>
                                        </label>
                                        <input type="text" class="ui-input" name="hostname" id="a_hostname" value="">
                                    </div>
                                    <div class="tw-w-1/2">
                                        <label for="a_servicename" class="ui-label tw-flex tw-flex-row tw-gap-2 tw-items-center tw-mb-0">
                                            <?php
                                            echo _("Servicename");
                                            echo question_tooltip("The servicename related to the hostname that will show up in Nagios.");
                                            ?>
                                        </label>
                                        <input type="text" class="ui-input" name="servicename" id="a_servicename" value="">
                                    </div>
                                </div>
                            </div>
                        <?php if (show_nagios_reactor()) { ?>
                            <div class="method_option reactor_option tw-w-full">
                                <label class="tw-block tw-text-sm tw-font-medium" for="a_reactor_servers"><?php echo _("Reactor Server"); ?></label>
                                <select class="ui-select" id="a_reactor_servers" name="reactor_server" onchange="get_reactor_chains();"></select>
                            </div>
                            <div class="method_option reactor_option tw-w-full">
                                <label class="tw-block tw-text-sm tw-font-medium" for="a_reactor_chains"><?php echo _("Event Chain"); ?></label>
                                <select class="ui-select" id="a_reactor_chains" name="reactor_chains"></select>
                                <div class="form-subheader tw-mt-2">
                                    <div><?php echo _("Alerts will automatically send these context variables"); ?>:</div>
                                    <div><strong>count</strong> - <?php echo _("The total # of events"); ?></div>
                                    <div><strong>status</strong> - <?php echo _("The status (ok, warning, critical)"); ?></div>
                                    <div><strong>output</strong> - <?php echo _("The output from the alert"); ?></div>
                                    <div><strong>lastrun</strong> - <?php echo _("The timestamp of the last run"); ?></div>
                                </div>
                            </div>
                        <?php } ?>
                            <div class="method_option snmp_option tw-w-1/2">
                                <label class="tw-block tw-text-sm tw-font-medium" for="a_snmp_receivers"><?php echo _("Trap Receiver"); ?></label>
                                <select class="ui-select" id="a_snmp_receivers" name="snmp_receiver"></select>
                            </div>
                            <div class="method_option email_option nrdp_option reactor_option snmp_option exec_option not_real_time_option">
                                <div class="tw-flex tw-items-center tw-space-x-2">
                                    <input type="checkbox" id="a_send_wc_only" name="send_wc_only" class="ui-checkbox-group-item" value="1">
                                    <label class="tw-mb-0 ui-label" for="a_send_wc_only">
                                        <?php echo _("Only alert when Warning or Critical threshold is met."); ?>
                                    </label>
                                </div>
                            </div>
                        <?php if (user_has_permission('alerts', array('all'))) { ?>
                            <div class="tw-flex tw-items-center tw-space-x-2">
                                <input type="checkbox" id="a_take_ownership" name="take_ownership" class="ui-checkbox-group-item">
                                <label class="ui-label tw-flex tw-flex-row tw-gap-2 tw-items-center tw-mb-0" for="a_take_ownership">
                                    <?php
                                    echo _('Take Ownership');
                                    echo question_tooltip("Change the 'Created By' to yourself. This prevents the original user from editing the alert unless they are an administrator.");
                                    ?>
                                </label>
                            </div>
                        <?php } /* user_has_permissions('alerts', array('all')) */ ?>
                            <div id="toggle-query-editor-btn" class="tw-w-fit">
                                <a id="toggle-query-editor" class="tw-flex tw-items-center">
                                    <?php echo _('Advanced (Manage Query)'); ?>
                                    <i class="material-symbols-outlined tw-transition tw-text-foreground">keyboard_arrow_down</i>
                                </a>
                            </div>
                            <div class="alert_option host_freshness_option hide">
                                <div class="form-subheader"><?php echo _('Host Freshness alerts run once per hour.'); ?></div>
                            </div>
                        </div>
                        <div id="query-editor" class="tw-mt-4">
                            <div class="tw-flex tw-flex-row tw-gap-2 tw-w-fit">
                                <select id="l_queries" class="ui-select" name="lqueries"></select>
                                <button id="load-query" class="ui-btn ui-btn-secondary"><?php echo _('Load'); ?></button>
                            </div>
                            <textarea id="query-text" class="tw-my-4 tw-w-full" name="query"></textarea>
                            <p class="form-subheader"><?php echo _('The <b>range</b> filter for @timestamp is required. Do not edit it. Timestamp to and from values will be automatically updated to the proper values when the alert runs.'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="ui-btn ui-btn-default tw-mr-1" <?php if (is_demo_mode()) { echo 'disabled'; } ?> id="create-alert-btn"><?php echo _("Create Alert"); ?></button>
                <button type="button" class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _("Cancel"); ?></button>
            </div>
        </div>
    </div>
</div>

<div id="remove-confirm-modal" class="modal hide fade" data-backdrop="static" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header"><?php echo _("Apply Configuration?"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body delete-modal-on-close">
                <?php echo _("This action requires a change to the Logstash configuration. Would you like to apply configuration immediately, or continue making changes?");?>
                <?php if (is_demo_mode()) { ?>
                <div class="alert alert-error">
                    <?php echo _("This function is not available in demo mode."); ?>
                </div>
                <?php } ?>
            </div>
            <div class="modal-footer">
                <button type="button" id="remove-apply-now" class="ui-btn ui-btn-default tw-mr-1" <?php if (!$config_edit_allowed) { echo 'disabled'; } ?>><?php echo ($config_edit_allowed ? _('Apply Configuration Now') : _('You Cannot Apply Configuration')); ?></button>
                <button type="button" id="remove-apply-later" class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _("Apply Later"); ?></button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
CURRENT_ACTION = '';
reload = true;

var last_paradigm = '';
var last_method = '';
var CONFIG_EDIT_ALLOWED = <?php echo $config_edit_allowed ? 'true' : 'false'; ?>;

var USER_ID = '<?php echo $user_id; ?>'

setTimeout(function(){
    if(reload == true){
        location.reload();
    }
}, 30000);
    
$(document).ready(function() {
    
    load_all_queries();

    function rebind_and_show_apply_modal(event) {

        event.preventDefault();

        url = this.href;
        
        $('#remove-apply-now').off('click');
        $('#remove-apply-now').click(function() {
            window.location.href = url + '&apply_now=true';
        });

        $('#remove-apply-later').off('click');
        $('#remove-apply-later').click(function() {
            window.location.href = url;
        });


        $('#remove-confirm-modal').modal('show');
    }


    $('.real-time-remove').click(rebind_and_show_apply_modal);
    $('.real-time-activate').click(rebind_and_show_apply_modal);

    $('.close').click(function() {
        reload = true;
    });
    
    $('#load-query').click(function() {
        var qid = $('#l_queries').val();

        // Grab the query and write it out in slightly nicer JSON format without slashes
        $.get(site_url + 'api/system/get_query_partial', { id: qid }, function(data) { 
            $('#query-text').val(JSON.stringify(data, null, 4));
        }, 'json');
    });

    $('#toggle-query-editor').click(function() {
        if ($('#query-editor').is(":visible")) {
            $('#query-editor').hide();
            $(this).parent().find('.material-symbols-outlined').removeClass('tw-rotate-180');
        } else {
            $('#query-editor').show();
            $(this).parent().find('.material-symbols-outlined').addClass('tw-rotate-180');
        }
    });

    $('#select-paradigm').change(function() {
        do_paradigm_options($(this).val());
    });

    criteria_change = function() {
        var first_time = false;
        if ($(this).val !== '') {
            var elem = $(this).children().filter('[value=""]');
            if (elem.length) {
                first_time = true;
            }
            elem.remove();
        }

        var iteration = parseInt($(this).data('iter'));
        var first_row = iteration * 2 + 1;
        var second_row = iteration * 2 + 2;
        var next_iteration = iteration + 1;
        var elements = '<div class="tw-flex tw-flex-row tw-gap-2 tw-mb-2">';
        elements += '<input type="text" class="criteria_field ui-input" placeholder="<?php echo _('Field');?>" name="criteria_fields[]">';
        elements += '<select class="criteria_comparator ui-select" name="criteria_comparators[]"><option value="==">==</option><option value="!=">!=</option><option value=">">></option><option value=">=">>=</option><option value="<"><</option><option value="<="><=</option><option value="=~">=~</option><option value="!~">!~</option><option value="in">in</option><option value="not in">not in</option></select>';
        elements += '<input type="text" class="criteria_value ui-input" placeholder="<?php echo _('Value');?>" name="criteria_values[]">';
        elements += '<select class="criteria_boolean ui-select" data-iter="'+next_iteration+'" name="criteria_booleans[]"><option value=""></option><option value="and">and</option><option value="or">or</option></select>';
        elements += '</div>';

        if (first_time) {
            $('#a_criteria').append(elements);
        }
   
        $('#a_criteria .criteria_boolean').off('change');
        $('#a_criteria .criteria_boolean').on('change', criteria_change);
    }

    function edit_alert() {
        reload = false;
        CURRENT_ACTION = 'edit';
        var aid = $(this).data('aid');
        $('#alert-modal .form-header').html('<?php echo _("Edit an Alert"); ?>');
        $('#create-alert-btn').html('<?php echo _("Save Changes"); ?>');
        $('#alert-message').html('');
        $('#create-alert-message').hide();

        // Grab the alert and then show the modal (filled in)
        $.get(site_url+'api/check/get_alert', { id: aid }, function(alert) {

            if (!alert.hasOwnProperty('alert_type')) {
                alert.alert_type = 'query';
            }
            do_paradigm_options(alert.alert_type);

            $('#query-editor').hide();
            $('#toggle-query-editor').parent().find('.fa').removeClass('fa-chevron-down').removeClass('fa-chevron-up').addClass('fa-chevron-up');
            if (alert.alert_type === 'query') {
                $('#toggle-query-editor-btn').show();
            }
            else {
                $('#toggle-query-editor-btn').hide();
            }
            if (alert.alert_type === 'real_time') {
                clear_criteria();
                do_criteria(alert.criteria_fields, alert.criteria_comparators, alert.criteria_values, alert.boolean_ops);
            }

            $('#a_id').val(aid);

            // Fill in the modal
            $('#a_name').val(alert.name);
            $('#select-paradigm').val(alert.alert_type);
            $('.choose_paradigm').hide();
            $('#queries-box').hide();
            $('#a_ci').val(alert.check_interval);
            $('#a_lp').val(alert.lookback_period);
            $('#a_w').val(alert.warning);
            $('#a_min_gap').val(alert.min_gap);
            $('#a_c').val(alert.critical);
            $('#a_hosts').val(alert.hosts);
            if (!alert.hasOwnProperty('save_apply')) {
                alert.save_apply = true;
            }
            $('#a_do_save_apply').prop('checked', alert.save_apply);
            if (!CONFIG_EDIT_ALLOWED) {
                $('#a_do_save_apply').prop('checked', false);
                $('#a_do_save_apply').attr('disabled', true);
            }
            $('#a_take_ownership').prop('checked', false);

            var q = '';
            if (alert.hasOwnProperty('query')) {
                try {
                    q = JSON.parse(alert.query);
                }
                catch (e) {
                    q = {};
                }
                $('#query-editor textarea').val(JSON.stringify(q, null, 4));
            }

            // Set notification method
            $('#a_type').val(alert.method.type);
            do_method_options(alert.method.type, alert.method);
            if (alert.alert_crit_only) {
                $('#a_send_wc_only').prop('checked', true);
            } else {
                $('#a_send_wc_only').prop('checked', false);
            }
            $('#alert-modal').modal('show');
        }, 'json');
    }

    $('#alert-list').on('click', '.edit', edit_alert);
    $('#real-time-alert-list').on('click', '.edit', edit_alert);
    $('#host-freshness-alert-list').on('click', '.edit', edit_alert);

    $('#create-alert').click(function() {
        reload = false;
        CURRENT_ACTION = 'add';
        $('#alert-message').html('');
        $('#create-alert-message').hide();
        $('.choose_paradigm').show();
        $('#query-editor').hide();
        $('#toggle-query-editor-btn').hide();
        $('#alert-modal .form-header').html('<?php echo _("Create an Alert"); ?>');
        $('#create-alert-btn').html('<?php echo _("Create Alert"); ?>');

        // Undo anything set by edit button.
        $('#select-paradigm').val('query');
        $('#a_id').val('');
        $('#a_name').val('');
        $('#queries-box').show();
        $('#a_ci').val('');
        $('#a_lp').val('');
        $('#a_min_gap').val('1');
        $('#a_w').val('');
        $('#a_c').val('');
        $('#a_hosts').val('0.0.0.0/0');
        $('#a_do_save_apply').prop('checked', true);
        if (!CONFIG_EDIT_ALLOWED) {
            $('#a_do_save_apply').prop('checked', false);
            $('#a_do_save_apply').attr('disabled', true);
        }

        $('#query-editor textarea').val('');

        // Set notification method
        $('#a_type').val('');
        do_paradigm_options('query');
        do_method_options('', '');
        clear_criteria();

        $('#a_send_wc_only').prop('checked', false);

        $('#alert-modal').modal('show');
    });

    $('#create-alert-btn').click(function() {
        reload = false;
        var aco = 0;
        if ($('#a_send_wc_only').is(":checked")) {
            aco = 1;
        }

        var take_ownership = 0;
        if ($('#a_take_ownership').is(':checked')) {
            take_ownership = 1;
        }

        var check = {
            name: $('#a_name').val(),
            method: { type: $('#a_type').val() },
            take_ownership: take_ownership,
            created_by: LS_USERNAME
        };

        check.alert_type = $('#select-paradigm').val();
        switch (check.alert_type) {
            case 'real_time':
                check = create_real_time_alert(check);
                break;
            case 'host_freshness':
                check = create_host_freshness_alert(check);
                break;
            default:
            case 'query':
                check = create_query_based_alert(check);
                break;
        }

        check = create_method_info(check);

        if (check.message) {
            $('#alert-message').html(check.message);
            $('#create-alert-message').addClass('alert-danger').show();
            return;
        }

        // Send the new check to the API
        var url = site_url+'api/check/create/1';
        if (CURRENT_ACTION == 'edit') {
            if (!validate_interval_string(check.check_interval) || !validate_interval_string(check.lookback_period)) {
                check.message = '<?php echo _("You must enter a valid Check Interval and Lookback Period (valid suffixes include: s, m, h, d), w, m, and y."); ?>';
                return check;
            }
            if (!validate_threshold_string(check.warning) || !validate_threshold_string(check.critical)) {
                check.message = '<?php echo _("You must enter a valid Threshold."); ?>';
                return check;
            }

            url = site_url+'api/check/update';
            check.id = $('#a_id').val();
        }

        $.post(url, { alert: JSON.stringify(check) }, function(data) { return; }).always(function(data) {

            if (data.hasOwnProperty('responseJSON') && data.responseJSON.hasOwnProperty('output') && data.responseJSON.output) {
                $('#alert-message').html(data.responseJSON.output);
                $('#create-alert-message').addClass('alert-danger').show();
                return;
            }

            if (check.alert_type === 'real_time' && $('#a_do_save_apply').is(":checked")) {
                window.location.href = site_url+'configure/apply_to_instances';
            }
            else {
                $('#alert-modal').modal('hide');
                clear_alert_modal();
                window.location.reload();
            }
        });
    });
});

function string_is_positive_integer(str) {
    return /^\+?(0|[1-9]\d*)$/.test(str);
}

function create_real_time_alert(check) {

    if (check.name == '') {
        check.message = '<?php echo _("You must fill out all of the fields."); ?>';
    }

    check.min_gap = $('#a_min_gap').val();

    if (!string_is_positive_integer(check.min_gap)) {
        check.message = '<?php echo _("Rate Limit must be an integer >= 0");?>';
    }

    check.alert_type = 'real_time';

    check.criteria_fields = [];
    $('#a_criteria .criteria_field').each(function () {
        check.criteria_fields.push($(this).val());
    });

    check.criteria_comparators = [];
    $('#a_criteria .criteria_comparator').each(function () {
        check.criteria_comparators.push($(this).val());
    });

    check.criteria_values = [];
    $('#a_criteria .criteria_value').each(function () {
        check.criteria_values.push($(this).val());
    });

    check.boolean_ops = [];
    $('#a_criteria .criteria_boolean').each(function () {
        check.boolean_ops.push($(this).val());
    });

    check.save_apply = $('#a_do_save_apply').is(":checked");

    /**
     * There isn't a good way to validate these, since logstash can check for empty strings,
     * and some entries can be left blank.
     * So we're just checking that there aren't any 'gaps' in the list of fields.
     */

    var reached_empty_space = false;
    for (var i = 0; i < check.criteria_fields.length; i++) {
        if (check.criteria_fields[i] === '') {

            if (i === 0) {
                check.message = '<?php echo _("You must fill out all of the fields."); ?>';
            }

            check.criteria_fields.splice(i,1);
            check.criteria_comparators.splice(i,1);
            check.criteria_values.splice(i,1);
            check.boolean_ops.splice(i,1);
        }
    }

    return check;
}

function create_host_freshness_alert(check) {
    check.warning = $('#a_w').val();
    check.critical = $('#a_c').val();
    check.hosts = $('#a_hosts').val();

    var aco = 0;
    if ($('#a_send_wc_only').is(":checked")) {
        aco = 1;
    }

    check.alert_crit_only = aco;

    // validation
    if (check.name == '' || check.warning == '' || check.critical == '') {
        check.message = '<?php echo _("You must fill out all of the fields."); ?>';
    }

    return check;
}

function validate_interval_string(interval) {
    return /^\d+[smhdwy]$/.test(interval);
}

function validate_threshold_string(threshold) {
    return /^\d+$/.test(threshold);
}

function create_query_based_alert(check) {
    var aco = 0;
    if ($('#a_send_wc_only').is(":checked")) {
        aco = 1;
    }

    check.check_interval = $('#a_ci').val();
    check.lookback_period = $('#a_lp').val();
    check.warning = $('#a_w').val();
    check.critical = $('#a_c').val();
    check.alert_crit_only = aco;
    check.alert_type = 'query';

    // validation
    if (check.name == '' || check.warning == '' || check.critical == '') {
        check.message = '<?php echo _("You must fill out all of the fields."); ?>';
    }

    // Verify interval and loopback period
    if (!validate_interval_string(check.check_interval) || !validate_interval_string(check.lookback_period)) {
        check.message = '<?php echo _("You must enter a valid Check Interval and Lookback Period (valid suffixes include: s, m, h, d, w, and y.)"); ?>';
        return check;
    }
    if (!validate_threshold_string(check.warning) || !validate_threshold_string(check.critical)) {
        check.message = '<?php echo _("You must enter a valid Threshold."); ?>';
        return check;
    }

    //vars get hoisted
    var qid;
    if (CURRENT_ACTION != 'edit') {
        qid = $('#a_queries').val();
        if (qid == '' || qid == undefined) {
            check.message = '<?php echo _("You must fill out all of the fields."); ?>';
            return check;
        }
        check.query_id = qid;
    }
    else {
        qid = $('#l_queries').val();
        if (!(qid == '' || qid == undefined)) {
            check.query_id = qid;
        }
        // Add query to the arguments
        check.query = $('#query-text').val();
        try {
            JSON.parse(check.query);
        }
        catch (err) {
            check.message = '<?php echo _("Advanced Query is not valid JSON."); ?>';
            return check;
        }
    }

    return check;
}


function create_method_info(check) {
    // Add more to the alert based on type...
    switch (check.method.type) {
        case 'nrdp':
            check.method.hostname = $('#a_hostname').val();
            check.method.servicename = $('#a_servicename').val();
            check.method.server_id = $('#a_nrdp_servers').val();
            break;
        case 'email':
            var user_ids = [];
            $('#select_users option:selected').each(function(i, opt) {
                user_ids.push($(opt).val());
            });
            check.method.user_ids = user_ids;
            check.method.tpl_id = $('#templates').val();
            check.method.include_self = $('#checkbox_self').is(":checked") ? $('#checkbox_self').val() : 0;
            break;
        case 'exec':
            check.method.path = $('#a_script').val();
            check.method.args = $('#a_args').val();
            break;
        case 'snmp':
            check.method.snmp_receiver = $('#a_snmp_receivers').val();
            break;
        case 'reactor':
            check.method.reactor_server_id = $('#a_reactor_servers').val();
            check.method.chain_id = $('#a_reactor_chains').val();
            check.method.chain_name = $('#a_reactor_chains').text();
            break;
    }
    return check;
}

function load_all_queries(id) {
    var html = '';
    var cachebuster = Date.now(); 
    $.get(site_url+'api/check/get_queries', { cb: cachebuster }, function(data) {
        $.each(data, function(k, v) {
            html += '<option value="'+v.id+'">'+v.name+'</option>';
            $('#a_queries').html(html);
            $('#l_queries').html('<option></option>'+html);
        });
    }, 'json');
}

function do_paradigm_options(paradigm) {

    if (paradigm === "host_freshness") {
        if (!$('#a_w').val()) {
            $('#a_w').val('0');
        }
        if (!$('#a_c').val()) {
            $('#a_c').val('0');
        }
    }

    $('.alert_option.'+paradigm+'_option').show();
    $('.alert_option:not(.'+paradigm+'_option)').hide();
    $('.method_option.'+last_method+'_option').show();
    $('.method_option.not_'+paradigm+'_option').hide();
    last_paradigm = paradigm;

}

function show_method_options(select) {
    var method = $(select).val();
    do_method_options(method, '');
}

function do_criteria(fields, comparators, values, booleans) {
    var x;
    for (x = 0; x < Math.max(booleans.length, fields.length-1); x++) {

        if (booleans[x] === '') {
            continue;
        }

        // Need to call a new selector each time, since the nth 
        // form field doesn't exist until n-1th has value inserted.
        var current_field = $('#a_criteria .criteria_boolean').eq(x);
        current_field.val(booleans[x]);
        current_field.change();
    }

    field_elements = $('#a_criteria .criteria_field');
    comparator_elements = $('#a_criteria .criteria_comparator');
    value_elements = $('#a_criteria .criteria_value');
    boolean_elements = $('#a_criteria .criteria_boolean');

    for (x = 0; x < fields.length; x++) {
        field_elements.eq(x).val(fields[x]);
        comparator_elements.eq(x).val(comparators[x]);
        value_elements.eq(x).val(values[x]);
    }
}

function do_method_options(method, values) {
    clear_method_options();
    switch (method)
    {
        case "email":
            if (values == '') {
                $('#a_send_wc_only').prop('checked', true);
            }
            $.post(site_url+'api/user/get_all_users', { form_encode: true }, function(data) {
                html = '';
                $.each(data, function(k, user) {
                    var name = '';
                    if (user.name != '' && user.name != undefined) { name = ' ('+user.name+')'; }
                    var selected = '';
                    var check_include_self = false;
                    if (values != '') {
                        $.each(values.user_ids, function(k, v) {
                            if (v == user.id) { selected = ' selected'; }
                            if (v == USER_ID) { check_include_self = true; }
                        });
                    }
                    html += '<option value="'+user.id+'"'+selected+'>'+user.username+name+'</option>';
                    $('#checkbox_self').prop('checked', check_include_self);
                });
                $('#select_users').html(html);
            }, 'json');
            $.get('<?php echo site_url("api/check/get_templates"); ?>', { }, function(data) {
                $('#templates').html('<option value="system"><?php echo _("System Default"); ?></option>');
                $(data).each(function(k, v) {
                    var sel = '';
                    if (values != '') {
                        if (v._id == values.tpl_id) { sel = 'selected'; }
                    }
                    $('#templates').append('<option value="'+v._id+'" '+sel+'>'+v._source.name+'</option>');
                });
            });
            break;

        case "nrdp":
            // Check for NRDP server configurations
            $.get(site_url+'api/check/get_nrdp', {}, function(data) {
                html = '';
                $.each(data, function(k, v) {
                    html += '<option value="'+v._id+'">'+v._source.name+'</option>';
                });
                $('#a_nrdp_servers').html(html);
                if (values != '') {
                    $('#a_nrdp_servers').val(values.server_id);
                }
                $('#a_hostname').val(values.hostname);
                $('#a_servicename').val(values.servicename);
            }, 'json');
            break;

        case 'reactor':
            // Check for Reactor servers
            $.get(site_url+'api/check/get_reactor', {}, function(data) {
                html = '';
                $.each(data, function(k, v) {
                    html += '<option value="'+v._id+'" data-server="'+v._source.address+'" data-apikey="'+v._source.apikey+'">'+v._source.name+'</option>';
                });
                $('#a_reactor_servers').html(html);
                if (values != '') {
                    $('#a_reactor_servers').val(values.reactor_id);
                }
                get_reactor_chains();
            }, 'json');
            break;

        case "snmp":
            // Check for SNMP trap receivers
            $.get(site_url+'api/check/get_snmp_receivers', {}, function(data) {
                html = '';
                $.each(data, function(k, v) {
                    html += '<option value="'+v._id+'">'+v._source.name+'</option>';
                });
                $('#a_snmp_receivers').html(html);
                if (values != '') {
                    $('#a_snmp_receivers').val(values.snmp_receiver);
                }
            }, 'json');
            break;

        case "exec":
            if (values != '') {
                $('#a_script').val(values.path);
                $('#a_args').val(values.args);
            }
            break;

        default:
            break;
    }
    $('.method_option.'+method+'_option').show();
    $('.method_option.not_'+last_paradigm+'_option').hide();
    last_method = method;
}

function get_reactor_chains() {
    var server = $('#a_reactor_servers option:selected').data('server');
    var apikey = $('#a_reactor_servers option:selected').data('apikey');
    $('#a_reactor_chains').html('');
    $.get(server+'eventchain', { api_key: apikey }, function(data) {
        var html = '';
        $(data).find('chains chain').each(function(k, v) {
            html += '<option value="' + $(v).attr('id') + '">' + $(v).find('name').text() + '</option>';
        });
        $('#a_reactor_chains').html(html);
    });
}

function clear_method_options() {
    $('.method_option').hide();
    $('#a_send_wc_only').attr('checked', false);
}

function clear_paradigm_options() {
    $('.real_time_option').hide();
    $('.query_option').show();
    $('#query_paradigm').prop('checked', true);
}

function clear_criteria() {
    $('#a_criteria').html($('#criteria_interior').html());
    $('#a_criteria .criteria_boolean').off('change');
    $('#a_criteria .criteria_boolean').on('change', criteria_change);
}

function clear_alert_modal() {
    $('#a_type').val('');
    $('#select-paradigm').val('query');
    clear_method_options();
    clear_paradigm_options();
    clear_criteria();
    $('#a_name').val('');
    $('#queries-box').show();
    $('#a_ci').val('5m');
    $('#a_lp').val('5m');
    $('#a_min_gap').val('1');
    $('#a_w').val('');
    $('#a_c').val('');
    $('#a_do_save_apply').prop('checked', true);
    $('#a_take_ownership').prop('checked', false);
}
</script>

<?php echo $footer; ?>