<?php echo $header; ?>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="form-container">
    
        <div class="form-title"><?php echo _("Nagios / NRDP"); ?></div>
        <div class="form-subtitle"><?php echo _("You can set up NRDP Servers to send passive checks to. NRDP is available for both Nagios XI (installed by default) and Nagios Core. You will have to set up the host and service in your config files on the Nagios Server if you use this alerting method or the passive checks will not show up."); ?></div>
        <div class="form-spacer"></div>
        <div class="tw-flex tw-justify-between tw-items-center tw-mb-4">
            <div class="form-header"><?php echo _("Host and Service Configurations"); ?></div>
            <button class="ui-btn ui-btn-outlined tw-float-right" id="add-nrdp">
                <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                    <i class="material-symbols-outlined">add</i>
                    <?php echo _("Add NRDP Server"); ?>
                </div>
            </button>
        </div>
        <div class="tw-flex tw-flex-wrap tw-gap-4">
            <div class="tw-flex-auto">
                <table class="ui-table">
                    <thead class="ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th"><?php echo _("Alert Name"); ?></th>
                            <th class="ui-th"><?php echo _("Host"); ?></th>
                            <th class="ui-th"><?php echo _("Service"); ?></th>
                            <th class="ui-th"><?php echo _("Server Name"); ?></th>
                        </tr>
                    </thead>
                    <tbody class="ui-tbody" id="nrdp-link-list">
                    <?php 
                        if (count($alerts) > 0) {
                            foreach ($alerts as $alert) { ?>
                            <tr class="ui-tr">
                                <td class="ui-td"><?php echo $alert['name']; ?></td>
                                <td class="ui-td"><?php echo $alert['method']['hostname']; ?></td>
                                <td class="ui-td"><?php echo $alert['method']['servicename']; ?></td>
                                <td class="ui-td"><?php echo $alert['method']['server_name']; ?></td>
                            </tr>
                        <?php } ?>
                    <?php } else { ?>
                        <tr class="ui-tr"><td class="ui-td" colspan="9"><?php echo _("There are no alerts linked to any NRDP servers."); ?></td></tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>
            <div class="tw-flex-auto">
                <table class="ui-table">
                    <thead class="ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th"><?php echo _("Server Name"); ?></th>
                            <th class="ui-th"><?php echo _("NRDP Address"); ?></th>
                            <th class="ui-th"><?php echo _("NRDP Token"); ?></th>
                            <th class="ui-th"></th>
                        </tr>
                    </thead>
                    <tbody class="ui-tbody" id="nrdp-list">
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Manage a NRDP Server -->
<div class="modal hide fade" id="manage-nrdp" tabindex="-1" role="dialog">
    <div class="modal-dialog tw-w-fit" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header"><span class="nrdp-action-type"><?php echo _("Add"); ?></span> <?php echo _("NRDP Server"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div class="form-subheader"><?php echo _("Works with both Nagios XI and Nagios Core. Just enter the NRDP address and token."); ?></div>
                <div id="manage-nrdp-alerts"></div>
                <div class="tw-grid tw-gap-4 tw-pt-8">
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                        <label class="tw-text-right tw-font-medium" for="name"><?php echo _('Name'); ?></label>
                        <input class="ui-input tw-col-span-2" type="text" name="name" id="name"/>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                        <label class="tw-text-right tw-font-medium" for="address"><?php echo _('NRDP Address'); ?></label>
                        <input class="ui-input tw-col-span-2" type="text" name="address" id="address" placeholder="http://192.168.1.150/nrdp/"/>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                        <label class="tw-text-right tw-font-medium" for="token"><?php echo _('NRDP Token'); ?></label>
                        <input class="ui-input tw-col-span-2" type="text" name="token" id="token" placeholder="mysecret"/>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                        <label for="allow-self-signed" class="ui-label tw-text-right tw-font-medium"><?php echo _("Allow Self-signed SSL Cert"); ?></label>
                        <input type="checkbox" id="allow-self-signed" name="allow-self-signed" class="ui-checkbox-group-item tw-col-span-2">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="ui-btn ui-btn-default nrdp-action-type tw-mr-1" id="manage-nrdp-button" data-loading-text="<?php echo _("Connecting"); ?>..."><?php echo _("Add"); ?></button>
                <a href="#" class="ui-btn ui-btn-outlined" data-dismiss="modal"><?php echo _("Close"); ?></a>
            </div>
        </div>
    </div>
</div>

<script>
var CURRENT_ACTION = 'add';
var CURRENT_EDIT_ID = '';

$(document).ready(function() {

    load_nrdp_servers();

    $('#add-nrdp').click(function() {
        CURRENT_ACTION = "add";
        clear_nrdp_modal('add');
        $('#manage-nrdp').modal('show');
    });

    $('#manage-nrdp-button').click(function() {
        if ($('#name').val() == '' || $('#address').val() == '' || $('#token').val() == '') {
            // Display error
            $('#manage-nrdp-alerts').html('<div class="alert alert-error"><?php echo _("You must fill out all the fields."); ?></div>');
            return;
        }
        $(this).button('loading');

        var addr = $('#address').val();
        if (addr.charAt(addr.length-1) != "/") { addr += '/'; }

        var data = { name: $('#name').val(),
                     address: addr,
                     token: $('#token').val(),
                     allow_self_sign: $('#allow-self-signed').is(":checked"),
                     action: CURRENT_ACTION }

        // For editing only
        if (CURRENT_ACTION == "edit") {
            data['id'] = CURRENT_EDIT_ID;
        }

        $.post('<?php echo site_url("api/check/nrdp"); ?>', data, function(result) {
            $('#manage-nrdp-button').button('reset');
            if (result.status == "success") {
                $('#manage-nrdp').modal('hide');
                load_nrdp_servers();
            } else {
                $('#manage-nrdp-alerts').html('<div class="alert alert-error">'+result.msg+'</div>');
            }
        }, 'json');
    });

    $('#nrdp-list').on('click', '.delete', function() {
        var id = $(this).parents('td').data('id');
        $.post('<?php echo site_url("api/check/nrdp"); ?>', { id: id, action: 'delete' }, function(result) {
            load_nrdp_servers();
        });
    });

    $('#nrdp-list').on('click', '.edit', function() {
        CURRENT_EDIT_ID = $(this).parents('td').data('id');
        CURRENT_ACTION = "edit";
        clear_nrdp_modal('edit');
        $('#manage-nrdp').modal('show');
        $('#name').val($(this).parents('tr').find('.name').text());
        $('#address').val($(this).parents('tr').find('.address').text());
        $('#token').val($(this).parents('tr').find('.token').text());
    });

});

function load_nrdp_servers()
{
    $.get('<?php echo site_url("api/check/get_nrdp"); ?>', { }, function(data) {
        html = '';
        if (data.length == 0) {
            html = '<tr class="ui-tr"><td class="ui-td" colspan="9"><?php echo _("No Nagios Servers have been created."); ?></td></tr>';
        } else {
            $.each(data, function(k, v) {
                var actions = `
                    <dropdown-menu data-position="bottom">
                        <dropdown-trigger>
                            <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                        </dropdown-trigger>
                        <dropdown-content class="ui-dropdown-content">
                            <a class="edit">
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Edit"); ?>
                                </dropdown-item>
                            </a>
                            <a class="delete">
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Remove"); ?>
                                </dropdown-item>
                            </a>
                        </dropdown-content>
                    </dropdown-menu>`;
                html += `
                    <tr class="ui-tr">
                        <td class="ui-td name">`+v._source.name+`</td>
                        <td class="ui-td address">`+v._source.address+`</td>
                        <td class="ui-td token">`+v._source.token+`</td>
                        <td class="ui-td actions" data-id="`+v._id+`">`+actions+`</td>
                    </tr>`;
            });
        }
        $('#nrdp-list').html(html);
    });
}

function clear_nrdp_modal(type)
{
    $('#manage-nrdp input').val('');
    $('#manage-nrdp-alerts').html('');
    if (type == 'add') {
        $('.nrdp-action-type').html('<?php echo _("Add"); ?>');
    } else {
        $('.nrdp-action-type').html('<?php echo _("Save"); ?>');
    }
}
</script>

<?php echo $footer; ?>