<?php echo $header; ?>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="form-container">
        <div class="form-title"><?php echo _("SNMP Trap Receivers"); ?></div>
        <div class="form-subtitle"><?php echo _("As an alternative to sending passive checks via NRDP you can also send SNMP traps to a SNMP trap receiver which could also include your Nagios server."); ?></div>
        <div class="form-spacer"></div>
        <button class="ui-btn ui-btn-outlined tw-mt-2 tw-mb-6" id="add-snmp">
            <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                <i class="material-symbols-outlined">add</i>
                <?php echo _("Add SNMP Trap Receiver"); ?>
            </div>
        </button>
        <table class="ui-table">
            <thead class="ui-thead">
                <tr class="ui-tr">
                    <th class="ui-th"><?php echo _("SNMP Receiver Name"); ?></th>
                    <th class="ui-th"><?php echo _("Address (IP:Port)"); ?></th>
                    <th class="ui-th"><?php echo _("SNMP Version"); ?></th>
                    <th class="ui-th"></th>
                </tr>
            </thead>
            <tbody class="ui-tbody" id="snmp-list">
            </tbody>
        </table>
    </div>
</div>

<!-- Manage a SNMP Trap Receiver -->
<div class="modal hide fade" id="manage-snmp" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header"><span class="snmp-action-type"><?php echo _("Add"); ?></span> <?php echo _("SNMP Trap Receiver"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div class="form-subheader tw-mb-4"><?php echo _("Add a SNMP Trap Receiver to send SNMP Traps to the receiving server on alert."); ?></div>
                <div id="manage-snmp-alerts"></div>
                <div class="tw-grid tw-gap-4 tw-pt-8">
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                        <label class="tw-text-right tw-font-medium" for="name"><?php echo _('Name'); ?></label>
                        <input class="ui-input tw-col-span-2" type="text" name="name" id="name"/>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                        <label class="tw-text-right tw-font-medium" for="address"><?php echo _("Receiver Address"); ?></label>
                        <div class="tw-flex tw-items-center tw-col-span-2 tw-gap-[calc(1rem/3)]">
                            <input class="ui-input" type="text" name="address" id="address" placeholder="192.168.1.150"/>
                            :
                            <input type="text" name="port" id="port" class="ui-input" placeholder="162">
                        </div>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                        <label class="tw-text-right tw-font-medium" for="version"><?php echo _("SNMP Version"); ?></label>
                        <select name="version" class="ui-select" id="version">
                            <option value="2">2c</option>
                            <option value="3">3</option>
                        </select>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 version-2">
                        <label class="tw-text-right tw-font-medium" for="community"><?php echo _("Community String"); ?></label>
                        <input class="ui-input tw-col-span-2" type="text" name="community" id="community"/>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 version-3 hide">
                        <label class="tw-text-right tw-font-medium" for="username"><?php echo _("Username"); ?></label>
                        <input class="ui-input tw-col-span-2" type="text" name="username" id="username"/>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 version-3 hide">
                        <label class="tw-text-right tw-font-medium" for="engineid"><?php echo _("engineID"); ?></label>
                        <input class="ui-input tw-col-span-2" type="text" name="engineid" id="engineid"/>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 version-3 hide">
                        <label class="tw-text-right tw-font-medium" for="auth_level"><?php echo _("Authorization Level"); ?></label>
                        <select name="auth_level" class="ui-select" id="auth_level">
                            <option value="authPriv">authPriv</option>
                            <option value="authNoPriv">authNoPriv</option>
                            <option value="noAuthnoPriv">noAuthnoPriv</option>
                        </select>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 version-3 auth hide">
                        <label class="tw-text-right tw-font-medium" for="auth_password"><?php echo _("Authorization Password"); ?></label>
                        <input type="text" class="ui-input" name="auth_password" id="auth_password">
                        <select name="auth_protocol" class="ui-select" id="auth_protocol">
                            <option value="SHA">SHA</option>
                            <option value="MD5">MD5</option>
                        </select>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 version-3 priv hide">
                        <label class="tw-text-right tw-font-medium" for="priv_password"><?php echo _("Privacy Password"); ?></label>
                        <input type="text" class="ui-input" name="priv_password" id="priv_password">
                        <select name="priv_protocol" class="ui-select" id="priv_protocol">
                            <option value="AES">AES</option>
                            <option value="DES">DES</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="ui-btn ui-btn-default tw-mr-1 snmp-action-type" id="manage-snmp-button"><?php echo _("Add"); ?></button>
                <a href="#" class="ui-btn ui-btn-outlined" data-dismiss="modal"><?php echo _("Close"); ?></a>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
var CURRENT_ACTION = 'add';
var CURRENT_EDIT_ID = '';

$(document).ready(function() {

    load_snmp_servers();

    $('#add-snmp').click(function() {
        CURRENT_ACTION = "add";
        clear_snmp_modal('add');
        $('#manage-snmp').modal('show');
    });

    $('#version').change(function() {
        if ($(this).val() == "2") {
            $('.version-2').show();
            $('.version-3').hide();
        } else {
            $('.version-3').show();
            $('.version-2').hide();
        }
    });

    $('#auth_level').change(function() {
        var level = $(this).val();
        if (level == 'authPriv') {
            $('.auth').show();
            $('.priv').show();
        } else if (level == 'authNoPriv') {
            $('.auth').show();
            $('.priv').hide();
        } else {
            $('.auth').hide();
            $('.priv').hide();
        }
    });

    $('#manage-snmp-button').click(function() {
        var version = $('#version option:selected').val();

        if ($('#name').val() == '' || $('#address').val() == '' || $('#port').val() == '') {
            // Display error
            $('#manage-snmp-alerts').html('<div class="alert alert-error"><?php echo _("You must fill out all the fields."); ?></div>');
            return;
        }

        var data = { name: $('#name').val(),
                     address: $('#address').val(),
                     port: $('#port').val(),
                     version: version,
                     action: CURRENT_ACTION }

        if (version == '2') {
            data['community'] = $('#community').val();
        } else {
            data['username'] = $('#username').val();
            data['engineid'] = $('#engineid').val();
            data['auth_level'] = $('#auth_level option:selected').val();
            data['auth_password'] = $('#auth_password').val();
            data['auth_protocol'] = $('#auth_protocol option:selected').val();
            data['priv_password'] = $('#priv_password').val();
            data['priv_protocol'] = $('#priv_protocol option:selected').val();
        }

        // For editing only
        if (CURRENT_ACTION == "edit") {
            data['id'] = CURRENT_EDIT_ID;
        }

        $.post('<?php echo site_url("api/check/snmp"); ?>', data, function(result) {
            if (result.status == "success") {
                $('#manage-snmp').modal('hide');
                load_snmp_servers();
            } else {
                $('#manage-snmp-alerts').html('<div class="alert alert-error">'+result.msg+'</div>');
            }
        }, 'json');
    });

    $('#snmp-list').on('click', '.delete', function() {
        var id = $(this).parents('td').data('id');
        $.post('<?php echo site_url("api/check/snmp"); ?>', { id: id, action: 'delete' }, function(result) {
            load_snmp_servers();
        });
    });

    $('#snmp-list').on('click', '.edit', function() {
        CURRENT_EDIT_ID = $(this).parents('td').data('id');
        CURRENT_ACTION = "edit";
        clear_snmp_modal('edit');
        $.get('<?php echo site_url("api/check/get_snmp_receivers"); ?>', { id: CURRENT_EDIT_ID }, function(data) {
            receiver = data._source;
            $('#name').val(receiver.name);
            $('#address').val(receiver.address);
            $('#port').val(receiver.port);
            $('#version').val(receiver.version).trigger('change');
            
            // v3 settings
            if (receiver.version == "3") {
                $('#username').val(receiver.username);
                $('#engineid').val(receiver.engineid);
                $('#auth_level').val(receiver.auth_level).trigger('change');
                $('#auth_password').val(receiver.auth_password);
                $('#auth_protocol').val(receiver.auth_protocol);
                $('#priv_password').val(receiver.priv_password)
                $('#priv_protocol').val(receiver.priv_protocol);
            } else {
                $('#community').val(receiver.community);
            }

            $('#manage-snmp').modal('show');
        }, 'json');
    });

});

function load_snmp_servers()
{
    $.get('<?php echo site_url("api/check/get_snmp_receivers"); ?>', { }, function(data) {
        html = '';
        if (data.length == 0) {
            html = '<tr class="ui-tr"><td class="ui-td" colspan="9"><?php echo _("No SNMP Trap Receivers have been set up."); ?></td></tr>';
        } else {
            $.each(data, function(k, v) {
                var version = v._source.version;
                if (v._source.version == "2") {
                    version = "2c";
                }
                var actions = `
                    <dropdown-menu data-position="bottom">
                        <dropdown-trigger>
                            <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                        </dropdown-trigger>
                        <dropdown-content class="ui-dropdown-content">
                            <a class="edit">
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Edit"); ?>
                                </dropdown-item>
                            </a>
                            <a class="delete">
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Remove"); ?>
                                </dropdown-item>
                            </a>
                        </dropdown-content>
                    </dropdown-menu>`;
                html += `
                    <tr class="ui-tr">
                        <td class="ui-td name">`+v._source.name+`</td>
                        <td class="ui-td">`+v._source.address+`:`+v._source.port+`</td>
                        <td class="ui-td">`+version+`</td>
                        <td class="ui-td actions" data-id="`+v._id+`">`+actions+`</td>
                    </tr>`;
            });
        }
        $('#snmp-list').html(html);
    });
}

function clear_snmp_modal(type)
{
    $('#manage-snmp input').val('');
    $('#manage-snmp-alerts').html('');
    if (type == 'add') {
        $('.snmp-action-type').html('<?php echo _("Add"); ?>');
        $('#version').val('2').trigger('change');
    } else {
        $('.snmp-action-type').html('<?php echo _("Save"); ?>');
    }
}
</script>

<?php echo $footer; ?>