<?php echo $header; ?>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="form-container">
        <h1 class="form-title"><?php echo _("Configuration Editor"); ?></h1>
        <?php if (get_option('configuration_required', 0)) { ?>
        <div class="alert alert-error">
            <?php echo _("<strong>Apply configuration required!</strong> Your configuration in the database does not match the configuration applied."); ?>
        </div>
        <?php } ?>
        <p class="form-subtitle"><?php echo _("The configuration editor is used to write configurations for Logstash running on each of the Log Server instances. The local configurations can be written to Logstash on each of the instances in your cluster. You can also add <strong>global config options</strong> which will be applied to the top of all configuration files on every Log Server instance in the cluster. Global configurations are an easy way to set up the same Logstash configuration on all your instances."); ?></p>
        <div class="form-spacer"></div>
        <?php if (!empty($ports)) { ?>
        <div class="alert alert-info">
            <?php echo _("<strong>Logstash</strong> is currently collecting locally on"); ?>: <strong><?php echo $_SERVER['SERVER_ADDR'] ?></strong> <?php foreach ($ports as $type => $p) { echo '<span style="margin: 0 5px;"><strong>'.$type.": ".implode(', ', $p)."</strong></span>"; } ?>
        </div>
        <?php } ?>     
    </div>
</div>

<?php echo $footer; ?>