<?php echo $header; ?>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="form-container">
        <?php
        $extra = 0;
        if ($node['_id'] == 'global') { ?>
            <div class="form-title tw-flex tw-items-center tw-gap-2">
                <?php echo _("Global Config"); ?>
                <a href="https://www.elastic.co/guide/en/logstash/2.4/configuration.html" target="_blank" class="no-primary tw-flex tw-items-center tw-gap-1 tw-w-fit tw-rounded-md tw-bg-secondary tw-text-sm tw-p-1 tw-ring-foreground hover:tw-no-underline hover:tw-text-inherit active:tw-ring-1 active:tw-outline-none focus:tw-ring-1 focus:tw-outline-none focus:tw-ring focus:tw-no-underline focus:tw-text-inherit">
                    <?php echo _("Docs"); ?>
                    <i class="material-symbols-outlined small">open_in_new</i>
                </a>
                
            </div>
            <p class="form-subtitle"><?php echo _("Manage logstash config options that will be added to all instances. Note that all applied global filters will happen before the local filters. Keep in mind the flow of the log data through the filters when creating global filters."); ?></p>
            <div class="form-spacer"></div>

        <?php } else { ?>
            <h1 class="form-title"><?php echo _("Instance Config"); ?> - <?php echo $node['_source']['address']; if ($node['_source']['hostname'] != $node['_source']['address']) { echo " (".$node['_source']['hostname'].")"; } ?></h1>
            <div class="alert alert-info">
                <?php echo '<strong>' . _("Advanced users only!") . '</strong> ' . _("Making changes here applies to this instance only and changes will be applied to Logstash when the apply configuration is run."); ?>
            </div>
        <?php } ?>

        <?php if (!empty($msg)) { ?>
        <div class="alert alert-<?php echo $msg_type; ?>">
            <?php echo $msg; ?>
            <button type="button" class="close material-symbols-outlined" data-dismiss="alert">close</button>
        </div>
        <?php } ?>

        <?php
        if (array_key_exists('last_updated', $node['_source'])) {
            if ($node['_source']['last_updated'] < time()-300 && $node['_id'] != 'global') {
            // If the instance hasn't been updated in more than 5 minutes show an error page
            ?>
        <div class="alert alert-error alert-offline">
            <div><?php echo _("It looks like this instance hasn't checked in the last 5 minutes."); ?></div>
            <div><?php echo _("Normally this means it is not online or OpenSearch is not running."); ?></div>
            <div class="tw-flex tw-flex-row tw-gap-2 tw-mt-2">
                <button id="prim" class="ui-btn"><?php echo _("I've taken this instance offline permanently"); ?></button>
                <button id="dk" class="ui-btn"><?php echo _("I don't know why it's not online"); ?></button>
            </div>
            <div id="permanent" class="hide">
                <div class="tw-mt-2"><?php echo _("If you have taken this instance offline permanently"); ?>:</div>
                <div class="tw-mt-2">
                    <a href="<?php echo site_url("configure/remove_instance/".$node['_id']); ?>" class="ui-btn hover:tw-text-inherit">
                        <?php echo _("Remove Instance from Database"); ?>
                    </a>
                </div>
            </div>
            <div id="dont-know" class="hide">
                <div class="tw-mt-2"><?php echo _("If you don't know why it's offline, try these"); ?>:</div>
                <ul>
                    <li><?php echo _("Verify that OpenSearch is running on the instance and start OpenSearch if necessary"); ?></li>
                    <li><?php echo _("Check the connection (firewall, cable link) to the instance from this instance"); ?></li>
                    <li><?php echo _("Wait for the instance to return to an online state and check in"); ?></li>
                </ul>
            </div>
        </div>
        <?php
            }
        }
        ?>

        <?php
        if (array_key_exists('logstash', $node['_source'])) {
            if ($node['_source']['logstash']['status'] == 'stopped') { ?>
            <div class="alert alert-error">
                <?php echo _("The instance reports that it's local"); ?> <strong><?php echo _("Logstash"); ?></strong> <?php echo _("is not running. You will not be able to collect logs on this instance until you start Logstash."); ?>
            </div>
        <?php }
        } ?>

        <?php echo form_open('configure/save/'.$node['_id']); ?>
        <div>
            <div>
                <input id="apply-after" type="hidden" value="0" name="apply_after">
                <div class="tw-flex tw-flex-row tw-items-center tw-gap-2 tw-mb-4">
                <?php if (user_has_permission('configure', array('all'))) { ?>
                    <button disabled type="submit" class="save-btn ui-btn ui-btn-default">
                        <?php echo _("Save"); ?>
                    </button>
                    <tooltip-provider>
                        <tooltip data-position="top" data-delay="100">
                            <tooltip-trigger>
                                <button disabled type="button" id="save-and-apply" class="ui-btn ui-btn-secondary">
                                    <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                                        <i class="material-symbols-outlined">save</i>
                                        <?php echo _("Save &amp; Apply"); ?>
                                    </div>
                                </button>
                            </tooltip-trigger>
                            <tooltip-content>
                            <div><?php echo _("Save configuration and apply to ALL available instances. This will cause logstash to restart on all instances."); ?></div>
                        </tooltip-content>
                        </tooltip>
                    </tooltip-provider>
                    <tooltip-provider>
                        <tooltip data-position="top" data-delay="100">
                            <tooltip-trigger>
                                <button type="button" id="verify" class="ui-btn ui-btn-outlined">
                                    <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                                        <i class="material-symbols-outlined">check</i>
                                        <?php echo _("Verify"); ?>
                                    </div>
                                </button>
                            </tooltip-trigger>
                            <tooltip-content>
                            <div><?php echo _("Verify the syntax of this portion")." (".$node_name.") "._("of the config file."); ?></div>
                        </tooltip-content>
                        </tooltip>
                    </tooltip-provider>
                <?php } ?>

                <dropdown-menu data-position="bottom">
                    <dropdown-trigger>
                        <a class="ui-btn ui-btn-outlined"><?php echo _("View"); ?></a>
                    </dropdown-trigger>
                    <dropdown-content class="ui-dropdown-content">
                        <a class="view-file" data-type="input">
                            <dropdown-item class="ui-dropdown-item"><?php echo _("Inputs File"); ?></dropdown-item>
                        </a>
                        <a class="view-file" data-type="filter">
                            <dropdown-item class="ui-dropdown-item"><?php echo _("Filters File"); ?></dropdown-item>
                        </a>
                        <a class="view-file" data-type="output">
                            <dropdown-item class="ui-dropdown-item"><?php echo _("Outputs File"); ?></dropdown-item>
                        </a>
                        <a class="view-file" data-type="all">
                            <dropdown-item class="ui-dropdown-item"><?php echo _("All Files Combined"); ?></dropdown-item>
                        </a>
                    </dropdown-content>
                </dropdown-menu>
                <tooltip-provider id="not-saved" class="tw-hidden tw-leading-none">
                    <tooltip data-position="top" data-delay="100">
                        <tooltip-trigger>
                            <i class="material-symbols-outlined tw-text-info-border">info</i>
                        </tooltip-trigger>
                        <tooltip-content>
                            <div>
                                <?php echo _('The changes to the config files have not been saved or applied.'); ?>
                            </div>
                        </tooltip-content>
                    </tooltip>
                </tooltip-provider>
            </div>
        </div>
        <div>
            <ui-tabs default-value="input">
                <tabs-list class="tw-w-full">
                    <tabs-trigger value="input"><?php echo _("Inputs"); ?></tabs-trigger>
                    <tabs-trigger value="filter"><?php echo _("Filters"); ?></tabs-trigger>
                    <tabs-trigger value="output"><?php echo _("Outputs"); ?></tabs-trigger>
                </tabs-list>
                <tabs-content value="input">
                    <div class="tw-flex tw-justify-between tw-items-center tw-mb-4">
                        <div class="tw-flex tw-flex-row tw-gap-2 tw-items-center tw-justify-center">
                            <h4 class="tw-text-foreground tw-font-medium"><?php echo _("Inputs"); ?></h4>
                            <a href="https://assets.nagios.com/downloads/nagios-log-server/docs/Listening-On-Privileged-Ports-With-Nagios-Log-Server.pdf" target="_blank" class="no-primary tw-flex tw-items-center tw-gap-1 tw-w-fit tw-rounded-md tw-bg-secondary tw-text-sm tw-p-1 tw-ring-foreground hover:tw-no-underline hover:tw-text-inherit active:tw-ring-1 active:tw-outline-none focus:tw-ring-1 focus:tw-outline-none focus:tw-ring focus:tw-no-underline focus:tw-text-inherit">
                                <?php echo _("Privileged Ports");?>
                                <i class="material-symbols-outlined small">open_in_new</i>
                            </a>
                        </div>
                        <?php if (user_has_permission('configure', array('all'))) { ?>
                        <div>
                            <a class="custom tw-flex tw-items-center tw-justify-center tw-gap-2 ui-btn ui-btn-outlined" data-type="input">
                                <i class="material-symbols-outlined">add</i>
                                <?php echo _("Add Input"); ?>
                            </a>
                        </div>
                        <?php } ?>
                    </div>
                    <div class="config-box input tw-grid tw-grid-cols-[repeat(auto-fill,_minmax(28rem,_1fr))] tw-gap-4" data-type="input">
                    <?php
                    if (count($node_inputs) > 0) {
                        foreach ($node_inputs as $k => $input) { ?>
                            <div class="block">
                                <div class="block-card">
                                    <div class="name tw-flex tw-flex-row tw-items-center tw-gap-2">
                                        <label class="switch">
                                        <?php if (!user_has_permission('configure', array('all'))) {
                                            if ($input['active']) { ?>
                                                <input type="checkbox" class="active" checked disabled>
                                            <?php } else { ?>
                                                <input type="checkbox" class="active" disabled>
                                            <?php }
                                        } else { ?>
                                            <input type="checkbox" class="toggle-activity active" <?php if ($input['active'] == 1) { echo "checked"; } ?>>
                                        <?php } ?>
                                            <span class="toggle"></span>
                                        </label>
                                        <span class="name"><?php echo html_escape($input['name']); ?></span>
                                        <input type="hidden" class="name ui-input" style="background-color:hsl(var(--background));" name="input_names[<?php echo $k; ?>]" value="<?php echo html_escape($input['name']); ?>">
                                        <input type="hidden" class="active ui-input" name="input_active[<?php echo $k; ?>]" value="<?php echo $input['active']; ?>">
                                    </div>
                                    <div class="actions">
                                    <?php if (user_has_permission('configure', array('all'))) { ?>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="edit"><i class="material-symbols-outlined ui-icon-btn">edit</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Edit'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                    <?php } ?>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="open"><i class="material-symbols-outlined ui-icon-btn tw-transition">keyboard_arrow_down</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Open'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                    <?php if (user_has_permission('configure', array('all'))) { ?>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="copy"><i class="material-symbols-outlined ui-icon-btn">content_copy</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Copy'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="delete"><i class="material-symbols-outlined ui-icon-btn">delete</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Remove'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                    <?php } ?>
                                    </div>
                                </div>
                                <?php
                                $height = '115';
                                $numlines = substr_count($input['raw'], "\n")+1;
                                foreach (explode("\n", $input['raw']) as $line) {
                                    if (strlen($line) > 100) {
                                        $extra = ceil(strlen($line) / 100);
                                    }
                                }
                                if ($numlines > 4) {
                                    $height = $numlines * 27 + ($extra * 20);
                                }
                                ?>
                                <div class="raw hide">
                                    <textarea name="inputs[<?php echo $k; ?>]" style="height: <?php echo $height; ?>px;" class="tw-w-full tw-mt-4 tw-p-4"><?php echo html_escape($input['raw']); ?></textarea>
                                </div>
                            </div>
                        <?php }
                    } else { ?>
                            <div class="no-blocks"><?php echo _("There are no inputs created for this configuration."); ?></div>
                    <?php } ?>
                    </div>
                </tabs-content>
                <tabs-content value="filter">
                    <div class="tw-flex tw-justify-between tw-items-center tw-mb-4">
                        <div class="tw-flex tw-flex-row tw-gap-2 tw-items-center tw-justify-center">
                            <h4 class="tw-text-foreground tw-font-medium"><?php echo _("Filters"); ?></h4>
                        </div>
                        <?php if (user_has_permission('configure', array('all'))) { ?>
                        <div>
                            <a class="custom tw-flex tw-items-center tw-justify-center tw-gap-2 ui-btn ui-btn-outlined" data-type="filter">
                                <i class="material-symbols-outlined">add</i>
                                <?php echo _("Add Filter"); ?>
                            </a>
                        </div>
                        <?php } ?>
                    </div>
                    <div class="config-box filter tw-grid tw-grid-cols-[repeat(auto-fill,_minmax(28rem,_1fr))] tw-gap-4" data-type="filter">
                    <?php 
                    if (count($node_filters) > 0) {
                        foreach ($node_filters as $k => $filter) { ?>
                            <div class="block">
                                <div class="block-card">
                                    <div class="name tw-flex tw-flex-row tw-items-center tw-gap-2">
                                        <label class="switch">
                                        <?php if (!user_has_permission('configure', array('all'))) {
                                            if ($filter['active']) { ?>
                                                <input type="checkbox" class="active" checked disabled>
                                            <?php } else { ?>
                                                <input type="checkbox" class="active" disabled>
                                            <?php }
                                        } else { ?>
                                            <input type="checkbox" class="toggle-activity active" <?php if ($filter['active'] == 1) { echo "checked"; } ?>>
                                        <?php } ?>
                                            <span class="toggle"></span>
                                        </label>
                                        <span class="name"><?php echo html_escape($filter['name']); ?></span>
                                        <input type="hidden" class="name ui-input" style="background-color:hsl(var(--background));" name="filter_names[<?php echo $k; ?>]" value="<?php echo html_escape($filter['name']); ?>">
                                        <input type="hidden" class="active" name="filter_active[<?php echo $k; ?>]" value="<?php echo $filter['active']; ?>">
                                    </div>
                                    <div class="actions">
                                    <?php if (user_has_permission('configure', array('all'))) { ?>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="edit"><i class="material-symbols-outlined ui-icon-btn">edit</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Edit'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                    <?php } ?>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="open"><i class="material-symbols-outlined ui-icon-btn tw-transition">keyboard_arrow_down</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Open'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                    <?php if (user_has_permission('configure', array('all'))) { ?>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="copy"><i class="material-symbols-outlined ui-icon-btn">content_copy</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Copy'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="delete"><i class="material-symbols-outlined ui-icon-btn">delete</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Remove'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                    <?php } ?>
                                    </div>
                                </div>
                                <?php
                                $height = '100';
                                $numlines = substr_count($filter['raw'], "\n")+1;
                                foreach (explode("\n", $filter['raw']) as $line) {
                                    if (strlen($line) > 100) {
                                        $extra = ceil(strlen($line) / 100);
                                    }
                                }
                                if ($numlines > 4) {
                                    $height = $numlines * 17 + ($extra * 17);
                                }
                                ?>
                                <div class="raw hide">
                                    <textarea name="filters[<?php echo $k; ?>]" style="height: <?php echo $height; ?>px;" class="tw-w-full tw-mt-4 tw-p-4"><?php echo html_escape($filter['raw']); ?></textarea>
                                </div>
                            </div>
                        <?php }
                    } else { ?>
                            <div class="no-blocks"><?php echo _("There are no filters created for this configuration."); ?></div>
                    <?php } ?>
                    </div>
                </tabs-content>
                <tabs-content value="output">
                    <div class="tw-flex tw-justify-between tw-items-center tw-mb-4">
                        <div class="tw-flex tw-flex-row tw-gap-2 tw-items-center tw-justify-center">
                            <h4 class="tw-text-foreground tw-font-medium"><?php echo _("Outputs"); ?></h4>
                        </div>
                        <?php if (user_has_permission('configure', array('all'))) { ?>
                        <div>
                            <a class="custom tw-flex tw-items-center tw-justify-center tw-gap-2 ui-btn ui-btn-outlined" data-type="output">
                                <i class="material-symbols-outlined">add</i>
                                <?php echo _("Add Output"); ?>
                            </a>
                        </div>
                        <?php } ?>
                    </div>
                    <div class="config-box output tw-grid tw-grid-cols-[repeat(auto-fill,_minmax(28rem,_1fr))] tw-gap-4" data-type="output">
                    <?php 
                    if (count($node_outputs) > 0) {
                        foreach ($node_outputs as $k => $output) { ?>
                            <div class="block">
                                <div class="block-card">
                                    <div class="name tw-flex tw-flex-row tw-items-center tw-gap-2">
                                        <label class="switch">
                                        <?php if (!user_has_permission('configure', array('all'))) {
                                            if ($output['active']) { ?>
                                                <input type="checkbox" class="active" checked disabled>
                                            <?php } else { ?>
                                                <input type="checkbox" class="active" disabled>
                                            <?php }
                                        } else { ?>
                                            <input type="checkbox" class="toggle-activity active" <?php if ($output['active'] == 1) { echo "checked"; } ?>>
                                        <?php } ?>
                                            <span class="toggle"></span>
                                        </label>
                                        <span class="name"><?php echo html_escape($output['name']); ?></span>
                                        <input type="hidden" class="name ui-input" style="background-color:hsl(var(--background));" name="output_names[<?php echo $k; ?>]" value="<?php echo html_escape($output['name']); ?>">
                                        <input type="hidden" class="active" name="output_active[<?php echo $k; ?>]" value="<?php echo $output['active']; ?>">
                                    </div>
                                    <div class="actions">
                                    <?php if (user_has_permission('configure', array('all'))) { ?>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="edit"><i class="material-symbols-outlined ui-icon-btn">edit</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Edit'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                    <?php } ?>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="open"><i class="material-symbols-outlined ui-icon-btn tw-transition">keyboard_arrow_down</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Open'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                    <?php if (user_has_permission('configure', array('all'))) { ?>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="copy"><i class="material-symbols-outlined ui-icon-btn">content_copy</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Copy'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="delete"><i class="material-symbols-outlined ui-icon-btn">delete</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Remove'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                    <?php } ?>
                                    </div>
                                </div>
                                <?php
                                $height = '100';
                                $numlines = substr_count($output['raw'], "\n")+1;
                                foreach (explode("\n", $output['raw']) as $line) {
                                    if (strlen($line) > 100) {
                                        $extra = ceil(strlen($line) / 100);
                                    }
                                }
                                if ($numlines > 4) {
                                    $height = $numlines * 17 + ($extra * 17);
                                }
                                ?>
                                <div class="raw hide">
                                    <textarea name="outputs[<?php echo $k; ?>]" style="height: <?php echo $height; ?>px;" class="tw-w-full tw-mt-4 tw-p-4"><?php echo html_escape($output['raw']); ?></textarea>
                                </div>
                            </div>
                        <?php }
                    } else { ?>
                            <div class="no-blocks"><?php echo _("There are no outputs created for this configuration."); ?></div>
                    <?php } ?>
                    </div>
                </tabs-content>
            </ui-tabs>
        </div>
        <div>
    <!-- REAL TIME ALERTS-->
    <?php if ($node['_id'] == 'global') { ?>
            <div class="form-header tw-my-4"><?php echo _("Real-Time Alerts (Read-Only)");?></div>
            <ui-tabs default-value="rta-filter">
                <tabs-list class="tw-w-full">
                    <tabs-trigger value="rta-filter"><?php echo _("Filters"); ?></tabs-trigger>
                    <tabs-trigger value="rta-output"><?php echo _("Outputs"); ?></tabs-trigger>
                </tabs-list>
                <tabs-content value="rta-filter" id="rta-filters">
                    <div class="tw-flex tw-items-center tw-mb-4">
                        <h4 class="tw-text-foreground tw-font-medium"><?php echo _("Filters"); ?></h4>
                    </div>
                    <div class="config-box rta-filter tw-grid tw-grid-cols-[repeat(auto-fill,_minmax(28rem,_1fr))] tw-gap-4" data-type="rta-filter">
                    <?php 
                    if (count($node_livealert_filters) > 0) {
                        foreach ($node_livealert_filters as $k => $filter) { ?>         
                            <div class="block">
                                <div class="block-card">
                                    <div class="name tw-flex tw-flex-row tw-items-center tw-gap-2">
                                        <label class="switch">
                                            <?php if ($filter['active']) { ?>
                                                <input type="checkbox" class="active" checked disabled>
                                            <?php } else { ?>
                                                <input type="checkbox" class="active" disabled>
                                            <?php } ?>
                                            <span class="toggle"></span>
                                        </label>
                                        <span class="name"><?php echo html_escape($filter['name']); ?></span>
                                    </div>
                                    <div class="actions">
                                        <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="open"><i class="material-symbols-outlined ui-icon-btn tw-transition">keyboard_arrow_down</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Open'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                    </div>
                                </div>
                                <?php
                                $height = '100';
                                $numlines = substr_count($filter['raw'], "\n")+1;
                                foreach (explode("\n", $filter['raw']) as $line) {
                                    if (strlen($line) > 100) {
                                        $extra = ceil(strlen($line) / 100);
                                    }
                                }
                                if ($numlines > 4) {
                                    $height = $numlines * 17 + ($extra * 17);
                                }
                                ?>
                                <div class="raw hide">
                                    <textarea style="height: <?php echo $height; ?>px;" class="tw-w-full tw-mt-4 tw-p-4" disabled><?php echo html_escape($filter['raw']); ?></textarea>
                                </div>
                            </div>
                        <?php } // endforeach
                    } else { ?>
                        <div class="no-blocks"><?php echo _("There are no filters for real-time alerts."); ?></div>
                    <?php } ?>
                 </div>
            </tabs-content>
            <tabs-content value="rta-output" id="rta-outputs">                     
                <div class="tw-flex tw-items-center tw-mb-4">
                    <h4 class="tw-text-foreground tw-font-medium"><?php echo _("Outputs"); ?></h4>
                </div>
                <div class="config-box rta-output tw-grid tw-grid-cols-[repeat(auto-fill,_minmax(28rem,_1fr))] tw-gap-4" data-type="rta-output">
                <?php 
                if (count($node_livealert_outputs) > 0) {
                    foreach ($node_livealert_outputs as $k => $output) { ?>
                        <div class="block">
                            <div class="block-card">
                                <div class="name tw-flex tw-flex-row tw-items-center tw-gap-2">
                                    <label class="switch">
                                        <?php if ($filter['active']) { ?>
                                            <input type="checkbox" class="active" checked disabled>
                                        <?php } else { ?>
                                            <input type="checkbox" class="active" disabled>
                                        <?php } ?>
                                        <span class="toggle"></span>
                                    </label>
                                    <span class="name"><?php echo html_escape($output['name']); ?></span>
                                </div>
                                <div class="actions">
                                    <tooltip-provider>
                                            <tooltip data-position="top" data-delay="100">
                                                <tooltip-trigger>
                                                    <a class="open"><i class="material-symbols-outlined ui-icon-btn tw-transition">keyboard_arrow_down</i></a>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                <div><?php echo _('Open'); ?></div>
                                            </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                </div>
                            </div>
                            <?php
                            $height = '100';
                            $numlines = substr_count($output['raw'], "\n")+1;
                            foreach (explode("\n", $output['raw']) as $line) {
                                if (strlen($line) > 100) {
                                    $extra = ceil(strlen($line) / 100);
                                }
                            }
                            if ($numlines > 4) {
                                $height = $numlines * 17 + ($extra * 17);
                            }
                            ?>
                            <div class="raw hide">
                                <textarea style="height: <?php echo $height; ?>px;" class="tw-w-full tw-mt-4 tw-p-4" disabled><?php echo html_escape($output['raw']); ?></textarea>
                            </div>
                        </div>
                    <?php }
                } else { ?>
                    <div class="no-blocks"><?php echo _("There are no outputs for real-time alerts."); ?></div>
                <?php } ?>
                </div>
            </tabs-content>
        </ui-tabs>
    <?php } ?>
        </div>
        </div>
        <?php if (user_has_permission('configure', array('all'))) { ?>
        <button disabled type="submit" class="save-btn ui-btn ui-btn-default"><?php echo _("Save"); ?></button>
        <?php
        }
        echo form_close();
        ?>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {

    $('.view-file').click(function() {
        var type = $(this).data("type");
        $('#view').modal('show');
        $('#view-title').html($(this).text());

        // Grab the actual file and insert it into the textarea
        $.post(site_url+"api/system/view_file_by_type", { type: type, node: '<?php echo $node['_id']; ?>' }, function(file) {
            $('#view-file').html(file);
        });
    });

    $('#verify').click(function() {
        $('#verify-modal').modal({backdrop: 'static'});
        $('#verify-loader').show();
        $('#verify-config-output').hide()
        $('#verify-message').hide();

        // Do the actual config verification...
        $.post(site_url+"api/system/verify_config_syntax", { node: '<?php echo $node['_id']; ?>' }, function(data) {
            $('#verify-loader').hide();
            if (data.result == "success") {
                $('#verify-message').removeClass('alert-error').addClass('alert-success').html('<?php echo _("Configuration is OK!"); ?>').show();
            } else {
                $('#verify-message').removeClass('alert-success').addClass('alert-error').html('<?php echo _("There was an error in the configuration!"); ?>').show();
                
                var error = "";
                $.each(data.output, function(k, v) {
                    error += v + "\n";
                });

                $('#verify-config-output').html(error);
                $('#verify-config-output').show();
                $('#verify-message').show();
            }
        }, 'json');

    });

    $('#save-and-apply').click(function() {
        $('#apply-after').val('1');
        $('form').submit();
    });

    // Make a new custom block
    $('.custom').click(function() {
        var type = $(this).data('type');
        // Verify there is no "no xxx" div's
        $('.config-box.'+type).find('.no-blocks').hide();
        $('.config-box.'+type).append(create_new_block_string(type));
        save_needed();
    });

    // When clicking on the edit button for any type of thing...
    $(".configure-layout").on('click', 'a.edit', function() {
        $(this).hide();
        $(this).parents('.block').find('.name span.name').hide();
        $(this).parents('.block').find('.name input.name').attr('type', "text");
    });

    // When clicking the active/inactive button
    $(".configure-layout").on('click', '.toggle-activity', function() {
        if ($(this).prop('checked')) {
            $(this).parents('.block').find('.name input.active').val('1');
        } else {
            $(this).parents('.block').find('.name input.active').val('0');
        }
        save_needed();
    });

    // When clicking on the open button for any type of thing...
    $(".configure-layout").on('click', 'a.open', function() {
        if ($(this).parents('.block').find('.raw').is(':visible')) {
            $(this).find(".material-symbols-outlined").removeClass("tw-rotate-180");
            $(this).parents('.block').removeClass("tw-row-span-3");
            $(this).parents('.block').find('.raw').hide();
        } else {
            $(this).find(".material-symbols-outlined").addClass("tw-rotate-180");
            $(this).parents('.block').addClass("tw-row-span-3");
            $(this).parents('.block').find('.raw').show();
        }
    });

    // Copy a block
    $(".configure-layout").on('click', 'a.copy', function() {
        var type = $(this).parents('.config-box').data('type');
        var name = $(this).parents('.block').find('input.name').val();
        var raw = $(this).parents('.block').find('textarea').text();
        $('.config-box.'+type).append(create_new_block_string(type, name, raw));
        save_needed();
    });

    // Remove the block from the config area
    $(".configure-layout").on('click', 'a.delete', function() {
        if ($(this).parents('.config-box').find('.block').length == 1) {
            if ($(this).parents('.config-box').find('.no-blocks').length == 0) {
                $(this).parents('.config-box').append('<div class="no-blocks">' + <?php echo json_encode(_("There are no blocks for this configuration.")); ?> + '</div>');
            } else {
                $(this).parents('.config-box').find('.no-blocks').show();
            }
        }
        $(this).parents('.block').remove();
        save_needed();
    });


    $('#prim').click(function() {
        $('.alert-offline button.btn-m').hide();
        $('#permanent').show();
    });

    $('#dk').click(function() {
        $('.alert-offline button.btn-m').hide();
        $('#dont-know').show();
    });

    // Set up sortability
    $('.config-box').sortable({
        items: ".block",
        placeholder: "whitespace-holder",
        delay: 200,
        stop: function(event, ui) {
            var type = $(ui.item).parents('.config-box').data('type');
            reorder_input_names(type);
            save_needed();
        }
    });

    $('textarea').on('keydown', function(e) {
        if ((e.which < 16 || e.which > 45) && e.which != 91 && e.which != 92 && (e.which < 112 || e.which > 123)) {
            save_needed();
        }
    });

    $('textarea').on('keydown', function(event) {
        if (event.key == "Tab") {
            event.preventDefault();
            var currentPos = this.selectionStart;
            let replacementText = this.value.slice(0, currentPos) + '    ' + this.value.slice(currentPos)
            this.value = replacementText;
            this.selectionEnd = currentPos + 4;
        }
    });

    $('.name input.name').on('keydown', function(e) {
        if ((e.which < 16 || e.which > 45) && e.which != 91 && e.which != 92 && (e.which < 112 || e.which > 123)) {
            save_needed();
        }
    });
});

function create_new_block_string(type, name, raw)
{
    if (name == undefined) { name = ''; }
    if (raw == undefined) { raw = ''; }
    html = `
        <div class="block">
            <div class="block-card">
                <div class="name tw-flex tw-flex-row tw-items-center tw-gap-2">
                    <label class="switch tw-shrink-0">
                        <input type="checkbox" class="toggle-activity active" checked>
                        <span class="toggle"></span>
                    </label>
                    <input type="text" style="background-color:hsl(var(--background));" class="name ui-input" name="`+type+`_names[]" placeholder="<?php echo _('Block Name'); ?>" value="`+name+`">
                    <input type="hidden" class="active" name="`+type+`_active[]" value="1">
                </div>
                <div class="actions">
                    <tooltip-provider>
                        <tooltip data-position="top" data-delay="100">
                            <tooltip-trigger>
                                <a class="open"><i class="material-symbols-outlined ui-icon-btn tw-transition">keyboard_arrow_down</i></a>
                            </tooltip-trigger>
                            <tooltip-content>
                            <div><?php echo _('Open'); ?></div>
                        </tooltip-content>
                        </tooltip>
                    </tooltip-provider>
                    <tooltip-provider>
                        <tooltip data-position="top" data-delay="100">
                            <tooltip-trigger>
                                <a class="copy"><i class="material-symbols-outlined ui-icon-btn">content_copy</i></a>
                            </tooltip-trigger>
                            <tooltip-content>
                            <div><?php echo _('Copy'); ?></div>
                        </tooltip-content>
                        </tooltip>
                    </tooltip-provider>
                    <tooltip-provider>
                        <tooltip data-position="top" data-delay="100">
                            <tooltip-trigger>
                                <a class="delete"><i class="material-symbols-outlined ui-icon-btn">delete</i></a>
                            </tooltip-trigger>
                            <tooltip-content>
                            <div><?php echo _('Remove'); ?></div>
                        </tooltip-content>
                        </tooltip>
                    </tooltip-provider>
                </div>
            </div>
            <div class="raw hide">
                <textarea name="`+type+`s[]" class="tw-h-40 tw-w-full tw-mt-4 tw-p-4">`+raw+`</textarea>
            </div>
        </div>
    `;
    return html;
}

// Goes through the list of items and re-orders them one by one
function reorder_input_names(type)
{
    $('.config-box.'+type+' .block').each(function(k, v) {
        $(v).find('input.name').prop('name', type+'_names['+k+']');
        $(v).find('input.active').prop('name', type+'_active['+k+']');
        $(v).find('textarea').prop('name', type+'s['+k+']');
    });
}

function save_needed()
{
    $('.save-btn').prop('disabled', false);
    $('#save-and-apply').prop('disabled', false);
    $('#not-saved').show();
}
</script>

<!-- View config modal -->
<div id="view" class="modal hide fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="myModalLabel"><?php echo _("View"); ?> - <span id="view-title"></span></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body configure">
                <textarea id="view-file" class="tw-w-full tw-h-60"></textarea>
            </div>
            <div class="modal-footer">
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _("Close"); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Verify configuration modal -->
<div id="verify-modal"class="modal hide fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="myModalLabel"><?php echo _("Verify Configuration"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div id="verify-loader" class="tw-flex tw-items-center">
                    <span class="spinner"></span>
                    <?php echo _("Running"); ?>...
                </div>
                <div id="verify-message" class="alert tw-mb-0"></div>
                <pre id="verify-config-output" class="tw-w-full tw-mt-4"></pre>
            </div>
            <div class="modal-footer">
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _("Close"); ?></button>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>