<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <div class="doc-wrapper">

            <div class="tw-flex tw-items-end">
                <div class="source-logo">
                    <i class="fa fa-xl fa-fw fa-cube"></i>
                </div>
                <h1><?php echo _('IIS Web Server'); ?></h1>
            </div>
            <div class="form-spacer"></div>

            <h3><?php echo _("Getting Started"); ?></h3>
            <p class="tw-pb-2.5"><?php echo _("This guide will show how to use Nxlog on Windows Server to send IIS web server logs to Nagios Log Server."); ?></p>

            <h3><?php echo _("Requirements"); ?></h3>
            <p><?php echo _("If you don't already have Nxlog installed on the Windows server machine, follow the"); ?> <a class="tw-text-primary hover:tw-text-primary" href="<?php echo site_url('source/windows'); ?>"><?php echo _("Windows source setup"); ?></a> <?php echo _("before continuing"); ?>.</p>

            <h3><?php echo _("Configuration Setup"); ?></h3>

            <h6><?php echo _("Create the Nxlog Input"); ?></h6>
            <p><?php echo _("You can monitor a specific IIS Web Server log file by adding a new input field into your nxlog configuration file, usually located in <code>C:\Program Files (x86)\\nxlog\conf\\nxlog.conf</code>."); ?></p>
            <div class="code-tooltip">
                <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                <pre><code class="apache" tabindex="1"><?php echo $step2; ?></code></pre>
            </div>
            <p><?php echo _("Each nxlog.conf Input requires a <i>unique name</i>. If you copy/paste the above make sure that "); ?><b>iis_log1</b><?php echo _(" is not already in use. Normally the input name is the name of the file specified in the File section."); ?> 
            <?php echo _("You may need to specify a different path to the IIS log file you desire to monitor. Add this path to " ); ?><b><?php echo _("File"); ?></b><?php echo _(" inside of single quotes just like the above example."); ?></p>
            <p><?php echo _("Log files and locations will be unique to your IIS web server setup."); ?></p>

            <h6><?php echo _("Route the Output"); ?></h6>
            <p><?php echo _("Once you add the Input you will need to add to the route section for the input we just added which will pass the log data to Nagios Log Server."); ?></p>
            <div class="code-tooltip">
                <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                <pre><code class="apache" tabindex="2"><?php echo $step3; ?></code></pre>
            </div>
            <p><?php echo _("Again, You will need to rename"); ?> <b>iis_log1</b> <?php echo _("to the name of the file you desire to monitor"); ?>.</p>

            <h3 class="tw-pt-5"><?php echo _("Verify Incoming Logs"); ?></h3>
            <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
            <div class="form-inline">
                <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("IP Address"); ?></label>
                    <div class="tw-flex tw-w-1/3">
                        <input class="ui-input" name="sender_ip" type="text">
                        <button id="verify" class="ui-btn ui-btn-default tw-ml-3"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="spinner"></i></span>
                    </div>
                </div>
            </div>
            <div class="verify">
                <div class="well hide verify-logs" id="verify-output"></div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>