<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <div class="doc-wrapper">
            <div class="tw-flex tw-items-end">
                <div class="source-logo">
                    <i class="fa fa-xl fa-fw fa-linux"></i>
                </div>
                <h1><?php echo _('Linux Files'); ?></h1>
            </div>
            <div class="form-spacer"></div>

            <h3><?php echo _("Getting Started"); ?></h3>
            <p class="tw-pb-2.5"><?php echo _("This guide will walk you through the process of sending log files to Nagios Log Server. There are two setup methods, one using the automatic setup utility that comes with Log Server and one for manually setting up rsyslog."); ?></p>

            <h3><?php echo _("Configuration Setup"); ?></h3>

            <ui-tabs default-value="script">
                <tabs-list>
                    <tabs-trigger value="script"><?php echo _("Automatic"); ?></tabs-trigger>
                    <tabs-trigger value="manual"><?php echo _("Manual (rsyslog)"); ?></tabs-trigger>
                </tabs-list>

                <tabs-content value="script" class="tw-pt-2.5">
                    <h6><?php echo _("Automatic Script - Supported Operating Systems"); ?></h6>
                    <div>
                        <ul class="tw-mb-2.5 tw-ml-7">
                            <li><?php echo _('CentOS, Fedora, and RHEL'); ?></li>
                            <li><?php echo _('Ubuntu and Debian'); ?></li>
                        </ul>
                    </div>
                    <p><i><?php echo _('You must have rsyslog installed. If your operating system is not listed, you can manually configure syslog.'); ?></i></p>
                    <h6><?php echo _("Run the Script"); ?></h6>
                    <p><?php echo _("Send a log file using the utility script"); ?>:</p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="1"><?php echo $step2; ?></code></pre>
                    </div>
                    <p><?php echo _("You will need to replace the "); ?><b>/path/to/file</b><?php echo _(" to be the path to the file you are monitoring. Replace "); ?><b>FILE_TAG</b><?php echo _(" with a tag to identify logs from the file. It is used for the 'process.name' field in Log Server."); ?></p>
                </tabs-content>

                <tabs-content value="manual" class="tw-pt-2.5">
                    <h6><?php echo _("Verify Spool and Config Location"); ?></h6>
                    <p><?php echo _("Put the following in your terminal window to verify the rsyslog spool directory and that the rsyslog.d folder exists. The second line will give you the path you will need to add in the next section for <b>\$WorkDirectory</b> in the configuration. Then it will open the <code>rsyslog.conf</code> file."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="2"><?php echo $step3; ?></code></pre>
                    </div>
                    <h6><?php echo _("Setup the Rsyslog Configuration File"); ?></h6>
                    <p><?php echo _("Add the following to the <code>rsyslog.conf</code>. Look for the 'begin forwarding rule.'"); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="apache" tabindex="3"><?php echo $step4; ?></code></pre>
                    </div>
                    <p><?php echo _("Replace each variable"); ?> <b>FILE_PATH</b> <?php echo _("with the unique file name you want to monitor and each"); ?> <b>FILE_TAG</b> <?php echo _("with an application name or nickname for the file."); ?></p>
                    <div class="tw-m-2.5 tw-pl-6">
                        <p><i><?php echo _("Replace the following above:"); ?></i></p>
                        <p><?php echo _("FILE_PATH: The absolute path to the file itself."); ?></p>
                        <p><?php echo _("FILE_TAG: A tag to identify logs from the file. It is used for the 'process.name' field in Log Server."); ?></p>
                        <p><?php echo _("FILE_ID: An identifier for this file. This must be unique on the host. Spaces are not allowed."); ?></p>
                    </div>
                    <p><?php echo _("You will also need to replace"); ?><b> $WorkDirectory</b> <?php echo _("with the unique file path of the rsyslog spool directory. This was displayed from the command on line 2 of the previous codeblock. If this isn't set correctly the rsyslog service will error on restart."); ?></p>
                    <p><?php echo _("Example: \$WorkDirectory /var/lib/rsyslog"); ?></p>
                </tabs-content>
            </ui-tabs>

            <h3><?php echo _("Verify Incoming Logs"); ?></h3>
            <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
            <div class="form-inline">
                <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("IP Address"); ?></label>
                    <div class="tw-flex tw-w-1/3">
                        <input class="ui-input" name="sender_ip" type="text">
                        <button id="verify" class="ui-btn ui-btn-default tw-ml-3"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="spinner"></i></span>
                    </div>
                </div>
            </div>
            <div class="verify">
                <div class="well hide verify-logs" id="verify-output"></div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>
