<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <div class="doc-wrapper">
            <div class="tw-flex tw-items-end">
                <div class="source-logo">
                    <i class="fa fa-xl fa-fw fa-database"></i>
                </div>
                <h1><?php echo _('MySQL'); ?></h1>
            </div>
            <div class="form-spacer"></div>

            <h3><?php echo _("Getting Started"); ?></h3>
            <p class="tw-pb-2.5"><?php echo _("This guide will show how to use Nxlog to send logs from a file to Nagios Log Server."); ?></p>

            <h3><?php echo _("Requirements"); ?></h3>
            <h6><?php echo _("MySQL Filter"); ?></h6>
            <p><?php echo _("If the filter does not already exist, add the filter below. Copy and paste the below filter into the Filter field of the"); ?> <a class="tw-text-primary hover:tw-text-primary" href="<?php echo site_url('configure/instance/global'); ?>"><?php echo _("Global Configuration section"); ?></a>. <?php echo _("Add it into the Filter field, Verify the filter, Save and then Apply. This will allow Nagios Log Server to match the mysql message contents and replace the log type with mysql_log."); ?></p>
            <div class="code-tooltip">
                <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                <pre><code class="shell" tabindex="1"><?php echo $step1; ?></code></pre>
            </div>

            <h3><?php echo _("Configuration Setup"); ?></h3>
            <ui-tabs default-value="script">
                <tabs-list>
                    <tabs-trigger value="script"><?php echo _("Automatic"); ?></tabs-trigger>
                    <tabs-trigger value="manual"><?php echo _("Manual (rsyslog)"); ?></tabs-trigger>
                    <tabs-trigger value="manual2"><?php echo _("Manual (rsyslog/init)"); ?></tabs-trigger>
                </tabs-list>

                <tabs-content value="script" class="tw-pt-2.5">
                    <h6><?php echo _("Automatic Script - Supported Operating Systems"); ?></h6>
                    <div>
                        <ul class="tw-mb-2.5 tw-ml-7">
                            <li><?php echo _('CentOS, Fedora, and RHEL'); ?></li>
                            <li><?php echo _('Ubuntu and Debian'); ?></li>
                        </ul>
                    </div>
                    <p><i><?php echo _('You must have rsyslog installed. If your operating system is not listed, you can manually configure syslog.'); ?></i></p>
                    <h6><?php echo _("Run the Script"); ?></h6>
                    <p><?php echo _("Run the script below to automatically configure your syslog daemon to send MySQL log files to Nagios Log Server."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="2"><?php echo $step2; ?></code></pre>
                    </div>
                    <p><?php echo _("Note: The file path for the mysqld.log file may depend on your Linux distribution. This example was done using CentOS 6.x so you may need to verify the location of your mysql log file."); ?></p>
                </tabs-content>

                <tabs-content value="manual" class="tw-pt-2.5">
                    <h6><?php echo _("Verify Spool and Config Location"); ?></h6>
                    <p><?php echo _("Put the following commands in your terminal window to verify the rsyslog spool directory and that the rsyslog.d folder exists. The second line will output the spool path you will need to add in the next section for \$WorkDirectory in the configuration."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="3"><?php echo $step3; ?></code></pre>
                    </div>
                    <h6><?php echo _("Setup the Rsyslog Configuration File"); ?></h6>
                    <p><?php echo _("Edit your"); ?> <code>/etc/rsyslog.conf</code> <?php echo _("file"); ?>. <?php echo _("Add the following to to the configuration file, looking for the 'begin forwarding rule.'"); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="apache" tabindex="4"><?php echo $step4; ?></code></pre>
                    </div>
                    <p><?php echo _("You will need to replace "); ?><b>$WorkDirectory</b><?php echo _(" with the unique file path of the rsyslog spool directory. This was displayed from the command on line 2 of the previous code block. If there is no directory specified, or the directory specified doesn't exist, then the rsyslog service will error on restart."); ?></p>
                    <p><?php echo _("Example:  \$WorkDirectory /var/lib/rsyslog"); ?></p>
                    <p><?php echo _("Restart the rsyslog service"); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="5"><?php echo "sudo /etc/init.d/rsyslog restart"; ?></code></pre>
                    </div>
                </tabs-content>

                <tabs-content value="manual2">
                    <div class="alert alert-info tw-flex tw-items-center tw-my-5 tw-mx-0">
                        <span class="material-symbols-outlined tw-mr-2">error</span>
                        <p> <?php echo _("This section requires you to have already set up syslog by going through the"); ?> <a href="<?php echo site_url('source/linux'); ?>"><?php echo _("Linux source setup"); ?></a> <?php echo _("guide, since MySQL will be configured to send from syslog directly"); ?>.</p>
                    </div>
                    <h6><?php echo _("Configure MySQL Daemon to Log to Syslog"); ?></h6>
                    <p><?php echo _("MySQL needs to be configured to send logs through syslog. All that needs to change is a single argument passed to the startup script. Simply add the following line into the <code>/etc/init.d/mysqld</code>."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="6">vi /etc/init.d/mysqld</code></pre>
                    </div>
                    <p><?php echo _("This example is from CentOS/RHEL 6. This may be different for other distributions of Linux, but once you find the path to the file the configuration is the same. Add the <code>--syslog</code> and <code>--log-error</code> flags into the \$exec command. In this example it is around line 127. Put this between the socket file and pid settings."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="7"><?php echo $step5; ?></code></pre>
                    </div>
                    <p><?php echo _("After the changes, it should look like the configuration below:"); ?></p>
                    <div class="code-tooltip">
                        <pre><code class="apache"># Pass all the options determined above, to ensure consistent behavior.
# In many cases mysqld_safe would arrive at the same conclusions anyway
# but we need to be sure.  (An exception is that we don't force the
# log-error setting, since this script doesn't really depend on that,
# and some users might prefer to configure logging to syslog.)
# Note: set --basedir to prevent probes that might trigger SELinux
# alarms, per bug #547485
$exec   --datadir="$datadir" --socket="$socketfile" \
--syslog --log-error="/var/log/mysql.log" --pid-file="$mypidfile" \
--basedir=/usr --user=mysql >/dev/null 2>&amp;1 &amp;
safe_pid=$!
</code></pre>
                    </div>
                    <p><?php echo _("Restart the MySQL daemon to start logging to syslog."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="8">sudo /etc/init.d/mysqld restart</code></pre>
                    </div>
                </tabs-content>
            </ui-tabs>

            <h3><?php echo _("Verify Incoming Logs"); ?></h3>
            <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
            <div class="form-inline">
                <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("IP Address"); ?></label>
                    <div class="tw-flex tw-w-1/3">
                        <input class="ui-input" name="sender_ip" type="text">
                        <button id="verify" class="ui-btn ui-btn-default tw-ml-3"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="spinner></i></span>
                    </div>
                </div>
            </div>
            <div class="verify">
                <div class="well hide verify-logs" id="verify-output"></div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>