<?php
function renderLeftbar($sections, $storageKey, $submenu=false) {
?>
<?php if (!$submenu): ?><div class="lside config-leftbar tw-space-y-2 tw-border-r header-container tw-min-w-[240px]"><?php endif; ?>
    <?php foreach ($sections as $header => $data): 
        $items = $data['items'];
        $header_text = $header;
        if (isset($data['header_text'])) {
            $header_text = $data['header_text'];
        }
        $isCollapsible = !empty($items);
        $headerLink = isset($data['header_link']) ? $data['header_link'] : null;
    ?>
        <div class="tw-mt-5">
            <button class="tw-flex tw-justify-between tw-items-center tw-w-full <?php if (!$submenu) { echo "tw-px-6"; } else { echo "tw-px-2"; } ?> tw-py-1.5 tw-text-left tw-text-[13px] focus:tw-outline-none" 
                    <?php echo $isCollapsible ? 'onclick="debouncedToggleAccordion(this, \'' . $header . '\')"' : ''; ?>>
                <?php if ($headerLink): ?>
                    <a href="<?php echo $headerLink; ?>" style="display: inline;">
                        <?php echo $header_text; ?>
                    </a>
                <?php else: ?>
                    <?php echo $header_text; ?>
                <?php endif; ?>
                <?php if ($isCollapsible): ?>
                    <span class="material-symbols-outlined tw-transition-transform tw-duration-200">expand_more</span>
                <?php endif; ?>
            </button>
            <?php if ($isCollapsible): ?>
                <div class="accordion-content no-transition" id="<?php echo $header; ?>-content">
                    <div class="tw-px-4 tw-py-2 tw-space-y-1">
                        <?php foreach ($items as $item): ?>
                            <?php if (isset($item['submenu'])) { renderLeftbar($item['submenu'],$storageKey . '_sub',true); continue; }?>
                            <a href="<?php echo $item['url']; ?>" class="tw-flex tw-items-center tw-px-1 tw-py-1 tw-text-sm tw-rounded-md tw-overflow-hidden" <?php echo isset($item['title']) ? 'title="' . $item['title'] . '"' : ''; ?>>
                                <?php if (isset($item['icon_class'])): ?>
                                    <i class="<?php echo $item['icon_class']; ?> tw-mr-2 tw-flex-shrink-0"></i>
                                <?php elseif (isset($item['icon'])): ?>
                                    <?php if (isset($item['icon_title'])): ?>
                                        <tooltip-provider>
                                            <tooltip data-position="right" data-delay="100">
                                                <tooltip-trigger class="tw-flex tw-items-center">
                                                    <span class="material-symbols-outlined tw-mr-2 tw-flex-shrink-0"><?php echo $item['icon']; ?></span>
                                                </tooltip-trigger>
                                                <tooltip-content>
                                                    <?php echo isset($item['icon_title']) ? $item['icon_title'] : ''; ?>
                                                </tooltip-content>
                                            </tooltip>
                                        </tooltip-provider>
                                    <?php else: ?>
                                        <span class="material-symbols-outlined tw-mr-2 tw-flex-shrink-0"><?php echo $item['icon']; ?></span>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <tooltip-provider>
                                    <tooltip data-position="right" data-delay="100">
                                        <tooltip-trigger>
                                            <span class="tw-flex-grow tw-truncate"><?php echo _(isset($item['text']) ? $item['text'] : $item['title']); ?></span>
                                        </tooltip-trigger>
                                        <!-- <tooltip-content>
                                            <div><?php echo _(isset($item['text']) ? $item['text'] : $item['title']); ?></div>
                                        </tooltip-content> -->
                                    </tooltip>
                                </tooltip-provider>
                                <?php if (isset($item['status_dot'])): ?>
                                    <tooltip-provider>
                                        <tooltip data-position="right" data-delay="100">
                                            <tooltip-trigger>
                                                <span class="tw-ml-2 status-dot status-dot-problem"></span>
                                            </tooltip-trigger>
                                            <tooltip-content>
                                                <?php echo isset($item['status_dot_title']) ? $item['status_dot_title'] : ''; ?>
                                            </tooltip-content>
                                        </tooltip>
                                    </tooltip-provider>
                                <?php endif; ?>
                                <?php if (isset($item['check']) && $item['check']): ?>
                                    <tooltip-provider>
                                        <tooltip data-position="right" data-delay="100">
                                            <tooltip-trigger class="tw-flex tw-items-center">
                                                <span class="material-symbols-outlined tw-ml-2 tw-flex-shrink-0">check</span>
                                            </tooltip-trigger>
                                            <tooltip-content>
                                                <?php echo _("This is the server you're currently logged into."); ?>
                                            </tooltip-content>
                                        </tooltip>
                                    </tooltip-provider>
                                <?php endif; ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
<?php if (!$submenu): ?></div>

<script>
let isToggling = false;

function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}

function toggleAccordion(button, sectionId) {
    if (isToggling) return;
    isToggling = true;

    const content = document.getElementById(sectionId + '-content');
    const icon = button.querySelector('.material-symbols-outlined');
    
    let openSections = JSON.parse(localStorage.getItem('<?php echo $storageKey; ?>')) || [];
    
    content.classList.remove('no-transition');
    
    requestAnimationFrame(() => {
        if (content.classList.contains('open')) {
            content.classList.remove('open');
            icon.style.transform = 'rotate(0deg)';
            openSections = openSections.filter(section => section !== sectionId);
        } else {
            content.classList.add('open');
            icon.style.transform = 'rotate(180deg)';
            if (!openSections.includes(sectionId)) {
                openSections.push(sectionId);
            }
        }
        
        localStorage.setItem('<?php echo $storageKey; ?>', JSON.stringify(openSections));
    });

    setTimeout(() => {
        isToggling = false;
    }, 30);
}

const debouncedToggleAccordion = debounce(toggleAccordion, 10);

document.addEventListener('DOMContentLoaded', function() {
    const storedOpenSections = localStorage.getItem('<?php echo $storageKey; ?>');
    let openSections;

    if (storedOpenSections === null) {
        openSections = <?php echo json_encode(array_keys($sections)); ?>;
        localStorage.setItem('<?php echo $storageKey; ?>', JSON.stringify(openSections));
    } else {
        openSections = JSON.parse(storedOpenSections);
    }

    openSections.forEach(sectionId => {
        const button = document.querySelector(`button[onclick*="${sectionId}"]`);
        const content = document.getElementById(sectionId + '-content');
        if (button && content) {
            const icon = button.querySelector('.material-symbols-outlined');
            content.classList.add('open');
            icon.style.transform = 'rotate(180deg)';
        }
    });

    setTimeout(() => {
        document.querySelectorAll('.no-transition').forEach(el => el.classList.remove('no-transition'));
    }, 0);
});
</script>

<style>
.no-transition {
    transition: none !important;
}

.accordion-content {
    transition: max-height 0.2s ease-out, opacity 0.1s ease-out;
    opacity: 0;
    max-height: 0;
    overflow: hidden;
}

.accordion-content.open {
    opacity: 1;
    max-height: 1000px;
}
</style>
<?php
endif;
}
?>