<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {

    $('#apikey').click(function() { this.select(); });

    $('#update_password_btn').click(function() {
        <?php if (is_demo_mode()) { ?>
        alert("<?php echo _('This action is not available in Demo Mode.'); ?>");
        <?php } else { ?>
        $('#change_password').modal('show');
        <?php } ?>
    });

    $('#update_pass_btn').click(function() {
        var vars = { old_pass: $('input[name="old_pass"]').val(),
                     new_pass: $('input[name="new_pass"]').val(), 
                     new_pass2: $('input[name="new_pass2"]').val(),
                     '<?php echo $csrf['name']; ?>': '<?php echo $csrf['hash']; ?>' }

        $('#update_pass_error').hide();
        $('#update_pass_msg').hide();

        $.post(site_url + 'auth/change_password', vars, function(data) {
            if (data.success == 1) { 
                $('#update_pass_msg').removeClass('alert-error').addClass('alert-success').html('<?php echo _('Your password was successfully changed'); ?>').show();
                $('input[type="password"]').val(''); // Clear fields
                $('#update_pass_msg').delay(2000).fadeOut(800);
            } else {
                $('#update_pass_msg').removeClass('alert-success').addClass('alert-error').html(data.errormsg).show();
            }
        }, 'json');
    });

    $('#update_profile_btn').click(function() {
        var vars = { name: $('input[name="name"]').val(),
                     email: $('input[name="email"]').val(),
                     simple_mode: $('input[name="simple_mode"]:checked').val(),
                     '<?php echo $csrf['name']; ?>': '<?php echo $csrf['hash']; ?>' }

        <?php if (is_demo_mode()) { ?>
        alert("<?php echo _('This action is not available in Demo Mode.'); ?>");
        <?php } else { ?>
        $.post(site_url + 'auth/update_profile', vars, function(data) {
            if (data.success == 1) {
                $('#update_profile_msg').removeClass('alert-error').addClass('alert-success').html('<?php echo _('Your profile information has been updated.'); ?>').show();
                $('#update_profile_msg').delay(1000).fadeOut(800);
            } else {
                $('#update_profile_msg').removeClass('alert-success').addClass('alert-error').html(data.errormsg).show();
            }
        }, 'json');
        <?php } ?>
    });

    // Change language
    $('#language').change(function() {
        var language = $(this).val();
        $.post(site_url + 'dashboard/setlanguage', { language: language, '<?php echo $csrf['name']; ?>': '<?php echo $csrf['hash']; ?>' }, function(data) {
            window.location.reload();
        });
    });

    $('select[name="theme"]').change(function() {
        var theme = $(this).val();
        $.post(site_url + 'dashboard/set_theme', { theme: theme, '<?php echo $csrf['name']; ?>': '<?php echo $csrf['hash']; ?>' }, function(data) {
            window.location.reload();
        });
    });

});
</script>

<div class="configure-layout">
    <div class="form-container">
        <div class="form-title"><?php echo _("My Profile"); ?></div>
        <div class="form-subtitle"><?php echo _("Edit your profile, contact information, account information, and manage your API key if you have API access."); ?></div>
        <div class="form-spacer"></div>
        <div class="form-header tw-mb-2"><?php echo _("Personal Information"); ?></div>
        <div class="form-subheader tw-mb-2"><?php echo _("Your personal information and account name."); ?></div>
        <div id="update_profile_msg" class="alert hide"></div>
        <div class="tw-w-1/4 tw-pb-2">
            <div class="tw-mb-2 tw-w-full">
                <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("Username"); ?></label>
                <input class="ui-input" type="text" value="<?php echo html_escape($user['username']); ?>" placeholder="Username" disabled="disabled">
            </div>
            <div class="tw-mb-2 tw-w-full">
                <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("Full Name"); ?></label>
                <input class="ui-input" type="text" name="name" value="<?php echo html_escape($user['name']); ?>" placeholder="Name">
            </div>
            <div class="tw-mb-6 tw-w-full">
                <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("Email"); ?></label>
                <input class="ui-input" type="text" name="email" value="<?php echo html_escape($user['email']); ?>" placeholder="Email">
            </div>
            <div class="tw-mb-6 tw-w-full">
                <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('Dashboard Mode'); ?>:</label>
                <input type="radio" id="simple_mode_true" name="simple_mode" value="true" <?php if ($user['simple_mode'] == 'true') { echo 'checked'; } ?>>
                <label for="simple_mode_true" class="tw-text-sm tw-font-medium"><?php echo _('Simple'); ?></label>
                <br/>
                <input type="radio" id="simple_mode_false" name="simple_mode" value="false" <?php if (empty($user['simple_mode']) || $user['simple_mode'] == 'false') { echo 'checked'; } ?>>
                <label for="simple_mode_false" class="tw-text-sm tw-font-medium"><?php echo _('Advanced'); ?></label>
            </div>
            <button id="update_profile_btn" class="ui-btn ui-btn-default"><?php echo _('Update'); ?></button>
        </div>
        <div class="form-spacer"></div>
        <div class="form-header tw-mb-2"><?php echo _('Account Actions'); ?></div>
        <div class="form-subheader tw-mb-2"><?php echo _('Make changes to your account-specific settings.'); ?></div>                
        <div class="tw-w-1/4 tw-pb-2">
            <div class="tw-mb-2 tw-w-full">
                <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("Language"); ?></label>
                <select id="language" name="language" class="ui-select">
                    <option value="default" <?php if ($user_language == 'default') { echo 'selected'; } ?>><?php echo _('Default'); ?></option>
                    <?php foreach ($languages as $l) { ?>
                    <option value="<?php echo $l; ?>" <?php if ($user_language == $language && $language == $l) { echo 'selected'; } ?>>
                        <?php echo get_language_name($l); ?>
                    </option>
                    <?php } ?>
                </select>
            </div>
            <div class="tw-mb-6 tw-w-full">
                <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('User Theme'); ?>:</label>
                <select name="theme" class="ui-select">
                    <?php foreach ($themes as $key => $value) { ?>
                    <option value="<?php echo $key ?>" <?php if ($user['theme'] == $key) { echo 'selected'; } ?>>
                        <?php echo $value; ?>
                    </option>
                    <?php } ?>
                </select>
            </div>
            <a role="button" class="ui-btn ui-btn-secondary" id="update_password_btn">
                <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                    <i class="material-symbols-outlined">lock</i>
                    <?php echo _('Change Password'); ?>
                </div>
            </a>
        </div>
        <div class="form-spacer"></div>
        <div class="form-header tw-mb-2 tw-flex tw-items-center tw-gap-2"><?php echo _('API Key'); ?>
            <a href="<?php echo base_url('help/api'); ?>" target="_blank" class="no-primary tw-flex tw-items-center tw-gap-1 tw-w-fit tw-rounded-md tw-bg-secondary tw-text-sm tw-p-1 tw-ring-foreground hover:tw-no-underline hover:tw-text-inherit active:tw-ring-1 active:tw-outline-none focus:tw-ring-1 focus:tw-outline-none focus:tw-ring focus:tw-no-underline focus:tw-text-inherit">
                <?php echo _("Docs"); ?>
                <i class="material-symbols-outlined small">open_in_new</i>
            </a>
        </div>
        <div class="form-subheader tw-mb-2"><?php echo _('Your unique API key used for external API access.'); ?></div>
        <div class="tw-w-[27%] tw-mb-4">
            <div class="">
            <?php if ($user['apiaccess']) { ?>
                <div class="tw-mb-2"><strong><?php echo _('Access Level'); ?>:</strong> <?php if ($is_admin) { echo _('Full'); } else { echo _('Read-Only'); } ?></div>
                <div class="tw-mb-6">
                    <input type="text" value="<?php echo $user['apikey']; ?>" class="ui-input tw-cursor-pointer" id="apikey" maxlength="32" readonly>
                </div>
            <?php echo form_open('profile/newkey'); ?>
                <input type="hidden" value="<?php echo $user['id']; ?>" name="user_id_verify" />
                <button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" class="ui-btn ui-btn-secondary">
                    <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                        <i class="material-symbols-outlined">autorenew</i>
                            <?php echo _('Generate New Key'); ?>
                    </div>
                </button>
            <?php echo form_close(); ?>
            <?php } else { ?>
                <p><strong><?php echo _('No API Access'); ?></strong></p>
            <?php } ?>
            </div>
        </div>
    </div>
</div>

<!-- Change Password Modal -->
<div id="change_password" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="change_password_header" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="change_password_header"><?php echo _('Change Password'); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div class="form-subheader"><?php echo _('Your new password must be 8 or more characters long for security.'); ?></div>
                <div id="update_pass_msg" class="alert hide tw-mb-0 tw-mt-4"></div>
                <div class="tw-grid tw-gap-4 tw-pt-8">
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                        <label class="tw-text-right tw-font-medium"><?php echo _('Old Password'); ?></label>
                        <input class="ui-input tw-col-span-2" type="password" name="old_pass"/>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                        <label class="tw-text-right tw-font-medium"><?php echo _('New Password'); ?></label>
                        <input class="ui-input tw-col-span-2" type="password" name="new_pass"/>
                    </div>
                    <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                        <label class="tw-text-right tw-font-medium"><?php echo _('Confirm New Password'); ?></label>
                        <input class="ui-input tw-col-span-2" type="password" name="new_pass2"/>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button id="update_pass_btn" class="ui-btn ui-btn-default tw-mr-1"><?php echo _('Update'); ?></button>
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _('Cancel'); ?></button>
            </div>
        </div>
    </div>
</div>


<?php echo $footer; ?>