<?php echo $header; ?>
<script>
    $(document).ready(function () {
        $('.delete').click(function(e) {
            e.preventDefault();
            $('#remove-confirm-modal').modal('show');
            let continue_function = function(href) {
                $.post(href, {}, function(data) {
                    if (data.hasOwnProperty('errmsg')) {
                        alert(data.errmsg);
                        return;
                    }
                    window.location.reload();
                }, 'json');
            } 
            $('#remove-continue').unbind();
            $('#remove-continue').click(() => continue_function(this.href));
        });
    })
</script>
<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">
        <h1 class="form-title"><?php echo _("Report Management"); ?></h1>
        <p class="form-subtitle"><?php echo _('To add a report, interact with the save icon on the dashboard page.'); ?></p>
        <div class="form-spacer"></div>
        <?php if (!empty($msg)) { ?>
        <div class="alert alert-<?php echo $msg_type; ?>"><a href='#' class='close' data-dismiss='alert'><i class="material-symbols-outlined">close</i></a><?php echo $msg; ?></div>
        <?php } ?>

        <table class="ui-table tw-my-6">
            <thead class="ui-thead">
                <tr class="ui-tr">
                    <th class="ui-th"><?php echo _("Report Name"); ?></th>
                    <th class="ui-th"><?php echo _("Created By"); ?></th>
                    <th class="ui-th tw-w-[140px]"></th>
                </tr>
            </thead>
            <tbody id="real-time-alert-list" class="ui-tbody">
                <?php
                    if (count($reports) > 0) {
                        foreach ($reports as $report) {
                ?>
                <tr class="ui-tr">
                    <td class="ui-td">
                        <?php echo html_escape($report['_source']['title']); ?>
                        <div class="clear"></div>
                    </td>
                    <td class="ui-td"><?php echo array_key_exists('user', $report['_source']) ? $report['_source']['user'] : _('&lt;Creator not found&gt;'); ?></td>
                    <td class="actions ui-td">
                        <dropdown-menu data-position="bottom">
                            <dropdown-trigger as-child>
                                <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                            </dropdown-trigger>
                            <dropdown-content class="ui-dropdown-content">
                                <a class="view ls-tooltip" href="<?php echo site_url('reports/view/' . $report["_id"]); ?>">
                                    <dropdown-item class="ui-dropdown-item">
                                        <?php echo _('View'); ?>
                                    </dropdown-item>
                                </a>
                                <a class="delete ls-tooltip" href="<?php echo site_url('api/report/delete/' . $report['_id']); ?>">
                                    <dropdown-item class="ui-dropdown-item">
                                        <?php echo _('Delete'); ?>
                                    </dropdown-item>
                                </a>
                            </dropdown-content>
                        </dropdown-menu>
                    </td>
                </tr>
                <?php 
                        } /* end foreach dashboard_reports */
                    } else {
                ?>
                <tr class="ui-tr">
                    <td class="ui-td" colspan="6"><?php echo _("You have no reports saved."); ?></td>
                </tr>
                <?php 
                    } 
                ?>
            </tbody>
        </table>
    </div>
</div>

<div id="remove-confirm-modal" class="modal hide fade" data-backdrop="static" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="form-header"><?php echo _("Apply Configuration?"); ?></h2>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body delete-modal-on-close">
                <?php echo _("This action will delete the report as well as any scheduled reports associated with it. Do you wish to continue?");?>
                <?php if (is_demo_mode()) { ?>
                <div class="alert alert-error">
                    <?php echo _("This function is not available in demo mode."); ?>
                </div>
                <?php } ?>
            </div>
            <div class="modal-footer tw-flex tw-space-x-2 tw-justify-end">
                <button type="button" id="remove-continue" class="ui-btn ui-btn-default" <?php if (is_demo_mode()) { echo 'disabled'; } ?>><?php echo _("Continue"); ?></button>
                <button type="button" id="remove-cancel" class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _("Cancel"); ?></button>
            </div>
        </div>
    </div>
</div>


<?php echo $footer; ?>