<?php echo $header; ?>

<div class="configure-layout">
    <div class="form-container">
        <h1 class="form-title"><?php echo _("Waiting for Database Startup"); ?></h1>
        <p class="form-subtitle"><?php echo _("It looks like your local OpenSearch service is still in the process of starting."); ?></p>
        <div class="form-spacer"></div>

        <div class="tw-flex tw-flex-col tw-gap-6 tw-w-full">
            <div class="ui-card tw-py-4">
                <h4 class="tw-text-lg tw-font-medium tw-mb-4"><?php echo _("Why am I getting this message?"); ?></h4>
                <p class="form-subtitle tw-mb-4 tw-text-secondary-foreground">
                    <?php echo sprintf(_('OpenSearch can take some time to initialize its indices. This may take a few seconds. If this persists for more than a minute, please %1$ssee this knowledge base article%2$s'), '<a href="https://support.nagios.com/kb/article/waiting-for-database-startup-1073.html" class="tw-text-primary hover:tw-underline">', '</a>'); ?>
                </p>
                <p class="tw-font-semibold tw-text-secondary-foreground">
                    <?php echo _("The page will refresh automatically after 5 seconds..."); ?>
                </p>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
$(function() {
    setInterval(refresh_page, 5000);
});

function refresh_page() {
    location.reload(true);
}
</script>

<?php echo $footer; ?>