#!/bin/bash
PATH=$PATH:/sbin:/usr/sbin

###############################
# USAGE / HELP
###############################
usage () {
	echo ""
	echo "Use this script change your Timezone for your Nagios Log Server system. (PHP and Localtime)"
	echo ""
	echo " -z | --zone             	The Posix & PHP supported timezone you want to change to"
	echo "                                  Example Timezone: America/Chicago"
	echo ""
	echo " -h | --help             	Show the help section"
	echo ""
}

###############################
# GET KEY SYSTEM PARAMS
###############################

# Get php.ini location
# Since this is executed via CLI, if the ini path includes /cli, we change it to /apache2 because this is used by the web server.
phpini=$(php -i | grep "Loaded Configuration File" | sed -E "s/.+=> (.+)/\1/g" | sed -E "s/cli/apache2/g")

# Get web server name so it can be restarted
httpd="httpd"
systemctl status apache2 >/dev/null 2>&1
has_apache2=$?
if [ "x$has_apache2" = "x0" ]; then
	httpd="apache2"
fi

crond="crond"
systemctl status cron >/dev/null 2>&1
has_cron=$?
if [ "x$has_cron" = "x0" ]; then
	crond="cron"
fi

###############################
# GET THE ARGS
###############################
while [ -n "$1" ]; do
	case "$1" in
		-h | --help)
			usage
			exit 0
			;;
		-z | --zone)
			TZONE=$2
			;;
	esac
	shift
done

if [ "x$TZONE" == "x" ] || [ ! -e /usr/share/zoneinfo/$TZONE ]; then
	echo "You must enter a proper time zone to change to (i.e. America/Chicago)"
	exit 1
fi

############################################
# CHANGE THE TIMEZONE FOR THE SYSTEM AND PHP
############################################

# Set the sysconfig clock time
if [ -e /etc/sysconfig/clock ]; then
	echo 'ZONE="'$TZONE'"' > /etc/sysconfig/clock
fi

# Set the localtime
ln -sf /usr/share/zoneinfo/$TZONE /etc/localtime

# Set the PHP timezone
for file in $(find /etc -name "php.ini"); do
	cp -f $file $file.backup
	sed -ri "s|^;?date\.timezone *=.*|date.timezone = \"$TZONE\"|" $file
done


# Restart apache and databases to make sure timezone is properly set
systemctl reload $httpd

# Restart php-fpm if necessary
systemctl status php-fpm >/dev/null 2>&1
has_php_fpm=$?
if [ "x$has_php_fpm" = "x0" ]; then
	systemctl reload php-fpm
fi

systemctl restart logstash
systemctl restart rsyslog
systemctl restart $crond

echo 'All timezone configurations updated to "'$TZONE'"'
