<?php

define('BASEPATH', dirname(__FILE__));

include '/var/www/html/nagioslogserver/application/config/config.local.php';
include 'index_data_helper.php';

$opensearch_password =  $config['opensearch_password'];

$long_options=["input:", "output:"];

$options = getopt("", $long_options);

$input = $options['input'];
$output = $options['output'];

print "Input: $input\nOutput: $output\n";

if (strpos($input, 'https://') !== false && strpos($output, 'https://') === false) {
    do_backup($input, $output);
} else if (strpos($input, 'https://') === false && strpos($output, 'https://') !== false) {
    do_restore($input, $output);
} else {
    print "There must be one OpenSearch input or output and one file input or output.\n";
    exit(1);
}

$source_url_base = '';
$destination_url_base = '';

function do_backup($input, $output) {
    global $opensearch_password, $source_url_base;

    $session = curl_init();

    if (!$session) {
        print "Curl Setup failed.\n";
        exit(1);
    }

    $results_per_query = 10000;
    $start = 0;
    $total_hits = 0;

    curl_setopt($session, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($session, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($session, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($session, CURLOPT_HTTPHEADER, array('Content-type: application/json'));
    curl_setopt($session, CURLOPT_USERPWD, 'nagioslogserver:' . $opensearch_password);

    $index = substr($input, strrpos("/$input", '/'));

    $source_url_base = substr($input, 0, strrpos("/$input", '/') - 1);

    $scroll_id = '1234';

    while (true) {
        $jsonl = "";
        $result = json_decode(get_documents_from_index($session, $index, $start, $results_per_query, true, $scroll_id), false);
        try {
            print "Looing at index $index from $start to " . $start + $results_per_query . " total hists so far: $total_hits\n";
            if (isset($result->hits->hits)) {
                $hit_count = count($result->hits->hits);
            } else {
                print json_encode($result);
                die;
            }
        } catch (Exception $exception) {
            print json_encode($result) . "\n";
        }
        $start += $hit_count;
        $total_hits += $hit_count;

        if (isset($result->_scroll_id)) {
            $scroll_id = $result->_scroll_id;
        }

        foreach ($result->hits->hits as $hit) {
            // TODO: Filter out existing dashboard and report id's so we don't try to recreate them
            $record = make_jsonl_for_record($index, $hit);
            $jsonl .= $record;
        }
        file_put_contents($output, $jsonl, FILE_APPEND);
        if ($hit_count < $results_per_query) {
            break;
        }
    }

    if ($scroll_id != '1234') {
        curl_setopt($session, CURLOPT_URL, "/_search/scroll/$scroll_id");
        curl_setopt($session, CURLOPT_CUSTOMREQUEST, 'DELETE');
        $result = curl_exec($session);
    }
}

function do_restore($input, $output) {
    global $destination_url_base;
    print "Restoring $input to $output\n";
    $file = new SplFileObject($input, 'r');
    $destination_url_base = $output;
    //substr($output, 0, strrpos("/$output", '/') - 1);

    $lines_per_batch = 1000;

    $jsonl = '';
    $lines_read = 0;

    $session = curl_init();

    if (!$session) {
        print "Curl Setup failed.\n";
        exit(1);
    }

    while(!$file->eof()) {
        $line = $file->fgets();
        $jsonl .= "$line";
        $lines_read++;

        if ($lines_read % $lines_per_batch == 0) {
            print "Restoring $lines_per_batch entries\n";
            do_bulk_insert($session, $jsonl);
            $jsonl = '';
        }
    }

    print "Restoring " . $lines_read % $lines_per_batch . " entries\n";
    do_bulk_insert($session, $jsonl);
}
