<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports extends LS_Controller
{
    function __construct()
    {
        parent::__construct();

        // Make sure that user is authenticated no matter what page they are on
        require_install();

        // Allow API authentication for reports (in case of wkhtmltopdf)
        $token = $this->input->get_post('token');
        if (!$this->users->logged_in() && !$this->token_has_api_access($token)) {
            $this->users->redirect_to_login();
        }

        $this->page = 'reports';

        $backend = new Elasticsearch(array('index' => "nagioslogserver_reports"));
        $username = $this->session->userdata('username');

        $report_query = 'user: ' . $username . ' OR user:global';
        $dashboard_reports = $backend->query_wresultSize("", $report_query);
        $this->dashboard_reports = $dashboard_reports['hits']['hits'];

        $default_query = 'user:default';
        $default_reports = $backend->query_wresultSize("", $default_query);
        $default_reports = $default_reports['hits']['hits'];

        $custom_order_titles = array(
            '404 Errors Report',
            '500 Errors Report',
            'SSH Errors Report',
            'AD Errors Report',
            'Account Lockout Report',
            'Password Change Report',
            'MySQL Errors Report',
            'Windows Firewall Report',
            'Network Outages Report',
            'Windows Updates Report',
            'Sendmail Report',
            'Logon Failure Report'
        );

        usort($default_reports, function($a, $b) use ($custom_order_titles) {
            return array_search($a["_source"]["title"], $custom_order_titles) - array_search($b["_source"]["title"], $custom_order_titles);
        });

        $this->default_reports = $default_reports;

        $backend = new Elasticsearch(array('index' => "nagioslogserver_scheduled_report"));
        $scheduled_query = 'type:scheduled_report && created_by:' . $username;
        $scheduled_reports = $backend->query_wresultSize("");
        $this->scheduled_reports = $this->prepare_scheduled_reports($scheduled_reports['hits']['hits']);
    }

    // Temporarily send to the host report
    public function index()
    {
        redirect('reports/report_management');
    }

    // View scheduled reports
    public function scheduled() {

        $this->init_page(_("Scheduled Reports"), $this->page);

        $email = $this->session->userdata('email');

        $this->data['schedule_modal'] = $this->load->view('reports/schedule', array('email' => $email), true);
        $this->data['scheduled_reports'] = $this->scheduled_reports;
        $this->data['leftbar'] = $this->load->view('reports/leftbar', array('scheduled_reports' => $this->scheduled_reports, 'dashboard_reports' => $this->dashboard_reports, 'default_reports' => $this->default_reports), true);
        $this->load->view('reports/scheduled', $this->data);

        return;
    }

    public function report_management() {

        $this->init_page(_("Report Management"), $this->page);

        $this->data['reports'] = array_merge($this->dashboard_reports, $this->default_reports);
        $this->data['leftbar'] = $this->load->view('reports/leftbar', array('scheduled_reports' => $this->scheduled_reports, 'dashboard_reports' => $this->dashboard_reports, 'default_reports' => $this->default_reports), true);
        $this->load->view('reports/report_management', $this->data);

        return;
    }

    private function prepare_scheduled_reports($reports) {

        foreach ($reports as &$report) {
            $report['_source']['id'] = $report['_id'];
            $report = $report['_source'];
            $report['formatted_time'] = '';
            if (intval($report['frequency']['hour']) == 0) {
                $report['frequency']['hour'] = '12';
            }
            $clocktime = $report['frequency']['hour'] . ':' . $report['frequency']['minute'] . ' ' . strtoupper($report['frequency']['ampm']);
            switch ($report['frequency']['which']) {
                case 'daily':
                    $report['formatted_time'] = sprintf(_('Daily - %s'), $clocktime);
                    break;
                case 'weekly':
                    $weekdays = array(_('Sunday'), _('Monday'), _('Tuesday'), _('Wednesday'), _('Thursday'), _('Friday'), _('Saturday'), _('Sunday'));
                    $report['formatted_time'] = sprintf(_('Weekly - %1$s on %2$s'), $clocktime, $weekdays[$report['frequency']['weekday']]);
                    break;
                case 'monthly':
                    $report['formatted_time'] = sprintf(_('Monthly - %1$s on day %2$s'), $clocktime, $report['frequency']['monthday']);
                    break;
                default:
                    break;
            }
        }
        
        return $reports;
    }

    public function view($id = null) 
    {
        if(!$id) {
            redirect('reports/report_management');
        }
        $this->load->helper('reporting');
        reporting_run_dashboard($id);
    }

    public function check_attachment($filename='') {
        $filePath = '/usr/local/nagioslogserver/tmp/' . $filename;
        if (file_exists($filePath)) {
            echo json_encode(['status' => 'success', 'message' => 'Found report.']);
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'not_found', 'message' => 'Report not found.']);
        }
    }

    public function view_attachment($filename='', $type='') {
        $filePath = '/usr/local/nagioslogserver/tmp/' . $filename;
        header('Content-Type: application/' . $type);
        header('Content-Disposition: inline; filename="' . $filename . '"');
        readfile($filePath);
        unlink($filePath);
    }

    public function shmeap() {
        return;
    }

    /**
     * This is a clone of the similarly named method in api_controller.php
     * Refactor this later.
     */
    private function token_has_api_access($token)
    {
        $this->load->library('session');
        $is_session = $this->session->userdata('apisession');

        if ($is_session == true) {
            $has_access = true;
        } else {

            if (empty($token)) {
                return false;
            }

            // Check if API key has access
            $q = 'apikey:'.$this->elasticsearch->sanitize($token);
            $query = $this->elasticsearch->query('user', $q);
            if(!empty($query) && $query['hits']['total']['value'] == 1) {
                $user = $query['hits']['hits'][0]['_source'];
                $this->session->set_userdata('username', $user['username']);
                $this->session->set_userdata('email', $user['email']);
                $this->session->set_userdata('ls_logged_in', 1);
                $this->session->set_userdata('apisession', 1);
                $this->session->set_userdata('language', $user['language']);
                $this->session->set_userdata('theme', $user['theme']);
                $this->session->set_userdata('user_id', $query['hits']['hits'][0]['_id']);
                $has_access = true;
            }
            else {
                echo "query hits total is {$query['hits']['total']['value']}";
                $has_access = false;
            }
        }

        return $has_access;
    }
}
