<?php 
class CLI_SynchronizeOpensearchConfiguration extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();

		if (!$this->input->is_cli_request()) {
			echo _("This class can only be accessed via the command line.");
			exit();
		}
	}

	public function run() {

		// Get own node name
		$es_root = new Elasticsearch([ 'index' => '/' ]);
		$configuration = $es_root->backend_call('_nodes/_local/');
		// With the security plugin enabled, the request will return a 503 until the plugin is initialized.
		// If we get a null, response, reattempt the query.
		$timeout = 0;
		while ($configuration === null && $configuration['nodes'] === null && $timeout < 60) {
			sleep(2);
			$configuration = $es_root->backend_call('_nodes/_local/');
			$timeout += 2;
		}
		$cluster_name = $configuration['cluster_name'];
		$node_name = '';
		// by invoking _local, this should only ever have one element, but it's still returned as an iterable
		foreach ($configuration['nodes'] as $id => $node) {
			$node_name = $node['name'];
		}

		// Put the node name in the `node_uuid` file.
		file_put_contents($this->config->item('node_uuid_file'), $node_name);

		// Put the cluster name in the `cluster_uuid` file
		file_put_contents($this->config->item('cluster_uuid_file'), $cluster_name);

		// Don't update cluster hosts, because there's already a cron job that does this.

	}
}